/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.chain;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.execution.ExecutorServiceProviderFactory;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.NextCallChainSubscriber;
import org.qubership.automation.itf.core.metric.MetricsAggregateService;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.event.CallChainEvent;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.testcase.TestCase;
import org.qubership.automation.itf.core.report.ReportLinkExtension;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.engine.TemplateEngine;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.qubership.automation.itf.core.util.manager.ExtensionManager;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.core.util.report.ReportLinkCollector;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;

@Service
public class CallChainExecutorService {
    private static final Logger log = LoggerFactory.getLogger(CallChainExecutorService.class);
    private final ReportLinkCollector reportLinkCollector;
    private final EventBusProvider eventBusProvider;
    private final MetricsAggregateService metricsAggregateService;
    private final boolean isBeforeIntegrationsOff = true;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;

    public void runBeforeIntegrations(CallChainInstance instance) {
    }

    private void _executeInstance(CallChainInstance instance) {
        TcContext tc = instance.getContext().tc();
        instance.setStatus(Status.IN_PROGRESS);
        instance.setStartTime(new Date());
        ExecutionServices.getTCContextService().start(tc);
        log.info("Executing Call Chain {}...", (Object)instance);
        this.runBeforeIntegrations(instance);
        this.eventBusProvider.post((Event)new CallChainEvent.Start(instance));
        NextCallChainEvent event = new NextCallChainEvent(null, instance);
        NextCallChainSubscriber subscriber = new NextCallChainSubscriber(event);
        subscriber.registerSubscriberInHolder();
        this.eventBusProvider.register(subscriber, EventBusProvider.Priority.HIGH);
        this.eventBusProvider.post((Event)event);
    }

    public CallChainInstance prepare(@Nonnull BigInteger projectId, @Nonnull UUID projectUuid, @Nonnull TestCase testCase, @Nullable TcContext context, @Nonnull Environment environment, @Nullable IDataSet dataSet, @Nullable JsonContext customDataset) throws Exception {
        return this.prepare(projectId, projectUuid, testCase, context, environment, dataSet, customDataset, false, false, true);
    }

    public CallChainInstance prepare(@Nonnull BigInteger projectId, @Nonnull UUID projectUuid, @Nonnull TestCase testCase, @Nullable TcContext context, @Nonnull Environment environment, @Nullable IDataSet dataSet, @Nullable JsonContext customDataset, boolean runValidation) throws Exception {
        return this.prepare(projectId, projectUuid, testCase, context, environment, dataSet, customDataset, true, runValidation, false);
    }

    public CallChainInstance prepare(@Nonnull BigInteger projectId, @Nonnull UUID projectUuid, @Nonnull TestCase testCase, @Nullable TcContext context, @Nonnull Environment environment, @Nullable IDataSet dataSet, @Nullable JsonContext customDataset, boolean startedByAtp, boolean runValidation) throws Exception {
        return this.prepare(projectId, projectUuid, testCase, context, environment, dataSet, customDataset, startedByAtp, runValidation, false);
    }

    public CallChainInstance prepare(@Nonnull BigInteger projectId, @Nonnull UUID projectUuid, @Nonnull TestCase testCase, @Nullable TcContext context, @Nonnull Environment environment, @Nullable IDataSet dataSet, @Nullable JsonContext customDataset, boolean startedByAtp, boolean runValidation, boolean isNestedStep) throws Exception {
        MdcUtils.put((String)MdcField.CALL_CHAIN_ID.toString(), (String)testCase.getID().toString());
        log.info("Preparing instance for call chain {}...", (Object)testCase);
        CallChainInstance instance = new CallChainInstance();
        instance.setID((Object)UniqueIdGenerator.generate());
        instance.setParent(null);
        instance.setStepContainer((StepContainer)testCase);
        instance.setName(testCase.getName());
        this.prepareContext(projectId, projectUuid, instance, context, dataSet, customDataset, environment, startedByAtp, runValidation);
        this.prepareKeys(instance);
        return instance;
    }

    public void refreshExtensionLinks(CallChainInstance instance) {
        try {
            Map links = this.reportLinkCollector.collect(instance.getContext().tc());
            ReportLinkExtension extension = (ReportLinkExtension)ExtensionManager.getInstance().getExtension((Object)instance.getContext().tc(), ReportLinkExtension.class);
            extension.getLinks().putAll(links);
            for (Map.Entry entry : links.entrySet()) {
                log.info("Report link for call chain {}. {} : {}", new Object[]{instance, entry.getKey(), entry.getValue()});
            }
        }
        catch (Throwable throwable) {
            log.error("Error while collecting of report links", throwable);
        }
    }

    private TcContext prepareContext(BigInteger projectId, UUID projectUuid, CallChainInstance instance, TcContext context, IDataSet dataSet, JsonContext customDataset, Environment env, boolean startedByAtp, boolean runValidation) {
        if (context == null) {
            context = this.createTcContext(projectId, projectUuid, instance, dataSet, env, startedByAtp, runValidation);
        } else if (context.getProjectId() == null) {
            context.setProjectId(projectId);
            context.setProjectUuid(projectUuid);
        }
        instance.getContext().setProjectId(projectId);
        instance.getContext().setProjectUuid(projectUuid);
        instance.getContext().setTC(context);
        if (customDataset != null) {
            if (dataSet != null) {
                context.merge((Map)dataSet.read(customDataset, (Object)context.getProjectId()));
                instance.setDatasetName(dataSet.getName());
            }
            context.merge((Map)customDataset);
        } else if (dataSet != null) {
            context.merge((Map)dataSet.read((Object)context.getProjectId()));
            instance.setDatasetName(dataSet.getName());
        }
        return context;
    }

    private void prepareKeys(CallChainInstance instance) {
        TemplateEngine engine = TemplateEngineFactory.get();
        InstanceContext context = instance.getContext();
        for (String key : ((CallChain)instance.getStepContainer()).getKeys()) {
            String parsedKey = engine.process((Storable)instance.getStepContainer(), key, (JsonContext)context, "CallChain Key '" + key + "'");
            if (StringUtils.isBlank((CharSequence)parsedKey) || !CacheServices.getTcBindingCacheService().bind(parsedKey, context.tc())) continue;
            log.info("Context key for instance {} is {}", (Object)instance, (Object)parsedKey);
        }
    }

    public CallChainInstance executeInstance(CallChainInstance instance) {
        this.metricsAggregateService.incrementCallChainCountToProject(instance.getContext().getTC().getProjectUuid(), instance.getName());
        ExecutorServiceProviderFactory.get().requestForRegular().submit(() -> this.execute(instance, "Error executing in separate thread {}"));
        return instance;
    }

    public void executeInstance(CallChainInstance instance, boolean waitForFulfillment) {
        String error = "Error executing in separate thread instance id {}";
        this.metricsAggregateService.incrementCallChainCountToProject(instance.getContext().getTC().getProjectUuid(), instance.getName());
        ExecutorServiceProviderFactory.get().requestForRegular().submit(this.createRunnableWithCurrentSecurityContext(instance, "Error executing in separate thread instance id {}"));
        if (waitForFulfillment) {
            this.waitStatusNotInProgress(instance);
        }
    }

    public void reportErrorThenStop(CallChainInstance instance, TcContext tcContext, String title, String errorTitle, String errorMessage, Throwable t) {
        if (!tcContext.isFinished()) {
            if (tcContext.isNeedToReportToAtp()) {
                Report.openSection((AbstractInstance)instance, (String)title);
                Report.error((AbstractInstance)instance, (String)errorTitle, (String)errorMessage, (Throwable)t);
                Report.closeSection((AbstractInstance)instance);
                Report.stopRun((InstanceContext)instance.getContext(), (Status)Status.FAILED);
            }
            ExecutionServices.getTCContextService().stopOnCurrentServiceInstance(tcContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(CallChainInstance instance, String errorMessage) {
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)String.valueOf(instance.getContext().getProjectUuid()));
        }
        String oldThreadName = this.cutTail(Thread.currentThread().getName(), " [");
        OffsetDateTime started = OffsetDateTime.now();
        TcContext tcContext = instance.getContext().tc();
        try {
            String curName = oldThreadName + " [" + tcContext.getID() + "] " + instance.getName();
            Thread.currentThread().setName(curName);
            TxExecutor.execute(() -> {
                this.fillMdsFields(instance);
                this._executeInstance(instance);
                log.info("Thread {}: instance is executed", (Object)curName);
                return null;
            }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
        }
        catch (Throwable t) {
            log.error(errorMessage, (Object)instance, (Object)t);
            this.reportErrorThenStop(instance, tcContext, "Errors while callchain startup or execution", t.getMessage(), t.getMessage(), t);
        }
        finally {
            if (!tcContext.isNotified()) {
                ExecutionServices.getTCContextService().notifyATP(tcContext);
            }
            Thread.currentThread().setName(oldThreadName);
            Duration durationBetween = Duration.between(started, OffsetDateTime.now());
            this.metricsAggregateService.recordExecuteCallchainDuration(tcContext.getProjectUuid(), instance.getName(), durationBetween);
            MDC.clear();
        }
    }

    private void fillMdsFields(CallChainInstance instance) {
        try {
            TcContext tc = instance.getContext().tc();
            MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)tc.getID().toString());
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)instance.getContext().getProjectUuid());
            MdcUtils.put((String)MdcField.CALL_CHAIN_ID.toString(), (String)instance.getTestCaseId().toString());
            String testRunId = (String)tc.get("testRunId", String.class);
            String executionRequestId = (String)tc.get("executionRequestId", String.class);
            if (StringUtils.isNotBlank((CharSequence)testRunId) && StringUtils.isNotBlank((CharSequence)executionRequestId)) {
                MdcUtils.put((String)MdcField.TEST_RUN_ID.toString(), (String)testRunId);
                MdcUtils.put((String)MdcField.EXECUTION_REQUEST_ID.toString(), (String)executionRequestId);
            }
        }
        catch (Exception e) {
            log.error("Can't fill MDC fields", (Throwable)e);
        }
    }

    private String cutTail(String str, String prefix) {
        int i = str.indexOf(prefix);
        return i == -1 ? str : str.substring(0, i);
    }

    private void waitStatusNotInProgress(CallChainInstance instance) {
        Status status = instance.getStatus();
        for (int i = 0; (Status.IN_PROGRESS.equals((Object)status) || Status.NOT_STARTED.equals((Object)status)) && i < 50; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("Callchain startup waiting is interrupted", (Throwable)e);
            }
            status = instance.getStatus();
        }
    }

    private Runnable createRunnableWithCurrentSecurityContext(CallChainInstance instance, String error) {
        Runnable originalRunnable = () -> this.execute(instance, error);
        SecurityContext context = SecurityContextHolder.getContext();
        return new DelegatingSecurityContextRunnable(originalRunnable, context);
    }

    private TcContext createTcContext(BigInteger projectId, UUID projectUuid, CallChainInstance instance, IDataSet dataSet, Environment environment, boolean startedByAtp, boolean runValidation) {
        TcContext context = ExecutionServices.getTCContextService().createInMemory(projectId, projectUuid);
        context.setStartedByAtp(startedByAtp);
        context.setNeedToReportToAtp(startedByAtp);
        context.setStartValidation(runValidation);
        context.setInitiator((AbstractContainerInstance)instance);
        context.setName(String.format("%s [%s]", instance.getName(), dataSet == null ? "No Data Set" : dataSet.getName()));
        context.setEnvironmentId((BigInteger)environment.getID());
        context.setEnvironmentName(environment.getName());
        context.setProjectId(projectId);
        context.setProjectUuid(projectUuid);
        context.setTimeToLive();
        return context;
    }

    @ConstructorProperties(value={"reportLinkCollector", "eventBusProvider", "metricsAggregateService"})
    public CallChainExecutorService(ReportLinkCollector reportLinkCollector, EventBusProvider eventBusProvider, MetricsAggregateService metricsAggregateService) {
        this.reportLinkCollector = reportLinkCollector;
        this.eventBusProvider = eventBusProvider;
        this.metricsAggregateService = metricsAggregateService;
    }
}

