/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.execution.subscriber;

import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.StepEndSituationSubscriber;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.provider.EventBusServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSituationSubscriber {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StepEndSituationSubscriber.class);
    private final TcContext context;
    private String parentEventID;

    public AbstractSituationSubscriber(TcContext context, String parentEventID) {
        this.context = context;
        this.parentEventID = parentEventID;
    }

    protected void finish(SituationEvent.EndExceptionalSituationFinish finishEvent) {
        finishEvent.stop();
        NextCallChainEvent event = this.createEvent();
        event.setID(this.parentEventID);
        LOGGER.warn("Executed from situation");
        EventBusServiceProvider.getStaticReference().post((Event)event);
        EventBusServiceProvider.getStaticReference().unregister(this);
        CacheServices.getAwaitingContextsCacheService().evict(String.format("%s_%s", finishEvent.getSituationInstance().getContext().tc().getID(), finishEvent.getSituationInstance().getSituationId()));
    }

    protected abstract NextCallChainEvent createEvent();

    @NotNull
    protected String getTenantId(SituationEvent.EndExceptionalSituationFinish event) {
        return event.getSituationInstance().getContext().getProjectUuid().toString();
    }

    protected TcContext getContext() {
        return this.context;
    }

    protected String getParentEventID() {
        return this.parentEventID;
    }

    protected void setParentEventID(String parentEventID) {
        this.parentEventID = parentEventID;
    }
}

