/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.execution.subscriber;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.instance.step.StepExecutorFactory;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.DefferedSituationInstanceHolder;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.NextCallChainEventSubscriberHolder;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.AbstractChainSubscriber;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.NextEmbeddedStepSubscriber;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.StepEndSituationSubscriber;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.StepExceptionalSituationSubscriber;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.condition.ConditionsHelper;
import org.qubership.automation.itf.core.model.event.CallChainEvent;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.event.NextEmbeddedStepEvent;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.regenerator.KeysRegenerator;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.iterator.CallChainStepIterator;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.provider.EventBusServiceProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextCallChainSubscriber
extends AbstractChainSubscriber<NextCallChainEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NextCallChainSubscriber.class);
    private static final int infiniteLoopProtectionBarrier = Integer.parseInt(Config.getConfig().getString("infinite.loop.protection.barrier"));
    private final CallChainStepIterator iterator;
    private final CallChainInstance instance;
    private final AtomicBoolean waiting = new AtomicBoolean(false);
    private boolean resumed = false;

    public NextCallChainSubscriber(NextCallChainEvent event) {
        super(event.getID(), event.getParentId());
        this.instance = (CallChainInstance)event.getInstance();
        this.iterator = this.instance.iterator();
    }

    public NextCallChainSubscriber(NextCallChainEvent event, CallChainStepIterator stepIterator) {
        super(event.getID(), event.getParentId());
        this.instance = (CallChainInstance)event.getInstance();
        this.iterator = stepIterator;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handle(NextCallChainEvent event) {
        if (!(event instanceof NextCallChainEvent.Exception)) {
            this.handleEvent(event);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void pause(NextCallChainEvent.Pause event) {
        LOGGER.info("NextCallChain event: {} is pausing", (Object)event.getInstance());
        this.waiting.set(true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void exception(NextCallChainEvent.Exception exception) {
        this.handleEvent(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void resume(NextCallChainEvent.Resume event) {
        LOGGER.info("NextCallChain event: {} is resuming", (Object)event.getInstance());
        this.waiting.set(false);
        AtomicBoolean atomicBoolean = this.waiting;
        synchronized (atomicBoolean) {
            this.waiting.notify();
        }
    }

    public void registerSubscriberInHolder() {
        NextCallChainEventSubscriberHolder.getInstance().add(this.instance.getContext().getTC().getID(), this.getId(), this.getParentId(), true);
    }

    @Override
    protected void onEvent(NextCallChainEvent event) {
        TcContext thisInstanceTcContext = this.instance.getContext().tc();
        TenantContext.setTenantInfo((String)thisInstanceTcContext.getProjectUuid().toString());
        try {
            ExecutionServices.getTCContextService().mergePendingContextsIfAny(thisInstanceTcContext);
            if (event instanceof NextCallChainEvent.Pause) {
                thisInstanceTcContext.setStatus(Status.PAUSED);
            } else if (event instanceof NextCallChainEvent.UpdateContext) {
                thisInstanceTcContext.merge((Map)((CallChainInstance)event.getInstance()).getContext().tc());
            } else if (event instanceof NextCallChainEvent.ResumeWithoutContinue) {
                thisInstanceTcContext.merge((Map)((CallChainInstance)event.getInstance()).getContext().tc());
                thisInstanceTcContext.setStatus(Status.IN_PROGRESS);
            } else {
                if (event instanceof NextCallChainEvent.Exception) {
                    if (this.getParentId() != null) {
                        this.sendFailEventToTheSubscriber(this.getParentId(), new Exception(((NextCallChainEvent.Exception)event).getExceptionMessage()));
                    }
                    throw new RuntimeException(((NextCallChainEvent.Exception)event).getExceptionMessage());
                }
                if (event instanceof NextCallChainEvent.Fail) {
                    this.failInstance((AbstractContainerInstance)this.instance, ((NextCallChainEvent.Fail)event).getException());
                    if (this.getParentId() != null) {
                        this.sendFailEventToTheSubscriber(this.getParentId(), ((NextCallChainEvent.Fail)event).getException());
                    } else {
                        ExecutionServices.getExecutionProcessManagerService().fail(thisInstanceTcContext);
                    }
                    this.destroy();
                } else if (event instanceof NextCallChainEvent.FailByTimeout) {
                    this.failInstance((AbstractContainerInstance)this.instance, ((NextCallChainEvent.FailByTimeout)event).getException());
                    if (this.getParentId() != null) {
                        this.sendFailEventToTheSubscriber(this.getParentId(), ((NextCallChainEvent.FailByTimeout)event).getException());
                    } else {
                        ExecutionServices.getExecutionProcessManagerService().failByTimeout(thisInstanceTcContext);
                    }
                    this.destroy();
                } else {
                    if (event instanceof NextCallChainEvent.Resume) {
                        thisInstanceTcContext.merge((Map)((CallChainInstance)event.getInstance()).getContext().tc());
                        thisInstanceTcContext.setStatus(Status.IN_PROGRESS);
                        if (thisInstanceTcContext.isRunStepByStep() && !((CallChainInstance)event.getInstance()).getContext().tc().isRunStepByStep()) {
                            thisInstanceTcContext.setRunStepByStep(((CallChainInstance)event.getInstance()).getContext().tc().isRunStepByStep());
                        }
                        this.resumed = true;
                    } else if (event instanceof NextCallChainEvent.ResumeStepWithContinueTc) {
                        thisInstanceTcContext.setValidationFailed(true);
                        this.resumed = true;
                    }
                    this.executeNext(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("TcContext id {}, Project [{}, {}], CallChain instance [{}] '{}', Step '{}': {}", new Object[]{thisInstanceTcContext.getID(), thisInstanceTcContext.getProjectId(), thisInstanceTcContext.getProjectUuid(), this.instance.getID(), this.instance.getName(), this.iterator.current().getName(), ExceptionUtils.getStackTrace((Throwable)e)});
            this.failInstance((AbstractContainerInstance)this.instance, e);
            ExecutionServices.getExecutionProcessManagerService().fail(thisInstanceTcContext);
            this.destroy();
        }
    }

    private void finishInstance() {
        if (this.getParentId() == null) {
            ExecutionServices.getCallChainExecutorService().refreshExtensionLinks(this.instance);
            this.finishContext();
        } else {
            this.finishInstanceAsPassed();
            this.postNextCallChain();
        }
        this.destroy();
    }

    private void processDelay(TimeUnit timeUnit, long delay) throws InterruptedException {
        if (delay > 0L) {
            if (timeUnit == null) {
                timeUnit = TimeUnit.SECONDS;
            }
            timeUnit.sleep(delay);
        }
    }

    private void postSituationStep(StepInstance stepInstance) {
        try {
            SituationStep situationStep = (SituationStep)stepInstance.getStep();
            Set endSituations = situationStep.getEndSituations();
            Set exceptionalSituations = situationStep.getExceptionalSituations();
            if (exceptionalSituations != null && !exceptionalSituations.isEmpty()) {
                this.registerSubscriberAndExceptionalSituations(stepInstance, exceptionalSituations);
            }
            if (endSituations != null && !endSituations.isEmpty()) {
                this.registerSubscriberAndEndSituations(stepInstance, endSituations, situationStep);
                StepExecutorFactory.executeStatic(stepInstance);
                return;
            }
            this.prepareAndExecuteSituationStep(stepInstance, situationStep);
        }
        catch (Exception e) {
            this.sendFailEventToTheSubscriber(this.getParentId() != null ? this.getParentId() : this.getId(), e);
        }
    }

    private void prepareAndExecuteSituationStep(StepInstance stepInstance, SituationStep situationStep) throws Exception {
        TemplateEngineFactory.get().process((Storable)situationStep, situationStep.getPreScript(), (JsonContext)stepInstance.getContext(), "pre-script of CallChain Step");
        KeysRegenerator.getInstance().regenerateKeys(stepInstance.getContext(), situationStep.getKeysToRegenerate());
        NextCallChainEvent callChainEvent = new NextCallChainEvent(this.getParentId(), this.instance);
        callChainEvent.setID(this.getId());
        try {
            IntegrationStep integrationStep = situationStep.getSituation().getIntegrationStep();
            this.addValidationRetryParametersToIntegrationStep(situationStep, integrationStep);
        }
        catch (Exception e) {
            LOGGER.info("Retry parameters weren't set to Integration Step for {} ", (Object)situationStep.getName());
        }
        ExecutionServices.getSituationExecutorService().execute(situationStep.getSituation(), stepInstance.getContext(), (Storable)situationStep.getSituation(), callChainEvent);
    }

    private void registerSubscriberAndEndSituations(StepInstance stepInstance, Set<Situation> endSituations, SituationStep situationStep) {
        StepEndSituationSubscriber subscriber = new StepEndSituationSubscriber(stepInstance.getContext().tc(), endSituations, this.getId(), situationStep.getWaitAllEndSituations());
        EventBusServiceProvider.getStaticReference().register(subscriber);
        String tcId = String.valueOf(stepInstance.getContext().tc().getID());
        for (Situation endSit : endSituations) {
            CacheServices.getAwaitingContextsCacheService().putIfAbsent(String.format("%s_%s", tcId, endSit.getID()), stepInstance.getStepId());
        }
    }

    private void registerSubscriberAndExceptionalSituations(StepInstance stepInstance, Set<Situation> exceptionalSituations) {
        StepExceptionalSituationSubscriber subscriber = new StepExceptionalSituationSubscriber(stepInstance.getContext().tc(), exceptionalSituations, this.getId());
        EventBusServiceProvider.getStaticReference().register(subscriber);
        String tcId = String.valueOf(stepInstance.getContext().tc().getID());
        for (Situation exceptionalSituation : exceptionalSituations) {
            CacheServices.getAwaitingContextsCacheService().putIfAbsent(String.format("%s_%s", tcId, exceptionalSituation.getID()), stepInstance.getStepId());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeNext(boolean forced) throws Exception {
        StepInstance stepInstance;
        boolean next;
        if (forced || this.iterator.current() == null) {
            if (!this.iterator.hasNext()) {
                this.finishInstance();
                return;
            }
            next = true;
        } else if (this.isAttemptsOrTimeAreOver(this.iterator.current())) {
            if (!this.iterator.hasNext()) {
                this.finishInstance();
                return;
            }
            next = true;
        } else {
            next = false;
        }
        StepInstance stepInstance2 = stepInstance = next ? this.iterator.next() : this.iterator.current();
        if (!this.validateStepCondition(stepInstance)) {
            this.executeNext(true);
            return;
        }
        if (next) {
            stepInstance.setStartTime(new Date());
        } else {
            AbstractCallChainStep callChainStep = (AbstractCallChainStep)stepInstance.getStep();
            LOGGER.info("Execute step again [iteration #{} of {}] due to retry conditions.\nConditions: {}.\nStepInstance: {}", new Object[]{stepInstance.getCurrentCondAttemptValue() + 1, callChainStep.getConditionMaxAttempts(), callChainStep.getConditionParameters(), stepInstance});
        }
        stepInstance.setCurrentCondAttemptValue(stepInstance.getCurrentCondAttemptValue() + 1);
        if (this.resumed) {
            this.reGetSituation(stepInstance);
        }
        this.executeStep(stepInstance);
    }

    private void reGetSituation(StepInstance stepInstance) {
        SituationStep step;
        Situation situation;
        if (stepInstance.getStep() instanceof SituationStep && (situation = (step = (SituationStep)stepInstance.getStep()).getSituation()) != null && situation.getID() != null) {
            Situation newSituation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById(situation.getID());
            step.setSituation(newSituation);
        }
    }

    private boolean isAttemptsOrTimeAreOver(StepInstance stepInstance) {
        AbstractCallChainStep step = (AbstractCallChainStep)stepInstance.getStep();
        if (!step.isConditionRetry()) {
            return stepInstance.getCurrentCondAttemptValue() > 0;
        }
        if (step.getConditionMaxAttempts() == 0 && step.getConditionMaxTime() == 0L) {
            if (step.getConditionParameters() == null || step.getConditionParameters().isEmpty()) {
                return true;
            }
            return infiniteLoopProtectionBarrier > 0 && stepInstance.getCurrentCondAttemptValue() >= infiniteLoopProtectionBarrier;
        }
        if (step.getConditionMaxAttempts() > 0 && stepInstance.getCurrentCondAttemptValue() >= step.getConditionMaxAttempts()) {
            return true;
        }
        return step.getConditionMaxTime() > 1L && step.getConditionMaxTime() <= step.retrieveConditionUnitMaxTime().convert(this.countPassedTime(stepInstance), TimeUnit.MILLISECONDS);
    }

    private void executeStep(StepInstance stepInstance) throws Exception {
        TcContext tc = this.instance.getContext().tc();
        if (stepInstance.getStep().isManual() || Status.PAUSED.equals((Object)tc.getStatus()) || tc.isRunStepByStep()) {
            if (Status.IN_PROGRESS.equals((Object)tc.getStatus())) {
                ExecutionServices.getTCContextService().pause(tc);
            }
            if (stepInstance.getStep() instanceof EmbeddedStep) {
                this.postNextEmbeddedStep(stepInstance);
            } else if (stepInstance.getStep() instanceof SituationStep) {
                this.addSituationStepToDeferredExecution(stepInstance);
            }
        } else {
            this.processDelay(stepInstance.getStep().retrieveUnit(), stepInstance.getStep().getDelay());
            if (stepInstance.getStep() instanceof EmbeddedStep) {
                this.postNextEmbeddedStep(stepInstance);
            } else if (stepInstance.getStep() instanceof SituationStep) {
                this.postSituationStep(stepInstance);
            }
        }
    }

    private boolean validateStepCondition(StepInstance stepInstance) {
        AbstractCallChainStep step = (AbstractCallChainStep)stepInstance.getStep();
        List conditionParameters = step.getConditionParameters();
        return !step.isConditionRetry() || conditionParameters == null || conditionParameters.isEmpty() || ConditionsHelper.isApplicable((JsonContext)stepInstance.getContext(), (List)conditionParameters);
    }

    private void postNextEmbeddedStep(StepInstance stepInstance) {
        NextEmbeddedStepEvent stepEvent = new NextEmbeddedStepEvent(this.getId(), stepInstance);
        stepEvent.setDataSetName(this.instance.getDatasetName());
        NextEmbeddedStepSubscriber stepSubscriber = new NextEmbeddedStepSubscriber(stepEvent.getID(), this.getId());
        this.subscribeAndPostEvent(stepSubscriber, stepEvent);
    }

    private void postNextCallChain() {
        NextCallChainEvent callChainEvent = new NextCallChainEvent(this.getParentId(), this.instance);
        callChainEvent.setID(this.getParentId());
        EventBusServiceProvider.getStaticReference().post((Event)callChainEvent);
    }

    private void finishInstanceAsPassed() {
        this.instance.setStatus(Status.PASSED);
        this.instance.setEndTime(new Date());
        LOGGER.info("Call chain {} executed", (Object)this.instance);
        EventBusServiceProvider.getStaticReference().post((Event)new CallChainEvent.Finish(this.instance));
    }

    private void finishInstanceAsFailed() {
        this.instance.setStatus(Status.FAILED);
        this.instance.setEndTime(new Date());
        LOGGER.error("Call chain {} failed", (Object)this.instance);
        EventBusServiceProvider.getStaticReference().post((Event)new CallChainEvent.Terminate(this.instance));
    }

    private void finishContext() {
        TcContext tc = this.instance.getContext().tc();
        if (tc == null) {
            this.finishInstanceAsPassed();
        } else if (tc.getStatus().equals((Object)Status.FAILED)) {
            ExecutionServices.getExecutionProcessManagerService().fail(tc);
            this.finishInstanceAsFailed();
        } else {
            ExecutionServices.getExecutionProcessManagerService().finish(tc);
            this.finishInstanceAsPassed();
        }
    }

    private void addSituationStepToDeferredExecution(StepInstance stepInstance) throws Exception {
        SituationStep situationStep = (SituationStep)stepInstance.getStep();
        SituationInstance situationInstance = ExecutionServices.getSituationExecutorService().prepare(situationStep.getSituation(), stepInstance.getContext());
        situationInstance.getSituationById().fillKeysToRegenerate(situationStep.getKeysToRegenerate());
        DefferedSituationInstanceHolder.getInstance().add(situationInstance.getContext().tc().getID(), situationInstance);
        Set endSituations = situationStep.getEndSituations();
        if (endSituations != null && !endSituations.isEmpty()) {
            StepEndSituationSubscriber subscriber = new StepEndSituationSubscriber(stepInstance.getContext().tc(), endSituations, this.getId(), situationStep.getWaitAllEndSituations());
            EventBusServiceProvider.getStaticReference().register(subscriber);
            NextCallChainEventSubscriberHolder.getInstance().add(stepInstance.getContext().getTC().getID(), this.getId(), this.getParentId(), false);
        } else {
            NextCallChainEventSubscriberHolder.getInstance().add(stepInstance.getContext().getTC().getID(), this.getId(), this.getParentId(), true);
        }
        LOGGER.warn(String.format("Situation %s is paused", situationInstance));
    }

    private void failInstance(AbstractContainerInstance instance, Exception e) {
        ExecutionServices.getCallChainExecutorService().refreshExtensionLinks((CallChainInstance)instance);
        instance.setError((Throwable)e);
        instance.setStatus(Status.FAILED);
        instance.setEndTime(new Date());
        EventBusServiceProvider.getStaticReference().post((Event)new CallChainEvent.Terminate((CallChainInstance)instance));
    }

    private long countPassedTime(StepInstance stepInstance) {
        return new Date().getTime() - stepInstance.getStartTime().getTime();
    }

    private void addValidationRetryParametersToIntegrationStep(SituationStep situationStep, IntegrationStep integrationStep) {
        integrationStep.setRetryOnFail(situationStep.isRetryOnFail());
        integrationStep.setRetryTimeout(situationStep.getRetryTimeout());
        integrationStep.setRetryTimeoutUnit(situationStep.getRetryTimeoutUnit());
        integrationStep.setValidationMaxAttempts(situationStep.getValidationMaxAttempts());
        integrationStep.setValidationMaxTime(situationStep.getValidationMaxTime());
        integrationStep.setValidationUnitMaxTime(situationStep.getValidationUnitMaxTime());
    }

    @Override
    protected void unregisterIfExpired() {
        TcContext tcContext = this.instance.getContext().tc();
        long lastAccess = tcContext.getLastUpdateTime();
        long failTimeout = tcContext.getTimeToLive();
        if (lastAccess > 0L && lastAccess + failTimeout <= System.currentTimeMillis()) {
            LOGGER.error("Subscriber {} [instanceId={}, tcContextId={}] is expired and it will be unregistered (the latest event was at {})", new Object[]{this.getClass().getSimpleName(), this.instance.getID(), tcContext.getID(), new Date(lastAccess)});
            this.destroy();
        }
    }

    @Override
    @NotNull
    protected String getTenantId(NextCallChainEvent event) {
        return ((CallChainInstance)event.getInstance()).getContext().getProjectUuid().toString();
    }

    public CallChainInstance getInstance() {
        return this.instance;
    }
}

