/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.execution.subscriber;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Set;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.AbstractSituationSubscriber;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;

public class StepExceptionalSituationSubscriber
extends AbstractSituationSubscriber {
    private final Set<Situation> exceptionalSituations;
    private String exceptionMessage = "";

    public StepExceptionalSituationSubscriber(TcContext context, Set<Situation> exceptionalSituations, String parentEventId) {
        super(context, parentEventId);
        this.exceptionalSituations = exceptionalSituations;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handle(SituationEvent.EndExceptionalSituationFinish event) {
        TenantContext.setTenantInfo((String)this.getTenantId(event));
        SituationInstance situationInstance = event.getSituationInstance();
        Situation situation = situationInstance.getSituationById();
        if (situationInstance.getContext().tc().equals((Object)this.getContext()) && this.exceptionalSituations.contains(situation)) {
            LOGGER.info("Got event Situation {} finished in context {}. Will trigger exception call in chain...", (Object)situation.getName(), (Object)this.getContext().getName());
            this.exceptionMessage = "Occurred exceptional situation: " + situation.getName();
            this.finish(event);
        } else {
            LOGGER.debug("Ignoring event {}", (Object)event);
        }
    }

    @Override
    protected NextCallChainEvent createEvent() {
        return new NextCallChainEvent.Exception(this.getParentEventID(), null, this.exceptionMessage);
    }
}

