/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.message.parser;

import com.google.common.collect.Maps;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.NativeManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.engine.TemplateEngine;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.helper.Reflection;
import org.qubership.automation.itf.core.util.logger.TimeLogger;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerMessageHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerMessageHelper.class);
    private static final ProducerMessageHelper INSTANCE = new ProducerMessageHelper();
    private TemplateEngine engine = TemplateEngineFactory.get();

    private ProducerMessageHelper() {
    }

    public static ProducerMessageHelper getInstance() {
        return INSTANCE;
    }

    public Message produceMessage(Template template, InstanceContext context, Operation operation, Environment environment) {
        TimeLogger.LOGGER.debug("Start for method: org.qubership.automation.itf.core.message.parser.ProducerMessageHelper.produceMessage(Template, InstanceContext, Operation, Environment)");
        if (Objects.isNull(operation) || Objects.isNull(environment)) {
            LOGGER.info("Operation and/or Environment are null");
            TimeLogger.LOGGER.debug("End for method: org.qubership.automation.itf.core.message.parser.ProducerMessageHelper.produceMessage(Template, InstanceContext, Operation, Environment)");
            return this.produceMessage(template, context, operation);
        }
        HashMap owners = Maps.newHashMap();
        owners.put("___owner___", template);
        owners.put("___operation___", operation);
        owners.put("___environment___", environment);
        if (context.tc() != null) {
            owners.put("___initiator___", context.tc().getInitiator());
        }
        Message message = new Message(this.engine.process((Map)owners, template.getText(), (JsonContext)context));
        TimeLogger.LOGGER.debug("End for method: org.qubership.automation.itf.core.message.parser.ProducerMessageHelper.produceMessage(Template, InstanceContext, Operation, Environment)");
        return this.prepareParseTemplateTransportProperties(template, context, message, operation.getTransport().getTypeName());
    }

    public Message produceMessage(Template template, InstanceContext context, Operation operation) {
        TimeLogger.LOGGER.debug("End for method: org.qubership.automation.itf.core.message.parser.ProducerMessageHelper.produceMessage(Template, InstanceContext, Operation)");
        Message message = new Message(this.engine.process((Storable)template, template.getText(), (JsonContext)context));
        TimeLogger.LOGGER.debug("End for method: org.qubership.automation.itf.core.message.parser.ProducerMessageHelper.produceMessage(Template, InstanceContext, Operation)");
        return this.prepareParseTemplateTransportProperties(template, context, message, operation.getTransport().getTypeName());
    }

    public Message produceMessage(Template template, InstanceContext context, String transportType) {
        Message message = new Message(this.engine.process((Storable)template, template.getText(), (JsonContext)context));
        return this.prepareParseTemplateTransportProperties(template, context, message, transportType);
    }

    private Message prepareParseTemplateTransportProperties(Template template, InstanceContext context, Message message, String transportType) {
        Collection transport = ((NativeManager)CoreObjectManager.getInstance().getSpecialManager(template.getClass(), NativeManager.class)).getChildrenByClass((Storable)template, OutboundTemplateTransportConfiguration.class, new Object[]{transportType});
        for (OutboundTemplateTransportConfiguration configuration : transport) {
            try {
                message = this.parseTemplateTransportProperties(message, configuration, template, context);
            }
            catch (TransportException e) {
                LOGGER.error("Transport type error: ", (Throwable)e);
            }
        }
        return message;
    }

    private Message parseTemplateTransportProperties(Message message, OutboundTemplateTransportConfiguration configuration, Template template, InstanceContext context) throws TransportException {
        if (Objects.isNull(configuration)) {
            return message;
        }
        AccessTransport accessTransport = TransportRegistryManager.getInstance().find(configuration.getTypeName());
        if (Objects.isNull(accessTransport)) {
            return message;
        }
        try {
            for (PropertyDescriptor property : accessTransport.getProperties()) {
                this.processingProperty(property, configuration, message, template, context);
            }
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e);
        }
        return message;
    }

    private void processingProperty(PropertyDescriptor property, OutboundTemplateTransportConfiguration configuration, Message message, Template template, InstanceContext context) {
        String propertyString = configuration.get((Object)property.getShortName());
        String logCoords = "Connection property '" + property.getShortName() + "'";
        if (property.isDynamic() && !StringUtils.isBlank((CharSequence)propertyString)) {
            if (property.isMap()) {
                if (propertyString.startsWith("$") || propertyString.startsWith("#")) {
                    propertyString = this.engine.process((Storable)template, propertyString, (JsonContext)context, logCoords);
                }
                Map<String, Object> map = this.splitToMap(propertyString);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (entry.getValue() instanceof List) {
                        List oldlist = (List)entry.getValue();
                        ArrayList<String> newlist = new ArrayList<String>();
                        for (String elem : oldlist) {
                            newlist.add(this.engine.process((Storable)template, elem, (JsonContext)context, logCoords));
                        }
                        entry.setValue(newlist);
                        continue;
                    }
                    entry.setValue(this.engine.process((Storable)template, (String)entry.getValue(), (JsonContext)context, logCoords));
                }
                message.getConnectionProperties().put(property.getShortName(), map);
            } else {
                message.getConnectionProperties().put(property.getShortName(), this.engine.process((Storable)template, propertyString, (JsonContext)context, logCoords));
            }
        }
    }

    private Map<String, Object> splitToMap(String in) {
        return Reflection.toStringMap((String)in);
    }
}

