/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.report.impl;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.report.LinkCollector;

public class TemplateBasedLinkCollector
implements LinkCollector {
    @Parameter(shortName="system", longName="System", description="System in this environment to collect reference", optional=true)
    private System system;
    @Parameter(shortName="template", longName="Template to render", description="Template which will be rendered as url", optional=true)
    private String template;
    @Parameter(shortName="bv.conf.path", longName="BV configuration path", description="bv_environment_name/bv_system_name/bv_connection_name", optional=true)
    private String path;

    public Pair<String, String> collect(TcContext context, LinkCollectorConfiguration configuration) {
        String url = TemplateEngineFactory.process((Storable)context.getEnvironmentById(), (String)configuration.get((Object)"template"), (JsonContext)InstanceContext.from((TcContext)context, null));
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return Pair.of((Object)configuration.getName(), (Object)url);
        }
        String base = "unknownhost/";
        String strSystem = configuration.get((Object)"system");
        for (Map.Entry entry : context.getEnvironmentById().getOutbound().entrySet()) {
            if (!((System)entry.getKey()).getID().toString().equals(strSystem)) continue;
            base = ((Server)entry.getValue()).getUrl();
            if (url.startsWith("/") || base.endsWith("/")) break;
            url = "/" + url;
            break;
        }
        return Pair.of((Object)configuration.getName(), (Object)(base + url));
    }

    public boolean common() {
        return false;
    }
}

