/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.report.producer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ReportUtilsCache {
    private static volatile ReportUtilsCache executorServiceCache;
    private Map<BigInteger, ExecutorService> executorServiceByProject = Maps.newConcurrentMap();
    private Map<BigInteger, ObjectMapper> mapperByProject = Maps.newConcurrentMap();

    private ReportUtilsCache() {
        if (executorServiceCache != null) {
            throw new RuntimeException("Use getInstance() method to get the single instance of this class.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportUtilsCache getInstance() {
        if (executorServiceCache != null) return executorServiceCache;
        Class<ReportUtilsCache> clazz = ReportUtilsCache.class;
        synchronized (ReportUtilsCache.class) {
            if (executorServiceCache != null) return executorServiceCache;
            executorServiceCache = new ReportUtilsCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorServiceCache;
        }
    }

    public ExecutorService getExecutorService(BigInteger projectId) {
        return this.executorServiceByProject.get(projectId);
    }

    public void addExecutorService(BigInteger projectId, ExecutorService executorService) {
        this.executorServiceByProject.put(projectId, executorService);
    }

    public ObjectMapper getMapper(BigInteger projectId) {
        return this.mapperByProject.get(projectId);
    }

    public void addMapper(BigInteger projectId, ObjectMapper mapper) {
        this.mapperByProject.put(projectId, mapper);
    }
}

