/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.report.producer;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.math.BigInteger;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.commons.lang3.BooleanUtils;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.annotation.AtpSpanTag;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.execution.DaemonThreadPoolFactory;
import org.qubership.automation.itf.core.instance.step.impl.IntegrationStepHelper;
import org.qubership.automation.itf.core.metric.MetricsAggregateService;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.report.producer.ReportUtilsCache;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ReportWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportWorker.class);
    private static final int WARN_ABOUT_SIZE = Config.getConfig().getIntOrDefault("report.producer.warnAboutSize", 5000000);
    private static final int MAX_SIZE = Config.getConfig().getIntOrDefault("report.producer.maxSize", 6000000);
    @Value(value="${report.producer.useGroupingMessages}")
    private boolean useGroupingMessages;
    @Value(value="${management.metrics.context.size.collect}")
    private boolean metricsContextSizeCollect;
    @Value(value="${management.metrics.context.size.collect.for.stubs}")
    private boolean metricsContextSizeCollectForStubs;
    @Value(value="${management.metrics.context.size.collect.threshold}")
    private int metricsContextSizeCollectThreshold;
    private ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private MetricsAggregateService metricsAggregateService;

    @Autowired
    public ReportWorker(ExecutorToMessageBrokerSender executorToMessageBrokerSender, MetricsAggregateService metricsAggregateService) {
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.metricsAggregateService = metricsAggregateService;
    }

    private static String objectDescription(Storable object) {
        if (object instanceof AbstractInstance) {
            return object.getClass().getSimpleName() + " id=" + object.getID() + ", name '" + object.getName() + "' of " + ReportWorker.objectDescription((Storable)((AbstractInstance)object).getContext().getTC());
        }
        return object.getClass().getSimpleName() + " id=" + object.getID() + ", name '" + object.getName() + "'";
    }

    private static boolean isReportExecutionEnabled(BigInteger projectId) {
        return BooleanUtils.toBoolean((String)Config.getConfig().getStringOrDefault("report.execution.enabled", "true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectMapper getMapper(BigInteger projectId) {
        if (ReportWorker.isReportExecutionEnabled(projectId)) {
            ObjectMapper mapper = ReportUtilsCache.getInstance().getMapper(projectId);
            if (mapper == null) {
                BigInteger bigInteger = projectId;
                synchronized (bigInteger) {
                    SimpleModule module = new SimpleModule("mb"){

                        public void setupModule(Module.SetupContext context) {
                            super.setupModule(context);
                            context.appendAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
                        }
                    };
                    mapper = new ObjectMapper();
                    mapper.registerModule((Module)module);
                    mapper.disable(SerializationFeature.INDENT_OUTPUT);
                    mapper.setFilterProvider((FilterProvider)ReportWorker.configureFilterProvider());
                    ReportUtilsCache.getInstance().addMapper(projectId, mapper);
                }
            }
            return mapper;
        }
        return null;
    }

    private static SimpleFilterProvider configureFilterProvider() {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("reportWorkerFilter_InstanceContext", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"transport", "version", "history", "collectHistory", "prefix", "description", "empty", "messageBrokerSelectorValue", "extendsParameters", "extensionsJson"}));
        filterProvider.addFilter("reportWorkerFilter_TCContext", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"version", "history", "collectHistory", "prefix", "description", "empty", "lastAccess", "needToReportToAtp", "validationFailed", "extendsParameters", "natural_id", "runStepByStep", "running", "finished", "runnable", "parent", "partNum"}));
        filterProvider.addFilter("reportWorkerFilter_SPContext", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"version", "history", "collectHistory", "prefix", "description", "empty", "extendsParameters"}));
        filterProvider.addFilter("reportWorkerFilter_MessageParameter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "name", "autosave", "version", "storableProp", "extendsParameters"}));
        filterProvider.addFilter("reportWorkerFilter_CallChainInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "datasetDefault", "running", "finished", "transportConfiguration", "version", "storableProp", "extendsParameters", "extensionsJson"}));
        filterProvider.addFilter("reportWorkerFilter_SituationInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "running", "finished", "transportConfiguration", "version", "storableProp", "extendsParameters", "extensionsJson"}));
        filterProvider.addFilter("reportWorkerFilter_StepInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "running", "finished", "version", "step", "storableProp", "extendsParameters", "extensionsJson"}));
        filterProvider.addFilter("reportWorkerFilter_Message", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"name", "parent", "prefix", "description", "file", "transportProperties", "failedMessage", "version", "storableProp", "extendsParameters", "extensionsJson"}));
        return filterProvider;
    }

    private void send(Storable object, Date date, boolean reportExecutionEnabled, BigInteger projectId, String tenantId) {
        block6: {
            if (reportExecutionEnabled) {
                ObjectMapper mapper = ReportWorker.getMapper(projectId);
                try {
                    this.serializeAndSend(object, date, projectId, mapper, tenantId);
                }
                catch (Throwable e) {
                    Throwable cause = e.getCause();
                    LOGGER.warn("Error executing reporting task: {} {}\nObject: {}", new Object[]{e.getMessage(), cause != null ? "\nCaused by: " + cause : "", ReportWorker.objectDescription(object)});
                    if (!(cause instanceof ConcurrentModificationException)) break block6;
                    try {
                        LOGGER.info("Retrying once after ConcurrentModificationException (sleep 100 ms before)...");
                        Thread.sleep(100L);
                        this.serializeAndSend(object, date, projectId, mapper, tenantId);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable ex) {
                        LOGGER.error("Error executing reporting task: {} {}\nObject: {}", new Object[]{ex.getMessage(), ex.getCause() != null ? "\nCaused by: " + ex.getCause() : "", ReportWorker.objectDescription(object)});
                    }
                }
            }
        }
    }

    private void send(String text, long time, String id, String type, String tenantId, int partNum) throws Throwable {
        try {
            this.executorToMessageBrokerSender.sendMessageToReportingQueue(this.createTextMessage(text, time, id, type, tenantId, partNum));
            LOGGER.debug("Message is sent: id - {}, type - {}", (Object)id, (Object)type);
        }
        catch (JMSException e) {
            throw new Throwable(String.format("Error while sending message: id - %s, type - %s", id, type), e);
        }
    }

    private void serializeAndSend(Storable object, Date date, BigInteger projectId, ObjectMapper mapper, String tenantId) throws Throwable {
        int partNum;
        String type;
        if (object instanceof CallChainInstance) {
            TcContext tc = ((CallChainInstance)object).getContext().getTC();
            if (tc != null && tc.getInitiator() == object) {
                LOGGER.debug("CallChainInstance {} is Initiator of TcContext {}, sending is skipped", object.getID(), tc.getID());
                return;
            }
        } else if (object instanceof StepInstance) {
            return;
        }
        String jsonString = mapper.writeValueAsString((Object)object);
        if (object instanceof TcContext && ((TcContext)object).getInitiator() != null) {
            TcContext tcContext = (TcContext)object;
            AbstractContainerInstance initiator = tcContext.getInitiator();
            if (initiator.getName() == null) {
                type = "TcContext";
            } else {
                String jsonStringInitiator = mapper.writeValueAsString((Object)initiator);
                jsonString = "{\"TcContext\":" + jsonString + ",\"Initiator\":" + jsonStringInitiator + "}";
                type = "Combined_TcContext_Initiator";
            }
            partNum = tcContext.getPartNum();
            this.collectContextSizeMetric(tcContext, initiator, jsonString.length());
        } else if (object instanceof SituationInstance) {
            SituationInstance situationInstance = (SituationInstance)object;
            String logMessage = "Report SituationInstance: [" + situationInstance.getID() + "] " + situationInstance.getName();
            jsonString = "{\"SituationInstance\":" + jsonString + (situationInstance.getID().equals(situationInstance.getContext().tc().getInitiator().getID()) ? ",\"isInitiator\" : true" : ",\"isInitiator\" : false") + ",\"StepInstances\": [";
            if (situationInstance.getStepInstances() != null) {
                boolean notFirst = false;
                List stepInstances = situationInstance.getStepInstances();
                int stepInstancesSize = stepInstances.size();
                for (int i = 0; i < stepInstancesSize; ++i) {
                    StepInstance stepInstance = (StepInstance)stepInstances.get(i);
                    if (i < stepInstancesSize - 1 && IntegrationStepHelper.notLastValidationAttempt(stepInstance, (StepInstance)stepInstances.get(i + 1))) continue;
                    this.fillReportingObjectsIds(stepInstance);
                    String jsonStringStepInstance = mapper.writeValueAsString((Object)stepInstance);
                    jsonString = jsonString + (notFirst ? "," : "") + jsonStringStepInstance;
                    logMessage = logMessage + ", StepInstance: [" + stepInstance.getID() + "] " + stepInstance.getName();
                    notFirst = true;
                }
            }
            jsonString = jsonString + "]}";
            type = "Combined_SituationInstance_StepInstances";
            partNum = situationInstance.getContext().tc().getPartNum();
            LOGGER.debug(logMessage);
        } else {
            type = object.getClass().getSimpleName();
            LOGGER.debug("Message of type {} is sent", (Object)type);
            if (object instanceof AbstractInstance) {
                partNum = ((AbstractInstance)object).getContext().tc().getPartNum();
            } else {
                partNum = 1;
                LOGGER.warn("Object type {}: Cannot determine partNum; 1 is set", (Object)type);
            }
        }
        if (WARN_ABOUT_SIZE > 0 || MAX_SIZE > 0) {
            int length = jsonString.length();
            if (MAX_SIZE > 0 && length > MAX_SIZE) {
                LOGGER.error("Attempt to send too big object: projectId {}, object: {}, message size: {} - REJECTED", new Object[]{projectId, ReportWorker.objectDescription(object), length});
                return;
            }
            if (WARN_ABOUT_SIZE > 0 && length >= WARN_ABOUT_SIZE) {
                LOGGER.warn("Attempt to send too big object: projectId {}, object: {}, message size: {}", new Object[]{projectId, ReportWorker.objectDescription(object), length});
            }
        }
        long startTime = System.currentTimeMillis();
        this.send(jsonString, date.getTime(), !Objects.isNull(object.getID()) ? object.getID().toString() : UUID.randomUUID().toString(), type, tenantId, partNum);
        long duration = System.currentTimeMillis() - startTime;
        if (duration > 100L) {
            LOGGER.info("ReportWorker: too long send - {} ms, {}", (Object)duration, (Object)ReportWorker.objectDescription(object));
        }
    }

    private void collectContextSizeMetric(TcContext tcContext, AbstractContainerInstance initiator, int size) {
        if (!this.metricsContextSizeCollect || this.metricsContextSizeCollectThreshold > 0 && size < this.metricsContextSizeCollectThreshold || !this.metricsContextSizeCollectForStubs && initiator instanceof SituationInstance) {
            return;
        }
        this.metricsAggregateService.incrementContextSizeCountToProject(tcContext.getProjectUuid(), (initiator instanceof SituationInstance ? "[Stub] " : "") + (initiator.getName() == null ? tcContext.getName() : initiator.getName()), size);
    }

    private void fillReportingObjectsIds(StepInstance stepInstance) {
        InstanceContext context = stepInstance.getContext();
        if (context != null) {
            this.setIdIfNull((Storable)context);
            SpContext spContext = context.getSP();
            if (spContext != null) {
                this.setIdIfNull((Storable)spContext);
                this.setIdIfNull((Storable)spContext.getIncomingMessage());
                this.setIdIfNull((Storable)spContext.getOutgoingMessage());
                if (spContext.getMessageParameters() != null) {
                    for (MessageParameter parameter : spContext.getMessageParameters()) {
                        this.setIdIfNull((Storable)parameter);
                    }
                }
            }
        }
    }

    private void setIdIfNull(Storable object) {
        if (object != null && object.getID() == null) {
            object.setID((Object)UniqueIdGenerator.generateReportingId());
        }
    }

    private TextMessage createTextMessage(String text, long time, String id, String type, String tenantId, int partNum) throws JMSException {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(text);
        message.setLongProperty("Time", time);
        message.setStringProperty("ObjectID", id);
        message.setStringProperty("ObjectType", type);
        if (this.useGroupingMessages) {
            message.setStringProperty("JMSXGroupID", id);
        }
        message.setStringProperty("X-Project-Id", tenantId);
        message.setIntProperty("partNum", partNum);
        return message;
    }

    private ExecutorService getExecutorService(BigInteger projectId) {
        if (ReportWorker.isReportExecutionEnabled(projectId)) {
            ExecutorService executorService = ReportUtilsCache.getInstance().getExecutorService(projectId);
            if (executorService == null) {
                executorService = DaemonThreadPoolFactory.cachedThreadPool(this.getReportExecutionSenderThreadPoolSize(projectId), "ReportWorker - ");
                ReportUtilsCache.getInstance().addExecutorService(projectId, executorService);
            }
            return executorService;
        }
        return null;
    }

    @AtpJaegerLog(spanTags={@AtpSpanTag(key="submit.object.name", value="#object.name")})
    public void submit(Storable object, Date date, BigInteger projectId, String tenantId) {
        MdcUtils.put((String)MdcField.TRACE_ID.toString(), (String)MDC.get((String)MdcField.STUB_TRACE_ID.toString()));
        boolean reportExecutionEnabled = ReportWorker.isReportExecutionEnabled(projectId);
        if (reportExecutionEnabled) {
            if (this.isReportInDifferentThread(projectId)) {
                this.getExecutorService(projectId).submit(new Worker(object, date, reportExecutionEnabled, projectId, tenantId));
            } else {
                this.send(object, date, reportExecutionEnabled, projectId, tenantId);
            }
        }
    }

    private boolean isReportInDifferentThread(BigInteger projectId) {
        return BooleanUtils.toBoolean((String)Config.getConfig().getStringOrDefault("report.in.different.thread", "false"));
    }

    private int getReportExecutionSenderThreadPoolSize(BigInteger projectId) {
        return Integer.parseInt(Config.getConfig().getStringOrDefault("report.execution.sender.thread.pool.size", "10"));
    }

    private class Worker
    implements Runnable {
        private Storable object;
        private Date date;
        private boolean reportExecutionEnabled;
        private BigInteger projectId;
        private String projectUuid;

        private Worker(Storable object, Date date, boolean reportExecutionEnabled, BigInteger projectId, String projectUuid) {
            this.object = object;
            this.date = date;
            this.reportExecutionEnabled = reportExecutionEnabled;
            this.projectId = projectId;
            this.projectUuid = projectUuid;
        }

        @Override
        public void run() {
            ReportWorker.this.send(this.object, this.date, this.reportExecutionEnabled, this.projectId, this.projectUuid);
        }
    }
}

