/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.copier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.simple.JSONObject;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

public class SmartCopier {
    private static final String NEED_OTHER_SERVER = "needOtherServer";
    private static final String NEED_NEW_SERVER = "needNewServer";
    private static final String USE_STANDARD_TRIGGERS = "useStandardTriggers";
    private static final String SERVER = "server";
    private static final String SYSTEMS = "systems";
    private static final String STANDARD_TRIGGERS = "standardTriggers";
    private static final String TRIGGER_PROPERTIES = "triggerProperties";
    private static final String PROPERTY_VALUE = "propertyValue";
    private static final String PROPERTY = "property";
    private static final String PROPERTIES = "properties";
    private static final String DESTINATION_FOLDER = "destinationFolder";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String NAME = "name";

    public static Storable setAllValuesOnCopyStorable(Storable copiedSource, Storable source, JSONObject jsonObject, String projectId) {
        if (copiedSource instanceof Environment) {
            return SmartCopier.setAllValuesOnCopyEnvironment((Environment)copiedSource, (Environment)source, jsonObject, projectId);
        }
        return copiedSource;
    }

    /*
     * WARNING - void declaration
     */
    private static Storable setAllValuesOnCopyEnvironment(Environment environment, Environment sourceEnvironment, JSONObject jsonObject, String projectId) {
        if (SmartCopier.isJsonObjectValid(jsonObject)) {
            void var9_14;
            Map<String, String> systemMap;
            Map currentJsonMapForInbound;
            ArrayList replacements = (ArrayList)jsonObject.get((Object)"replacements");
            environment.setName(jsonObject.get((Object)NAME).toString());
            if (jsonObject.containsKey((Object)DESTINATION_FOLDER)) {
                JSONObject folderProperties = new JSONObject((Map)jsonObject.get((Object)DESTINATION_FOLDER));
                EnvFolder destinationFolder = (EnvFolder)CoreObjectManager.getInstance().getManager(EnvFolder.class).getById(folderProperties.get((Object)ID));
                environment.setParent(destinationFolder);
            }
            if (!(currentJsonMapForInbound = (Map)jsonObject.get((Object)SERVER)).get(NAME).equals("")) {
                Server inboundServer = SmartCopier.createNewServer(new JSONObject((Map)jsonObject.get((Object)SERVER)), projectId);
                if (Objects.isNull(inboundServer)) {
                    return environment;
                }
                if (Boolean.valueOf(jsonObject.get((Object)USE_STANDARD_TRIGGERS).toString()).booleanValue()) {
                    SmartCopier.prepareTemplateTriggers(environment.getInbound().entrySet(), inboundServer, new JSONObject((Map)jsonObject.get((Object)TRIGGER_PROPERTIES)));
                }
                Map<String, String> systemMap2 = SmartCopier.parseListJsonMapsToMap((List)jsonObject.get((Object)SYSTEMS), "systemId", TYPE, "inbound", "status");
                for (Map.Entry<System, Server> entry : environment.getInbound().entrySet()) {
                    SmartCopier.setServerIfNeed(inboundServer, entry, systemMap2, false, replacements);
                }
            } else {
                if (Boolean.valueOf(jsonObject.get((Object)USE_STANDARD_TRIGGERS).toString()).booleanValue()) {
                    SmartCopier.prepareTemplateTriggers(environment.getInbound().entrySet(), null, new JSONObject((Map)jsonObject.get((Object)TRIGGER_PROPERTIES)));
                }
                systemMap = SmartCopier.parseListJsonMapsToMap((List)jsonObject.get((Object)SYSTEMS), "systemId", TYPE, "inbound", "status");
                for (Map.Entry<System, Server> entry : environment.getInbound().entrySet()) {
                    SmartCopier.setServerIfNeed(null, entry, systemMap, false, replacements);
                }
            }
            systemMap = SmartCopier.parseListJsonMapsToMap((List)jsonObject.get((Object)SYSTEMS), "systemId", TYPE, "outbound", "status");
            ArrayList newServers = (ArrayList)jsonObject.get((Object)"uniqueOutbounds");
            ArrayList<Server> arrayList = new ArrayList<Server>();
            boolean bl = false;
            while (var9_14 < newServers.size()) {
                if (!((LinkedHashMap)newServers.get((int)var9_14)).get("newServerName").equals("")) {
                    Server server = SmartCopier.createNewServer(new JSONObject((Map)jsonObject.get((Object)SERVER)), projectId);
                    server.setName((String)((LinkedHashMap)newServers.get((int)var9_14)).get("newServerName"));
                    server.setUrl((String)((LinkedHashMap)newServers.get((int)var9_14)).get("newUrl"));
                    arrayList.add(server);
                } else {
                    arrayList.add(null);
                }
                ++var9_14;
            }
            for (Map.Entry<System, Server> entry : environment.getOutbound().entrySet()) {
                for (int i = 0; i < newServers.size(); ++i) {
                    LinkedHashMap currentObjectMap = (LinkedHashMap)((LinkedHashMap)newServers.get(i)).get("currentObject");
                    LinkedHashMap currentServerMap = (LinkedHashMap)currentObjectMap.get(SERVER);
                    String currentServerName = (String)currentServerMap.get(NAME);
                    if (!currentServerName.equals(((Server)entry.getValue()).getName())) continue;
                    SmartCopier.setServerIfNeed((Server)arrayList.get(i), entry, systemMap, true, replacements);
                }
            }
        }
        environment.store();
        return environment;
    }

    private static void copyInbounds(Map.Entry<System, Server> entry, Server server, Set<TriggerConfiguration> standardTriggers) {
        Collection inbounds = entry.getValue().getInbounds(entry.getKey());
        for (InboundTransportConfiguration inbound : inbounds) {
            InboundTransportConfiguration newInboundTransportConfiguration = SmartCopier.copyInboundTransportConfiguration(inbound, server);
            SmartCopier.fillTriggers(newInboundTransportConfiguration.getTriggerConfigurations(), standardTriggers);
        }
    }

    private static void setServerIfNeed(Server server, Map.Entry<System, Server> entry, Map<String, String> systemMapStatus, boolean isOutbound, ArrayList<LinkedHashMap<String, String>> replacements) {
        for (Map.Entry<String, String> systemStatus : systemMapStatus.entrySet()) {
            if (!systemStatus.getKey().equals(entry.getKey().getID().toString()) || !Boolean.valueOf(systemStatus.getValue()).booleanValue()) continue;
            if (isOutbound) {
                Collection confs = entry.getValue().getOutbounds(entry.getKey());
                ArrayList<OutboundTransportConfiguration> newConfs = new ArrayList<OutboundTransportConfiguration>();
                for (OutboundTransportConfiguration conf : confs) {
                    OutboundTransportConfiguration newConf = new OutboundTransportConfiguration(conf.getTypeName(), server, conf.getSystem());
                    newConf.fillConfiguration(conf.getConfiguration());
                    for (LinkedHashMap<String, String> replaceMap : replacements) {
                        String oldValue = replaceMap.get("searchstring");
                        String newValue = replaceMap.get("replacement");
                        for (String checkingKey : newConf.getConfiguration().keySet()) {
                            String checkingValue = (String)newConf.getConfiguration().get(checkingKey);
                            if (!StringUtils.isNotEmpty((CharSequence)checkingValue) || !checkingValue.trim().contains(oldValue.trim())) continue;
                            int indexPosition = checkingValue.trim().indexOf(oldValue.trim());
                            String firstPartSubString = checkingValue.trim().substring(0, indexPosition);
                            String secondPartSubString = checkingValue.trim().substring(indexPosition + oldValue.trim().length());
                            newConf.getConfiguration().replace(checkingKey, firstPartSubString + newValue + secondPartSubString);
                        }
                    }
                    newConfs.add(newConf);
                }
                server.getOutbounds().addAll(newConfs);
            }
            entry.setValue(server);
        }
    }

    private static void fillTriggers(Set<TriggerConfiguration> inConfigurations, Set<TriggerConfiguration> outConfigurations) {
        for (Configuration configuration : inConfigurations) {
            for (Configuration configuration2 : outConfigurations) {
                SmartCopier.fillParamsConfigIfTypeIsSame(configuration, configuration2);
            }
        }
    }

    private static void fillParamsConfigIfTypeIsSame(Configuration in, Configuration out) {
        if (out.getTypeName().equals(in.getTypeName())) {
            in.putAll(out.getConfiguration());
            in.store();
        }
    }

    private static InboundTransportConfiguration copyInboundTransportConfiguration(InboundTransportConfiguration copiedInbound, Server parent) {
        InboundTransportConfiguration newInboundTransportConfiguration = new InboundTransportConfiguration(copiedInbound.getReferencedConfiguration(), parent);
        for (TriggerConfiguration trigger : copiedInbound.getTriggerConfigurations()) {
            TriggerConfiguration triggerConfiguration = new TriggerConfiguration(newInboundTransportConfiguration);
            triggerConfiguration.fillConfiguration(trigger.getConfiguration());
            triggerConfiguration.store();
            newInboundTransportConfiguration.getTriggerConfigurations().add(triggerConfiguration);
        }
        newInboundTransportConfiguration.store();
        return newInboundTransportConfiguration;
    }

    private static Server createNewServer(JSONObject json, String projectId) {
        Server server = (Server)CoreObjectManager.getInstance().getManager(Server.class).create(CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)projectId));
        server.setName(json.get((Object)NAME).toString());
        server.setUrl(json.get((Object)"url").toString());
        return server;
    }

    private static void prepareTemplateTriggers(Set<Map.Entry<System, Server>> entries, Server server, JSONObject json) {
        for (Map.Entry<System, Server> entry : entries) {
            Collection inbounds = entry.getValue().getInbounds(entry.getKey());
            for (InboundTransportConfiguration inbound : inbounds) {
                InboundTransportConfiguration newInboundTransportConfiguration = SmartCopier.copyInboundTransportConfiguration(inbound, server);
                for (Object triggerProperty : json.entrySet()) {
                    JSONObject jsonObject = new JSONObject((Map)((Map.Entry)triggerProperty).getValue());
                    TriggerConfiguration triggerConfiguration = new TriggerConfiguration();
                    triggerConfiguration.setTypeName(jsonObject.get((Object)TYPE).toString());
                    String property = jsonObject.get((Object)PROPERTY).toString();
                    String propertyValue = jsonObject.get((Object)PROPERTY_VALUE).toString();
                    Map<String, String> configuration = SmartCopier.parseListJsonMapsToMap((LinkedHashMap)jsonObject.get((Object)PROPERTIES), NAME, "value");
                    triggerConfiguration.fillConfiguration(configuration);
                    for (Configuration in : newInboundTransportConfiguration.getTriggerConfigurations()) {
                        if (in.get((Object)property) == null || !in.get((Object)property).toString().equals(propertyValue)) continue;
                        SmartCopier.fillParamsConfigIfTypeIsSame(in, (Configuration)triggerConfiguration);
                    }
                }
            }
        }
    }

    private static Map<String, String> parseListJsonMapsToMap(List<Map<String, String>> mapParams, String nameKey, String nameFilter, String filter, String nameValue) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (Map<String, String> param : mapParams) {
            if (!param.get(nameFilter).equals(filter)) continue;
            Pair<String, String> pair = SmartCopier.parseJsonMapToPair(param, nameKey, nameValue);
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(CharSequence)pair.getKey(), (CharSequence)pair.getValue()})) continue;
            configuration.put((String)pair.getKey(), (String)pair.getValue());
        }
        return configuration;
    }

    private static Map<String, String> parseListJsonMapsToMap(LinkedHashMap<String, Map<String, String>> mapParams, String nameKey, String nameValue) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (Map<String, String> param : mapParams.values()) {
            Pair<String, String> pair = SmartCopier.parseJsonMapToPair(param, nameKey, nameValue);
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(CharSequence)pair.getKey(), (CharSequence)pair.getValue()})) continue;
            configuration.put((String)pair.getKey(), (String)pair.getValue());
        }
        return configuration;
    }

    private static Pair<String, String> parseJsonMapToPair(Map<String, String> map, String nameKey, String nameValue) {
        String key = "";
        String value = "";
        for (Map.Entry<String, String> option : map.entrySet()) {
            if (!Objects.nonNull(option.getKey()) || !Objects.nonNull(option.getValue())) continue;
            if (option.getKey().equals(nameKey)) {
                key = option.getValue();
            }
            if (!option.getKey().equals(nameValue)) continue;
            value = String.valueOf(option.getValue());
        }
        return Pair.of((Object)key, (Object)value);
    }

    private static boolean isJsonObjectValid(JSONObject jsonObject) {
        return jsonObject.containsKey((Object)SYSTEMS) && jsonObject.containsKey((Object)NEED_OTHER_SERVER) && jsonObject.containsKey((Object)USE_STANDARD_TRIGGERS) && jsonObject.containsKey((Object)STANDARD_TRIGGERS) && jsonObject.containsKey((Object)NEED_NEW_SERVER) && jsonObject.containsKey((Object)NAME) && jsonObject.containsKey((Object)SERVER);
    }
}

