/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import org.qubership.automation.itf.executor.cache.hazelcast.CommonHazelcastConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonHazelcastConfig.class})
@ConditionalOnProperty(value={"hazelcast.cache.enabled"}, havingValue="false")
public class LocalHazelcastConfig {
    @Bean(name={"hazelcastClient"})
    public HazelcastInstance hazelcastInstance() {
        Config config = new Config();
        config.setClusterName("local-itf-hazelcast-cluster");
        config.setInstanceName("local-itf-hc-cache-instance");
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        CommonHazelcastConfig.tryToCreateMapConfigsIfNotExist(hazelcastInstance, false);
        return hazelcastInstance;
    }
}

