/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.hazelcast.listener;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.listener.EntryEvictedListener;
import java.util.Objects;
import org.qubership.automation.diameter.connection.ConnectionFactory;
import org.qubership.automation.itf.core.model.diameter.DiameterConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiameterConnectionInfoEvictedListener
implements EntryEvictedListener<Object, DiameterConnectionInfo> {
    private static final Logger log = LoggerFactory.getLogger(DiameterConnectionInfoEvictedListener.class);

    public void entryEvicted(EntryEvent<Object, DiameterConnectionInfo> entryEvent) {
        String localCacheId = ((DiameterConnectionInfo)entryEvent.getOldValue()).getConnectionId();
        log.info("Evict event is received for diameter connection id: {}", (Object)localCacheId);
        if (Objects.isNull(ConnectionFactory.getExisting((Object)localCacheId))) {
            log.info("Connection was already invalidated from local cache. Diameter connection id: {}", (Object)localCacheId);
            return;
        }
        ConnectionFactory.destroy((Object)localCacheId);
        log.info("Diameter connection is destroyed from local cache. Diameter connection id: {}", (Object)localCacheId);
    }
}

