/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.service;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.time.LocalDateTime;
import java.util.Optional;
import org.qubership.automation.itf.monitoring.tasks.RunningScheduledTask;
import org.qubership.automation.itf.monitoring.tasks.ScheduledTaskKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"hazelcast.cache.enabled"})
public class RunningScheduledTasksCacheService {
    private static final Logger log = LoggerFactory.getLogger(RunningScheduledTasksCacheService.class);
    private final HazelcastInstance hazelcastClient;

    @Autowired
    public RunningScheduledTasksCacheService(@Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
    }

    public Optional<RunningScheduledTask> findByScheduledTaskKey(ScheduledTaskKey scheduledTaskKey) {
        return Optional.ofNullable(this.getRunningTasksCache().get((Object)scheduledTaskKey.getKeyRepresentation()));
    }

    public void storeRunningTaskToCache(ScheduledTaskKey scheduledTaskKey) {
        this.getRunningTasksCache().put((Object)scheduledTaskKey.getKeyRepresentation(), (Object)new RunningScheduledTask(LocalDateTime.now()));
    }

    public void evictRunningTaskFromCache(ScheduledTaskKey scheduledTaskKey) {
        this.getRunningTasksCache().remove((Object)scheduledTaskKey.getKeyRepresentation());
        log.debug("Task {} was evicted from running scheduled tasks cache", (Object)scheduledTaskKey);
    }

    private IMap<String, RunningScheduledTask> getRunningTasksCache() {
        return this.hazelcastClient.getMap("ATP_ITF_RUNNING_SCHEDULED_TASKS");
    }
}

