/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.service.impl;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TCContextCacheService {
    private static final Logger log = LoggerFactory.getLogger(TCContextCacheService.class);
    private HazelcastInstance hazelcastClient;

    @Autowired
    public void setHazelcastClient(@Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
    }

    public long getLastAccess(TcContext tcContext) {
        EntryView entryView = this.getTCContextCache().getEntryView(tcContext.getID());
        if (Objects.isNull(entryView)) {
            return System.currentTimeMillis();
        }
        return Math.max(entryView.getLastAccessTime(), entryView.getLastUpdateTime());
    }

    public long getExpirationTime(TcContext tcContext) {
        if (Objects.isNull(tcContext)) {
            log.error("Can't get valid expiration time for tc context.. Tc Context is null. Returned value is 0");
            return 0L;
        }
        EntryView entryView = this.getTCContextCache().getEntryView(tcContext.getID());
        return Objects.isNull(entryView) ? 0L : entryView.getExpirationTime();
    }

    public long getEntryCount() {
        return this.getTCContextCache().size();
    }

    public TcContext getById(Object contextId) {
        return (TcContext)this.getTCContextCache().get((Object)IdConverter.toBigInt((Object)contextId));
    }

    public List<TcContext> getAllTcContexts(String podName) {
        LinkedList<TcContext> contexts = new LinkedList<TcContext>();
        for (Map.Entry contextEntry : this.getTCContextCache()) {
            if (!((TcContext)contextEntry.getValue()).getPodName().equals(podName)) continue;
            contexts.add((TcContext)contextEntry.getValue());
        }
        return contexts;
    }

    public void set(TcContext tcContext, boolean forced) {
        long ttl = tcContext.getTimeToLive();
        try {
            if (forced) {
                this.getTCContextCache().set(tcContext.getID(), (Object)tcContext, ttl, TimeUnit.MILLISECONDS);
                log.debug("TcContext {} was set to {} cache. forced=true", tcContext.getID(), (Object)"ATP_ITF_TC_CONTEXTS");
            } else {
                TcContext oldTcContext = (TcContext)this.getTCContextCache().putIfAbsent(tcContext.getID(), (Object)tcContext, ttl, TimeUnit.MILLISECONDS);
                log.debug(Objects.isNull(oldTcContext) ? "TcContext {} was put to {} cache. forced=false" : "TcContext {} wasn't put to {} cache. Already in cache and forced=false.", tcContext.getID(), (Object)"ATP_ITF_TC_CONTEXTS");
            }
        }
        catch (HazelcastSerializationException ex) {
            log.error("Can't serialize TcContext to put/set into ATP_ITF_TC_CONTEXTS.", (Throwable)ex);
        }
        catch (Exception e) {
            log.error("Something went wrong while set/putIfAbsent TcContext to {} cache", (Object)"ATP_ITF_TC_CONTEXTS");
        }
    }

    public void evict(TcContext tcContext) {
        this.getTCContextCache().evict(tcContext.getID());
    }

    private IMap<Object, TcContext> getTCContextCache() {
        return this.hazelcastClient.getMap("ATP_ITF_TC_CONTEXTS");
    }
}

