/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.config.jms;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Configuration
@EnableJms
public class ExecutorIntegrationConfig {
    public static final TransactionDefinition STUB_TRANSACTION_DEFINITION = ExecutorIntegrationConfig.initTransactionDefinition();
    @Value(value="${message-broker.url}")
    private String brokerUrl;
    @Value(value="${message-broker.useCompression}")
    private String useCompression;
    @Value(value="${message-broker.useAsyncSend}")
    private String useAsyncSend;
    @Value(value="${message-broker.queuePrefetch}")
    private int queuePrefetch;
    @Value(value="${message-broker.reports.useCompression}")
    private String reportsUseCompression;
    @Value(value="${message-broker.reports.useAsyncSend}")
    private String reportsUseAsyncSend;
    @Value(value="${message-broker.reports.maxThreadPoolSize}")
    private int maxThreadPoolSize;
    @Value(value="${message-broker.reports.connectionsPoolSize}")
    private int connectionsPoolSize;

    private static TransactionDefinition initTransactionDefinition() {
        int timeoutSeconds = 0;
        String stubsProcessingDurationTimeMax = System.getProperty("stubs.processing.duration.time.max");
        if (StringUtils.isNotEmpty((CharSequence)stubsProcessingDurationTimeMax)) {
            try {
                timeoutSeconds = Integer.parseInt(stubsProcessingDurationTimeMax);
            }
            catch (NumberFormatException ex) {
                timeoutSeconds = 0;
            }
        }
        if (timeoutSeconds <= 0) {
            return TxExecutor.readOnlyTransaction();
        }
        DefaultTransactionDefinition readonlyWithTimeout = new DefaultTransactionDefinition(0);
        readonlyWithTimeout.setReadOnly(true);
        readonlyWithTimeout.setTimeout(timeoutSeconds);
        return readonlyWithTimeout;
    }

    @Bean
    public ActiveMQConnectionFactory defaultActiveMqConnectionFactory() {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory();
        activeMQConnectionFactory.setBrokerURL(this.brokerUrl);
        activeMQConnectionFactory.setUseCompression(Boolean.parseBoolean(this.useCompression));
        activeMQConnectionFactory.setUseAsyncSend(Boolean.parseBoolean(this.useAsyncSend));
        activeMQConnectionFactory.setAlwaysSyncSend(!activeMQConnectionFactory.isUseAsyncSend());
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(this.queuePrefetch);
        activeMQConnectionFactory.setPrefetchPolicy(prefetchPolicy);
        return activeMQConnectionFactory;
    }

    @Bean
    public ActiveMQConnectionFactory reportsActiveMQConnectionFactory() {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory();
        activeMQConnectionFactory.setBrokerURL(this.brokerUrl);
        activeMQConnectionFactory.setMaxThreadPoolSize(this.maxThreadPoolSize);
        activeMQConnectionFactory.setUseCompression(Boolean.parseBoolean(this.reportsUseCompression));
        activeMQConnectionFactory.setUseAsyncSend(Boolean.parseBoolean(this.reportsUseAsyncSend));
        activeMQConnectionFactory.setAlwaysSyncSend(!activeMQConnectionFactory.isUseAsyncSend());
        return activeMQConnectionFactory;
    }

    @Bean
    public ConnectionFactory reportsPooledConnectionFactory(ActiveMQConnectionFactory reportsActiveMQConnectionFactory) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setConnectionFactory((Object)reportsActiveMQConnectionFactory);
        pooledConnectionFactory.setMaxConnections(this.connectionsPoolSize);
        pooledConnectionFactory.setCreateConnectionOnStartup(true);
        return pooledConnectionFactory;
    }

    @Bean
    public MessageConverter simpleMessageConverter() {
        return new SimpleMessageConverter();
    }

    @Bean
    public MessageConverter jacksonJmsMessageConverter() {
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setTargetType(MessageType.TEXT);
        converter.setTypeIdPropertyName("_type");
        converter.setObjectMapper(this.executorIntegrationObjectMapper());
        return converter;
    }

    @Bean
    public MessageConverter endSituationsJacksonJmsMessageConverter() {
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setTargetType(MessageType.TEXT);
        converter.setTypeIdPropertyName("_type");
        converter.setObjectMapper(this.endExceptionalSituationsMapper());
        return converter;
    }

    @Bean
    public ObjectMapper executorIntegrationObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.setFailOnUnknownId(false);
        filterProvider.addFilter("reportWorkerFilter_SituationInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "running", "finished", "transportConfiguration", "version", "iterator"}));
        objectMapper.setFilterProvider((FilterProvider)filterProvider);
        return objectMapper;
    }

    @Bean
    public ObjectMapper endExceptionalSituationsMapper() {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.setFailOnUnknownId(false);
        filterProvider.addFilter("reportWorkerFilter_SituationInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "running", "finished", "transportConfiguration", "version", "iterator", "stepContainer"}));
        filterProvider.addFilter("reportWorkerFilter_InstanceContext", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"transport", "version", "history", "collectHistory", "prefix", "description", "empty"}));
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.setFilterProvider((FilterProvider)filterProvider);
        return objectMapper;
    }
}

