/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.config.jms.listener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Objects;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.commons.lang3.EnumUtils;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.diameter.config.ConfigReader;
import org.qubership.automation.diameter.dictionary.DictionaryConfig;
import org.qubership.automation.itf.core.execution.ExecutorServiceProviderFactory;
import org.qubership.automation.itf.core.message.DictionaryReloadMessage;
import org.qubership.automation.itf.core.message.TcContextOperationMessage;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.service.TCContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MultiReplicaJMSListeners {
    private static final Logger log = LoggerFactory.getLogger(MultiReplicaJMSListeners.class);
    private final ObjectMapper executorIntegrationObjectMapper;
    private final TCContextService tcContextService;

    @JmsListener(destination="${message-broker.executor-sync-reload-dictionary.topic}", containerFactory="defaultJmsListenerTopicContainerFactory")
    public void onSyncReloadDictionaryMessage(ActiveMQTextMessage activeMQTextMessage) {
        try {
            DictionaryReloadMessage message = (DictionaryReloadMessage)this.executorIntegrationObjectMapper.readValue(activeMQTextMessage.getText(), DictionaryReloadMessage.class);
            ConfigReader.read((DictionaryConfig)new DictionaryConfig(message.getDictionaryPath(), message.getParserClass(), message.getProject()), (boolean)true);
            log.info("Diameter dictionary is successfully reloaded on pod {}", (Object)Config.getConfig().getRunningHostname());
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
        }
        catch (Exception ee) {
            log.error("Diameter dictionary reloading is failed: {}", (Object)ee.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @JmsListener(destination="${message-broker.executor-tccontext-operations.topic}", containerFactory="defaultJmsListenerTopicContainerFactory")
    public void onTcContextOperationsMessage(ActiveMQTextMessage activeMQTextMessage) {
        try {
            TcContextOperationMessage message = (TcContextOperationMessage)this.executorIntegrationObjectMapper.readValue(activeMQTextMessage.getText(), TcContextOperationMessage.class);
            BigInteger contextId = message.getId();
            if (contextId == null) {
                throw new IllegalArgumentException("Parameter 'contextId' is null or missed");
            }
            MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)contextId.toString());
            String newState = message.getStatus();
            if (newState == null) {
                throw new IllegalArgumentException(String.format("Context ID=%s: Parameter 'state' (Context state) is null or missed", contextId));
            }
            if (!EnumUtils.isValidEnum(Status.class, (String)newState)) {
                throw new IllegalArgumentException(String.format("Context ID=%s: Parameter 'state' (Context state) value is incorrect: '%s'", contextId, newState));
            }
            TcContext tcContext = CacheServices.getTcContextCacheService().getById(contextId);
            if (Objects.isNull(tcContext)) {
                throw new IllegalArgumentException(String.format("Context ID=%s: Context isn't found by id", contextId));
            }
            if (!tcContext.getPodName().equals(Config.getConfig().getRunningHostname())) {
                return;
            }
            ExecutorServiceProviderFactory.get().requestForRegular().submit(() -> this.progressingTcContext(tcContext, Status.valueOf((String)newState), contextId));
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while 'TcContext Operations' message processing: {}", (Object)e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    @JmsListener(destination="${message-broker.executor-disabling-stepbystep.topic}", containerFactory="defaultJmsListenerTopicContainerFactory")
    public void onTcContextDisablingStepByStep(ActiveMQTextMessage activeMQTextMessage) {
        try {
            String contextId = activeMQTextMessage.getText();
            if (contextId == null) {
                throw new IllegalArgumentException("Parameter 'contextId' is null or missed");
            }
            MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)contextId);
            this.tcContextService.disableStepByStepOnCurrentServiceInstance(new BigInteger(contextId));
        }
        catch (JMSException e) {
            log.error("Error while 'Disable step-by-step mode' message processing: {}", (Object)e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    private void progressingTcContext(TcContext tcContext, Status newStatus, BigInteger contextId) {
        switch (newStatus) {
            case PAUSED: {
                if (tcContext.getInitiator() == null || !(tcContext.getInitiator() instanceof CallChainInstance)) {
                    throw new IllegalArgumentException(String.format("Context ID=%s: initiator is NOT a callchain;  Pausing is cancelled", contextId));
                }
                if (Status.IN_PROGRESS.equals((Object)tcContext.getStatus()) || tcContext.isRunStepByStep()) {
                    try {
                        this.tcContextService.pauseOnCurrentServiceInstance(tcContext);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Context ID=%s: Pausing is failed", contextId), e);
                    }
                }
                throw new IllegalArgumentException(String.format("Context ID=%s is in the %s state; Pausing is cancelled", contextId, tcContext.getStatus()));
            }
            case STOPPED: {
                if (Status.IN_PROGRESS.equals((Object)tcContext.getStatus()) || Status.PAUSED.equals((Object)tcContext.getStatus()) || Status.NOT_STARTED.equals((Object)tcContext.getStatus())) {
                    try {
                        this.tcContextService.stopOnCurrentServiceInstance(tcContext);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Context ID=%s: Stopping is failed", contextId), e);
                    }
                }
                throw new IllegalArgumentException(String.format("Context ID=%s is in the %s state; Stopping is cancelled", contextId, tcContext.getStatus()));
            }
            case IN_PROGRESS: {
                if (tcContext.getInitiator() == null || !(tcContext.getInitiator() instanceof CallChainInstance)) {
                    throw new IllegalArgumentException(String.format("Context ID=%s: initiator is NOT a callchain;  Resuming is cancelled", contextId));
                }
                if (Status.PAUSED.equals((Object)tcContext.getStatus())) {
                    try {
                        this.tcContextService.resumeOnCurrentServiceInstance(tcContext);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Context ID=%s: Resuming is failed", contextId), e);
                    }
                }
                throw new IllegalArgumentException(String.format("Context ID=%s is in the %s state; Resuming is cancelled", contextId, tcContext.getStatus()));
            }
            default: {
                log.error("Context ID {}: Unexpected state [{}] for context", (Object)contextId, (Object)newStatus);
            }
        }
    }

    @ConstructorProperties(value={"executorIntegrationObjectMapper", "tcContextService"})
    public MultiReplicaJMSListeners(ObjectMapper executorIntegrationObjectMapper, TCContextService tcContextService) {
        this.executorIntegrationObjectMapper = executorIntegrationObjectMapper;
        this.tcContextService = tcContextService;
    }
}

