/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.config.jms.listener.factory;

import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;

@Configuration
public class JmsListenersContainerFactoriesConfiguration {
    @Value(value="${message-broker.stubs-executor.listenerContainerFactory.concurrency}")
    private String stubsExecutorListenerConcurrency;
    @Value(value="${message-broker.stubs-executor.listenerContainerFactory.maxMessagesPerTask}")
    private String stubsExecutorListenerMaxMessagesPerTask;

    @Bean
    public DefaultJmsListenerContainerFactory stubDefaultJmsListenerQueueContainerFactory(ConnectionFactory defaultActiveMqConnectionFactory, DefaultJmsListenerContainerFactory jmsQueueListenerContainerFactory) {
        int maxMessagesPerTask;
        jmsQueueListenerContainerFactory.setConnectionFactory(defaultActiveMqConnectionFactory);
        jmsQueueListenerContainerFactory.setConcurrency(this.stubsExecutorListenerConcurrency);
        if (!(this.stubsExecutorListenerMaxMessagesPerTask == null || this.stubsExecutorListenerMaxMessagesPerTask.isEmpty() || (maxMessagesPerTask = Integer.parseInt(this.stubsExecutorListenerMaxMessagesPerTask)) != -1 && maxMessagesPerTask <= 0)) {
            jmsQueueListenerContainerFactory.setMaxMessagesPerTask(Integer.valueOf(maxMessagesPerTask));
        }
        jmsQueueListenerContainerFactory.setPubSubDomain(Boolean.valueOf(false));
        jmsQueueListenerContainerFactory.setCacheLevel(Integer.valueOf(3));
        jmsQueueListenerContainerFactory.setSessionAcknowledgeMode(Integer.valueOf(4));
        jmsQueueListenerContainerFactory.setAutoStartup(false);
        return jmsQueueListenerContainerFactory;
    }

    @Bean
    public DefaultJmsListenerContainerFactory defaultJmsListenerTopicContainerFactory(ConnectionFactory defaultActiveMqConnectionFactory, DefaultJmsListenerContainerFactory jmsTopicListenerContainerFactory) {
        jmsTopicListenerContainerFactory.setConnectionFactory(defaultActiveMqConnectionFactory);
        jmsTopicListenerContainerFactory.setPubSubDomain(Boolean.valueOf(true));
        jmsTopicListenerContainerFactory.setAutoStartup(false);
        return jmsTopicListenerContainerFactory;
    }
}

