/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.scheduled;

import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.StubProjectObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CleanUserData {
    private static final Logger log = LoggerFactory.getLogger(CleanUserData.class);
    private static final String UTC_TIMEZONE = "UTC";
    private final StubProjectObjectManager stubProjectObjectManager;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;
    @Value(value="${userdata.clean.leave_days}")
    private long leaveDays;
    @Value(value="${userdata.clean.leave_days.timeunit}")
    private TimeUnit leaveDaysTimeunit;

    @Autowired
    public CleanUserData(StubProjectObjectManager stubProjectObjectManager) {
        this.stubProjectObjectManager = stubProjectObjectManager;
    }

    @Scheduled(cron="${userdata.clean.job.expression}", zone="UTC")
    @SchedulerLock(name="${userdata.clean.job.name}", lockAtMostFor="5m")
    public void run() {
        Integer days = Integer.valueOf(String.valueOf(this.leaveDaysTimeunit.toDays(this.leaveDays)));
        log.info("Scheduled task execution is started at {}", (Object)LocalDateTime.now());
        try {
            if (this.multiTenancyEnabled.booleanValue()) {
                for (String tenantId : TenantContext.getTenantIds((boolean)true)) {
                    TenantContext.setTenantInfo((String)tenantId);
                    this.stubProjectObjectManager.clearUserData(days);
                }
                TenantContext.setDefaultTenantInfo();
            }
            this.stubProjectObjectManager.clearUserData(days);
            log.info("Scheduled task execution is finished at {}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            log.error("Error while executing of the scheduled task: {}", (Object)e.getMessage());
        }
    }
}

