/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExportImportService {
    private static final Logger log = LoggerFactory.getLogger(ExportImportService.class);

    public List<UUID> collectBvTcByChainsIds(Set<String> itfCallChainIds) {
        if (itfCallChainIds == null || itfCallChainIds.isEmpty()) {
            return new ArrayList<UUID>();
        }
        ObjectManager objectManager = CoreObjectManager.getInstance().getManager(CallChain.class);
        HashSet<UUID> bvCasesSet = new HashSet<UUID>();
        for (String chainId : itfCallChainIds) {
            CallChain callChain = (CallChain)objectManager.getById((Object)chainId);
            if (callChain == null) {
                log.warn("Collecting BV testcases: callChain is not found by id {}", (Object)chainId);
                continue;
            }
            this.collectBvCasesByCallChain(bvCasesSet, callChain);
        }
        log.info("Collecting of BulkValidator TestCases by CallChainsIds is finished, {} items", (Object)bvCasesSet.size());
        return new ArrayList<UUID>(bvCasesSet);
    }

    public List<UUID> collectBvTcBySystemsIds(Set<String> itfSystemsIds) {
        if (itfSystemsIds == null || itfSystemsIds.isEmpty()) {
            return new ArrayList<UUID>();
        }
        ObjectManager objectManager = CoreObjectManager.getInstance().getManager(System.class);
        HashSet<UUID> bvCasesSet = new HashSet<UUID>();
        for (String sysId : itfSystemsIds) {
            System system = (System)objectManager.getById((Object)sysId);
            if (system == null) {
                log.warn("Collecting BV testcases: system is not found by id {}", (Object)sysId);
                continue;
            }
            this.collectBvTcBySystem(bvCasesSet, system);
        }
        log.info("Collecting BulkValidator TestCases by SystemsIds is finished, {} items", (Object)bvCasesSet.size());
        return new ArrayList<UUID>(bvCasesSet);
    }

    public List<UUID> collectBvTcByEnvironmentsIds(Set<String> itfEnvironments) {
        if (itfEnvironments == null || itfEnvironments.isEmpty()) {
            return new ArrayList<UUID>();
        }
        ObjectManager objectManager = CoreObjectManager.getInstance().getManager(Environment.class);
        HashSet<UUID> bvCasesSet = new HashSet<UUID>();
        for (String envId : itfEnvironments) {
            Environment environment = (Environment)objectManager.getById((Object)envId);
            if (environment == null) {
                log.warn("Collecting BV testcases: environment is not found by id {}", (Object)envId);
                continue;
            }
            Set<System> outSystems = environment.getOutbound().keySet();
            this.collectBvTcBySystems(bvCasesSet, outSystems);
            Set<System> inbSystems = environment.getInbound().keySet();
            this.collectBvTcBySystems(bvCasesSet, inbSystems);
        }
        log.info("Collecting BulkValidator TestCases by EnvironmentsIds is finished, {} items", (Object)bvCasesSet.size());
        return new ArrayList<UUID>(bvCasesSet);
    }

    public List<UUID> collectDslByChainsIds(Set<String> itfCallChains) {
        if (itfCallChains == null || itfCallChains.isEmpty()) {
            return new ArrayList<UUID>();
        }
        ObjectManager objectManager = CoreObjectManager.getInstance().getManager(CallChain.class);
        HashSet<UUID> dataSetLists = new HashSet<UUID>();
        for (String chainId : itfCallChains) {
            CallChain callChain = (CallChain)objectManager.getById((Object)chainId);
            if (callChain == null) {
                log.warn("Collecting DSLs: callChain is not found by id {}", (Object)chainId);
                continue;
            }
            Set dslIdsWithVa = callChain.getCompatibleDataSetListIds();
            for (String dslIdWithVa : dslIdsWithVa) {
                String[] dslUuid;
                if (dslIdWithVa == null || (dslUuid = dslIdWithVa.split("_")).length < 2) continue;
                this.addIfNotEmpty(dslUuid[1], dataSetLists);
            }
        }
        log.info("Collecting DSLs by CallChainsIds is finished, {} items", (Object)dataSetLists.size());
        return new ArrayList<UUID>(dataSetLists);
    }

    private void collectBvTcBySystem(Set<UUID> to, System system) {
        if (system == null) {
            return;
        }
        for (Operation operation : system.getOperations()) {
            for (Situation sit : operation.getSituations()) {
                String bvTestcase = sit.getBvTestcase();
                this.addIfNotEmpty(bvTestcase, to);
            }
        }
    }

    private void collectBvTcBySystems(Set<UUID> to, Set<System> systems) {
        for (System system : systems) {
            this.collectBvTcBySystem(to, system);
        }
    }

    private void collectBvCasesByCallChain(Set<UUID> bvCasesSet, CallChain callChain) {
        Collection bvCases = callChain.getBvCases().values();
        for (String bvCase : bvCases) {
            this.addIfNotEmpty(bvCase, bvCasesSet);
        }
        this.collectBvCasesFromChainSteps(bvCasesSet, callChain);
    }

    private void collectBvCasesFromChainSteps(Set<UUID> bvCasesSet, CallChain callChain) {
        if (callChain == null) {
            return;
        }
        List callChainSteps = callChain.getSteps();
        for (Step step : callChainSteps) {
            CallChain chain;
            if (step instanceof SituationStep) {
                Situation situation = ((SituationStep)step).getSituation();
                if (situation == null) continue;
                this.addIfNotEmpty(situation.getBvTestcase(), bvCasesSet);
                continue;
            }
            if (!(step instanceof EmbeddedStep) || (chain = ((EmbeddedStep)step).getChain()) == null) continue;
            this.collectBvCasesByCallChain(bvCasesSet, chain);
        }
    }

    private void addIfNotEmpty(String stringUuid, Set<UUID> to) {
        if (StringUtils.isEmpty((CharSequence)stringUuid)) {
            return;
        }
        to.add(UUID.fromString(stringUuid));
    }
}

