/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.eds.service.FileManagementService;
import org.qubership.automation.itf.core.util.exception.ExportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FileDownloaderService {
    private static final Logger log = LoggerFactory.getLogger(FileDownloaderService.class);
    private final FileManagementService fileManagementService;
    @Value(value="${local.storage.directory}")
    private String rootFolder;

    public FileDownloaderService(FileManagementService fileManagementService) {
        this.fileManagementService = fileManagementService;
    }

    public ResponseEntity<InputStreamResource> zipProjectFiles(List<EdsContentType> typesToDownload, UUID projectUuid) throws IOException, ExportException {
        String rootDirectory = FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath().toString();
        Path rootPath = Paths.get(rootDirectory, "data_temp");
        if (!Files.exists(rootPath, new LinkOption[0])) {
            Files.createDirectory(rootPath, new FileAttribute[0]);
        }
        String sanitizedFileName = FilenameUtils.getName((String)String.format("project_files_%s_%s.zip", projectUuid, LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd_MM_yyyy_hh_mm_ss"))));
        FileOutputStream fileOutputStream = new FileOutputStream(rootPath.resolve(sanitizedFileName).toString());
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        int skippedTypes = 0;
        for (EdsContentType edsContentType : typesToDownload) {
            String type = edsContentType.getStringValue();
            String sourceDir = Paths.get(this.rootFolder, type, projectUuid.toString()).toString();
            if (EdsContentType.KEYSTORE.equals((Object)edsContentType)) {
                sourceDir = Paths.get(this.rootFolder, type).toString();
            }
            File fileSource = new File(sourceDir);
            log.debug("Trying to get files of type: '{}', source dir: '{}'", (Object)type, (Object)sourceDir);
            File[] files = fileSource.listFiles();
            if (Objects.isNull(files)) {
                log.warn("There is no files of type: '{}'", (Object)type);
                ++skippedTypes;
                continue;
            }
            this.addDirectory(zipOutputStream, fileSource);
        }
        if (skippedTypes == typesToDownload.size()) {
            throw new IOException("There is no files for selected types: " + typesToDownload);
        }
        zipOutputStream.finish();
        zipOutputStream.close();
        fileOutputStream.close();
        File file = new File(rootPath.resolve(sanitizedFileName).toString());
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        return this.downloadFile(sanitizedFileName, path);
    }

    public ResponseEntity<InputStreamResource> projectFiles(String fileName, String filePath, EdsContentType contentType, UUID projectUuid) throws IOException, ExportException {
        String sanitizedFileName = FilenameUtils.getName((String)fileName);
        String sanitizedFilePath = FilenameUtils.normalize((String)filePath);
        Path fullPathToFile = this.fileManagementService.getDirectoryPath(contentType.getStringValue(), projectUuid, sanitizedFilePath).resolve(sanitizedFileName);
        File file = new File(fullPathToFile.toString());
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        return this.downloadFile(sanitizedFileName, path);
    }

    private void addDirectory(ZipOutputStream zipOutputStream, File fileSource) throws IOException {
        log.debug("Adding directory: '{}' ...", (Object)fileSource.getName());
        File[] files = fileSource.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            int length;
            if (file.isDirectory()) {
                this.addDirectory(zipOutputStream, file);
                continue;
            }
            log.debug("Adding file :'{}' ...", (Object)file.getName());
            FileInputStream fileInputStream = new FileInputStream(file);
            zipOutputStream.putNextEntry(new ZipEntry(file.getPath()));
            byte[] buffer = new byte[4024];
            while ((length = fileInputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, length);
            }
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
    }

    public ResponseEntity<InputStreamResource> downloadFile(String fileName, Path archive) throws ExportException, IOException {
        FileInputStream inputStream = new FileInputStream(archive.toString());
        InputStreamResource streamResource = new InputStreamResource((InputStream)inputStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHeaderFor(fileName, archive))).body((Object)streamResource);
    }

    private HttpHeaders createHeaderFor(String fileName, Path archive) throws ExportException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        try {
            headers.setContentLength(Files.size(archive));
        }
        catch (IOException e) {
            throw new ExportException(String.format("Cannot get size of file %s", archive), (Throwable)e);
        }
        headers.setAccessControlExposeHeaders(Arrays.asList("Content-Disposition"));
        headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(fileName).build());
        return headers;
    }
}

