/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.service;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.DefferedSituationInstanceHolder;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.NextCallChainEventSubscriberHolder;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.SubscriberData;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.NextCallChainSubscriber;
import org.qubership.automation.itf.core.message.TcContextOperationMessage;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.event.TcContextEvent;
import org.qubership.automation.itf.core.model.extension.SituationExtension;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.util.DiameterSessionHolder;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.exception.TcContextTimeoutException;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.qubership.automation.itf.core.util.manager.ExtensionManager;
import org.qubership.automation.itf.core.util.manager.MonitorManager;
import org.qubership.automation.itf.core.util.pcap.PcapHelper;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.cache.service.impl.PendingDataContextsCacheService;
import org.qubership.automation.itf.executor.cache.service.impl.TCContextCacheService;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.provider.EventBusServiceProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TCContextService {
    private static final Logger log = LoggerFactory.getLogger(TCContextService.class);
    public static final ConcurrentHashMap<String, Integer> currentPartitionNumbers = TCContextService.initPartitionNumbers();
    private static final String savedKey = "saved";
    private final TCContextCacheService tcContextCacheService;
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final EventBusProvider eventBusProvider;
    private final ProjectSettingsService projectSettingsService;

    private static ConcurrentHashMap<String, Integer> initPartitionNumbers() {
        ConcurrentHashMap<String, Integer> currentPartitionNumbers = new ConcurrentHashMap<String, Integer>();
        currentPartitionNumbers.put("Default", 1);
        return currentPartitionNumbers;
    }

    public static int getCurrentPartitionNumberByProject(UUID projectUuid) {
        Integer i = currentPartitionNumbers.get(projectUuid.toString());
        return i == null ? currentPartitionNumbers.get("Default").intValue() : i.intValue();
    }

    public void refreshPartitionNumbers(Map<String, Integer> newData) {
        currentPartitionNumbers.putAll(newData);
    }

    public void start(TcContext tcContext) {
        if (!Status.NOT_STARTED.equals((Object)tcContext.getStatus())) {
            return;
        }
        tcContext.setStartTime(new Date());
        tcContext.setStatus(Status.IN_PROGRESS);
        String dumpfilePath = PcapHelper.startTcpDumpCreating((String)tcContext.getID().toString());
        if (StringUtils.isNotEmpty((CharSequence)dumpfilePath)) {
            tcContext.getReportLinks().put("Download TCPDump", dumpfilePath);
        }
        CacheServices.getTcContextCacheService().set(tcContext, true);
        long stTime = System.currentTimeMillis();
        this.eventBusProvider.post((Event)new TcContextEvent.Start(tcContext));
        log.info("post to EventBus TcContextEvent.Start - duration {} ms", (Object)(System.currentTimeMillis() - stTime));
    }

    public void updateInfo(TcContext tcContext) {
        if (tcContext.isFinished()) {
            return;
        }
        CacheServices.getTcContextCacheService().set(tcContext, true);
        this.eventBusProvider.post((Event)new TcContextEvent.UpdateInfo(tcContext));
        log.debug("Context {} was updated", tcContext.getID());
    }

    public void stop(TcContext tcContext) {
        this.stop((BigInteger)tcContext.getID(), this.getTenantId(tcContext));
    }

    public void stop(BigInteger tcContextId, String tenantId) {
        this.executorToMessageBrokerSender.sendMessageToTcContextOperationsTopic(new TcContextOperationMessage(Status.STOPPED.name(), tcContextId), tenantId);
    }

    public void stopOnCurrentServiceInstance(TcContext tcContext) {
        if (Status.IN_PROGRESS.equals((Object)tcContext.getStatus()) || Status.PAUSED.equals((Object)tcContext.getStatus()) || Status.NOT_STARTED.equals((Object)tcContext.getStatus())) {
            tcContext.setEndTime(new Date());
            tcContext.setStatus(Status.STOPPED);
            this.performExtraFinishActions(tcContext);
            this.eventBusProvider.post((Event)new TcContextEvent.Stop(tcContext));
        }
    }

    public void resumeOnCurrentServiceInstance(TcContext tcContext) {
        if (!Status.PAUSED.equals((Object)tcContext.getStatus())) {
            return;
        }
        tcContext.setStatus(Status.IN_PROGRESS);
        SituationExtension situationExtension = (SituationExtension)ExtensionManager.getInstance().getExtension((Object)tcContext, SituationExtension.class);
        if (situationExtension.getSituationInstanceIds().size() > 1) {
            tcContext.setStatus(Status.FAILED);
            this.updateInfo(tcContext);
            String error = "There are more than one situation instance for resuming. Resuming can not be continued, tcContext will be failed.";
            IllegalArgumentException exception = new IllegalArgumentException(error);
            log.error("Error occurred while resuming the {} context: ", (Object)tcContext.getName(), (Object)exception);
            throw exception;
        }
        CacheServices.getTcBindingCacheService().bind(tcContext);
        this.updateInfo(tcContext);
        ExecutionServices.getExecutionProcessManagerService().resume(tcContext);
    }

    public void prolong(TcContext tcContext) {
        Status tcContextStatus = tcContext.getStatus();
        if (Status.FAILED.equals((Object)tcContextStatus) || Status.STOPPED.equals((Object)tcContextStatus)) {
            tcContext.setStatus(Status.IN_PROGRESS);
            this.eventBusProvider.post((Event)new TcContextEvent.Continue(tcContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(TcContext tcContext) {
        if (Status.IN_PROGRESS.equals((Object)tcContext.getStatus()) || Status.PAUSED.equals((Object)tcContext.getStatus())) {
            this.finalizeContext(tcContext, tcContext.isValidationFailed() ? Status.FAILED : Status.PASSED);
            this.performExtraFinishActions(tcContext);
        }
        if (!tcContext.isFinishEventSent().booleanValue()) {
            TcContext tcContext2 = tcContext;
            synchronized (tcContext2) {
                if (!tcContext.isFinishEventSent().booleanValue()) {
                    this.eventBusProvider.post((Event)new TcContextEvent.Finish(tcContext));
                    tcContext.setFinishEventAsSent();
                }
            }
        }
    }

    public void fail(TcContext tcContext) {
        this.fail(tcContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(TcContext tcContext, boolean byTimeout) {
        Status contextStatus = tcContext.getStatus();
        if (Status.NOT_STARTED.equals((Object)contextStatus) || Status.IN_PROGRESS.equals((Object)contextStatus) || Status.FAILED.equals((Object)contextStatus)) {
            this.finalizeContext(tcContext, byTimeout ? Status.FAILED_BY_TIMEOUT : Status.FAILED);
            this.performExtraFinishActions(tcContext);
        }
        if (!tcContext.isFailEventSent().booleanValue()) {
            TcContext tcContext2 = tcContext;
            synchronized (tcContext2) {
                if (!tcContext.isFailEventSent().booleanValue()) {
                    this.eventBusProvider.post((Event)new TcContextEvent.Fail(tcContext));
                    tcContext.setFailEventAsSent();
                }
            }
        }
    }

    public void failByTimeout(TcContext tcContext) {
        this.fail(tcContext, true);
    }

    public void terminateByTimeout(TcContext tcContext) {
        if (tcContext.isRunning() || Status.PAUSED.equals((Object)tcContext.getStatus())) {
            if (tcContext.getInitiator() instanceof SituationInstance) {
                this.finish(tcContext);
                log.debug("TC context (inbound) is terminated by timeout (old status: {})", (Object)tcContext.getStatus());
            } else {
                String message = String.format("TC context [%s] '%s' is failed by timeout (old status: %s)", tcContext.getID(), tcContext.getName(), tcContext.getStatus());
                log.error(message);
                this.terminateCallChainContextByTimeout(tcContext.getID(), message);
            }
        } else {
            log.warn("TC context [{}] '{}' is removed from {} cache due to expired, but NOT failed by timeout due to conditions: status {}", new Object[]{tcContext.getID(), tcContext.getName(), "ATP_ITF_TC_CONTEXTS", tcContext.getStatus()});
        }
    }

    private void terminateCallChainContextByTimeout(Object tcId, String message) {
        SubscriberData subscriberData = NextCallChainEventSubscriberHolder.getInstance().getSubscriberData(tcId);
        if (subscriberData != null) {
            EventBusServiceProvider.getStaticReference().post((Event)new NextCallChainEvent.FailByTimeout(subscriberData.getSubscriberId(), (Exception)new TcContextTimeoutException(message)));
        }
    }

    public void disableStepByStepOnCurrentServiceInstance(BigInteger contextId) {
        SubscriberData subscriberData = NextCallChainEventSubscriberHolder.getInstance().getSubscriberData(contextId);
        if (subscriberData != null) {
            SituationInstance situationInstance = DefferedSituationInstanceHolder.getInstance().get(contextId);
            if (situationInstance != null) {
                TcContext context = situationInstance.getContext().getTC();
                if (context != null) {
                    context.setRunStepByStep(false);
                    this.tcContextCacheService.set(context, true);
                } else {
                    log.error("Error while trying to turn off step-by-step mode for tcContext [{}]: There is no tcContext linked with deferred SituationInstance {}!", (Object)contextId, (Object)situationInstance);
                }
            } else {
                log.error("Error while trying to turn off step-by-step mode for tcContext [{}]: There is no SituationInstance in the Holder!", (Object)contextId);
            }
        }
    }

    public void pause(TcContext tcContext) {
        this.executorToMessageBrokerSender.sendMessageToTcContextOperationsTopic(new TcContextOperationMessage(Status.PAUSED.name(), (BigInteger)tcContext.getID()), this.getTenantId(tcContext));
    }

    public void pauseOnCurrentServiceInstance(TcContext tcContext) {
        if (Status.IN_PROGRESS.equals((Object)tcContext.getStatus()) || tcContext.isRunStepByStep()) {
            SubscriberData subscriberData = NextCallChainEventSubscriberHolder.getInstance().getSubscriberData(tcContext.getID());
            if (subscriberData == null) {
                String error = "There is no subscriber to process 'pause' event.";
                IllegalArgumentException exception = new IllegalArgumentException(error);
                log.error("Error occurred while pausing the {} context: ", (Object)tcContext.getName(), (Object)exception);
                throw exception;
            }
            tcContext.setStatus(Status.PAUSED);
            CacheServices.getTcBindingCacheService().bind(tcContext);
            CacheServices.getTcContextCacheService().set(tcContext, true);
            this.eventBusProvider.post((Event)new TcContextEvent.Pause(tcContext));
            NextCallChainEvent.Pause pauseEvent = new NextCallChainEvent.Pause(subscriberData.getParentSubscriberId(), (CallChainInstance)tcContext.getInitiator());
            pauseEvent.setID(subscriberData.getSubscriberId());
            this.eventBusProvider.post((Event)pauseEvent);
        }
    }

    public void updateContext(TcContext tcContext) {
        this.setOrMergeTc(tcContext);
    }

    public void setMessageParameters(TcContext tcContext, Map<String, MessageParameter> messageParameters) {
        this.setMessageParameters(tcContext, messageParameters.values());
    }

    public void setMessageParameters(TcContext tcContext, Collection<MessageParameter> messageParameters) {
        if (!tcContext.containsKey((Object)savedKey)) {
            tcContext.create((Object)savedKey);
        }
        for (MessageParameter parameter : messageParameters) {
            if (!parameter.isAutosave()) continue;
            tcContext.put((Object)String.format("%s.%s", savedKey, parameter.getParamName()), parameter.isMultiple() ? parameter.getMultipleValue() : parameter.getSingleValue());
        }
    }

    @Deprecated
    public int getDurationMinutes(TcContext tcContext) {
        Date endTime = tcContext.getEndTime();
        Date startTime = tcContext.getStartTime();
        if (startTime == null) {
            return 0;
        }
        if (endTime == null) {
            return (int)((System.currentTimeMillis() - startTime.getTime()) / 60000L + 1L);
        }
        return (int)((endTime.getTime() - startTime.getTime()) / 60000L + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyATP(TcContext tcContext) {
        if (tcContext.getStartedByAtp()) {
            Object object;
            Object object2 = object = MonitorManager.getInstance().get(tcContext.getID().toString());
            synchronized (object2) {
                object.notify();
            }
        }
    }

    public void mergePendingContextsIfAny(TcContext tcContext) {
        PendingDataContextsCacheService pendingDataContextsCacheService = CacheServices.getPendingDataContextsCacheService();
        Map<Object, TcContext> pendingDataContext = pendingDataContextsCacheService.getContextById(tcContext.getID());
        if (pendingDataContext != null && !pendingDataContext.isEmpty()) {
            this.putPendingData(tcContext, pendingDataContext);
            pendingDataContextsCacheService.clearPendingDataContext(tcContext.getID());
        }
    }

    private void putPendingData(TcContext tcContext, Map<Object, TcContext> pendingContextData) {
        Set<Map.Entry<Object, TcContext>> entries = pendingContextData.entrySet();
        for (Map.Entry<Object, TcContext> entry : entries) {
            TcContext pendingContext = entry.getValue();
            tcContext.putIfAbsent((Map)pendingContext);
        }
    }

    private void setOrMergeTc(TcContext tcContext) {
        AbstractContainerInstance initiator = tcContext.getInitiator();
        if (initiator.getContext().tc() == null) {
            initiator.getContext().setTC(tcContext);
        } else {
            initiator.getContext().tc().merge((Map)tcContext);
        }
    }

    private void finalizeContext(TcContext tcContext, Status status) {
        tcContext.setEndTime(new Date());
        tcContext.setStatus(status);
        AbstractContainerInstance initiator = tcContext.getInitiator();
        if (initiator != null) {
            initiator.setStatus(status);
        }
    }

    private void performExtraFinishActions(TcContext tcContext) {
        PcapHelper.stopTcpDumpCreating((String)tcContext.getID().toString());
        CacheServices.getTcBindingCacheService().unbind(tcContext);
        NextCallChainEventSubscriberHolder.getInstance().remove(tcContext.getID());
        DiameterSessionHolder.getInstance().remove(tcContext.getID());
        List<NextCallChainSubscriber> subscribers = CacheServices.getCallchainSubscriberCacheService().unregisterAllSubscribers(tcContext.getID());
        if (subscribers != null) {
            for (NextCallChainSubscriber subscriber : subscribers) {
                this.eventBusProvider.unregister(subscriber);
            }
        }
    }

    public void updateLastAccess(TcContext tcContext) {
        CacheServices.getTcContextCacheService().set(tcContext, true);
        tcContext.setLastUpdateTime(System.currentTimeMillis());
        if (tcContext.getStartedByAtp()) {
            MonitorManager.getInstance().get(tcContext.getID().toString());
        }
    }

    public TcContext createInMemory(BigInteger projectId, UUID projectUuid) {
        return this.createInMemory(UniqueIdGenerator.generate(), projectId, projectUuid);
    }

    @NotNull
    private TcContext createInMemory(Object id, BigInteger projectId, UUID projectUuid) {
        TcContext context = new TcContext();
        context.setID(id);
        context.setProjectId(projectId);
        context.setProjectUuid(projectUuid);
        context.setPodName(Config.getConfig().getRunningHostname());
        return context;
    }

    @NotNull
    private String getTenantId(TcContext tcContext) {
        try {
            return tcContext.getInitiator().getContext().getProjectUuid().toString();
        }
        catch (Exception e) {
            log.error("Can't get tenant id from TCContext. TCContext id: {}", tcContext.getID());
            return "";
        }
    }

    @ConstructorProperties(value={"tcContextCacheService", "executorToMessageBrokerSender", "eventBusProvider", "projectSettingsService"})
    public TCContextService(TCContextCacheService tcContextCacheService, ExecutorToMessageBrokerSender executorToMessageBrokerSender, EventBusProvider eventBusProvider, ProjectSettingsService projectSettingsService) {
        this.tcContextCacheService = tcContextCacheService;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.eventBusProvider = eventBusProvider;
        this.projectSettingsService = projectSettingsService;
    }

    public TCContextCacheService getTcContextCacheService() {
        return this.tcContextCacheService;
    }
}

