/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.execution.data;

import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.execution.ExecutionDataProvider;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.util.pcap.PcapHelper;
import org.qubership.automation.itf.core.util.services.CoreServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallchainExecutionData
implements ExecutionDataProvider {
    private static final Logger log = LoggerFactory.getLogger(CallchainExecutionData.class);
    private transient CallChain callChain = null;
    private transient IDataSet dataset = null;
    private transient Environment environment = null;
    private transient JsonContext customDataset;
    private String datasetName;
    private String datasetId;
    private String environmentName;
    private String environmentId;
    private String callChainId;
    private boolean runBvCase;
    private boolean runStepByStep;
    private String bvAction;
    private boolean needToLogInATP;
    private Map<String, String> tcpDumpParams;
    private boolean validateMessageOnStep;
    private boolean createTcpDump;
    private String networkInterfaceName;
    private String tcpdumpFilter;
    private int packetCount;
    private BigInteger projectId;
    private UUID projectUuid;

    public CallchainExecutionData(CallChain callChain, String environmentName, String environmentId, String datasetName) {
        this.setCallChain(callChain);
        this.environmentName = environmentName;
        this.environmentId = environmentId;
        this.datasetName = datasetName;
    }

    public CallchainExecutionData(String callChainId, String environmentName, String environmentId, String datasetId, String datasetName, JsonContext customDataset, boolean runBvCase, boolean runStepByStep, String bvAction, boolean needToLogInATP, Map<String, String> tcpDumpParams, boolean validateMessageOnStep, BigInteger projectId, UUID projectUuid) {
        this.callChainId = callChainId;
        this.environmentName = environmentName;
        this.environmentId = environmentId;
        this.datasetId = datasetId;
        this.datasetName = datasetName;
        this.customDataset = customDataset;
        this.setOptionSection(runBvCase, runStepByStep, bvAction, needToLogInATP, tcpDumpParams, validateMessageOnStep, projectId, projectUuid);
    }

    public CallchainExecutionData(CallChain callChain, Environment environment, IDataSet dataset, JsonContext customDataset, boolean runBvCase, String bvAction, Map<String, String> tcpDumpParams, boolean validateMessageOnStep, BigInteger projectId, UUID projectUuid) {
        this.setCallChain(callChain);
        this.setEnvironment(environment);
        if (environment != null) {
            this.environmentName = environment.getName();
            this.environmentId = environment.getID().toString();
        }
        this.setDataset(dataset);
        if (dataset != null) {
            this.datasetName = dataset.getName();
            this.datasetId = dataset.getIdDs();
        }
        this.customDataset = customDataset;
        this.setOptionSection(runBvCase, this.runStepByStep, bvAction, this.needToLogInATP, tcpDumpParams, validateMessageOnStep, projectId, projectUuid);
    }

    private void setOptionSection(boolean runBvCase, boolean runStepByStep, String bvAction, boolean needToLogInATP, Map<String, String> tcpDumpParams, boolean validateMessageOnStep, BigInteger projectId, UUID projectUuid) {
        this.runBvCase = runBvCase;
        this.runStepByStep = runStepByStep;
        this.bvAction = bvAction;
        this.needToLogInATP = needToLogInATP;
        this.tcpDumpParams = tcpDumpParams;
        this.validateMessageOnStep = validateMessageOnStep;
        this.projectId = projectId;
        this.projectUuid = projectUuid;
        if (tcpDumpParams != null) {
            String strPacketCount;
            this.createTcpDump = Boolean.TRUE;
            this.tcpdumpFilter = this.setParameter(tcpDumpParams.get(PcapHelper.TCPDUMP_FILTER_KEY), CoreServices.getProjectSettingsService().get((Object)projectId, "tcpdump.capturing.filter.default", ""), true);
            tcpDumpParams.put(PcapHelper.TCPDUMP_FILTER_KEY, this.tcpdumpFilter);
            this.networkInterfaceName = this.setParameter(tcpDumpParams.get(PcapHelper.TCPDUMP_NETWORK_INTERFACE_NAME_KEY), CoreServices.getProjectSettingsService().get((Object)projectId, "tcpdump.ni.default", ""), false);
            tcpDumpParams.put(PcapHelper.TCPDUMP_NETWORK_INTERFACE_NAME_KEY, this.networkInterfaceName);
            if (StringUtils.isBlank((CharSequence)this.networkInterfaceName)) {
                this.createTcpDump = Boolean.FALSE;
                log.error("Network interface name parameter is missed - TCP dump will be disabled.");
            }
            if (StringUtils.isBlank((CharSequence)(strPacketCount = this.setParameter(tcpDumpParams.get(PcapHelper.TCPDUMP_PACKET_COUNT_KEY), CoreServices.getProjectSettingsService().get((Object)projectId, "tcpdump.packet.count.default", "50"), false)))) {
                this.createTcpDump = Boolean.FALSE;
                log.error("Packet count parameter is missed - TCP dump will be disabled.");
            }
            try {
                this.packetCount = Integer.parseInt(strPacketCount != null ? strPacketCount : "0");
                if (this.packetCount < 1) {
                    throw new NumberFormatException("Packet count parameter value (" + this.packetCount + ") must be positive");
                }
                tcpDumpParams.put(PcapHelper.TCPDUMP_PACKET_COUNT_KEY, String.valueOf(this.packetCount));
            }
            catch (NumberFormatException ex) {
                this.createTcpDump = Boolean.FALSE;
                tcpDumpParams.put(PcapHelper.TCPDUMP_PACKET_COUNT_KEY, strPacketCount);
                log.error("Error while parsing the packet count parameter - TCP dump will be disabled. Error: ", (Throwable)ex);
            }
        }
    }

    private String setParameter(String thisValue, String defaultValue, boolean allowEmpty) {
        if (allowEmpty) {
            if (thisValue != null) {
                return thisValue;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            return "";
        }
        if (!StringUtils.isBlank((CharSequence)thisValue)) {
            return thisValue;
        }
        if (!StringUtils.isBlank((CharSequence)defaultValue)) {
            return defaultValue;
        }
        return null;
    }

    public void setCallChain(CallChain callChain) {
        this.callChain = callChain;
    }

    public CallChain getCallChain() {
        return this.callChain;
    }

    public void setDataset(IDataSet dataset) {
        this.dataset = dataset;
    }

    public IDataSet getDataset() {
        return this.dataset;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public JsonContext getCustomDataset() {
        return this.customDataset;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getCallChainId() {
        return this.callChainId;
    }

    public void setRunBvCase(boolean runBvCase) {
        this.runBvCase = runBvCase;
    }

    public boolean isRunBvCase() {
        return this.runBvCase;
    }

    public void setRunStepByStep(boolean runStepByStep) {
        this.runStepByStep = runStepByStep;
    }

    public boolean isRunStepByStep() {
        return this.runStepByStep;
    }

    public void setBvAction(String bvAction) {
        this.bvAction = bvAction;
    }

    public String getBvAction() {
        return this.bvAction;
    }

    public void setNeedToLogInATP(boolean needToLogInATP) {
        this.needToLogInATP = needToLogInATP;
    }

    public boolean isNeedToLogInATP() {
        return this.needToLogInATP;
    }

    public Map<String, String> getTcpDumpParams() {
        return this.tcpDumpParams;
    }

    public void setValidateMessageOnStep(boolean validateMessageOnStep) {
        this.validateMessageOnStep = validateMessageOnStep;
    }

    public boolean isValidateMessageOnStep() {
        return this.validateMessageOnStep;
    }

    public void setCreateTcpDump(boolean createTcpDump) {
        this.createTcpDump = createTcpDump;
    }

    public boolean isCreateTcpDump() {
        return this.createTcpDump;
    }

    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    public BigInteger getProjectId() {
        return this.projectId;
    }

    public void setProjectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
    }

    public UUID getProjectUuid() {
        return this.projectUuid;
    }
}

