/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.execution.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.execution.Executor;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByParameterAndProjectIdManager;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.testcase.TestCase;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.pcap.PcapHelper;
import org.qubership.automation.itf.execution.data.CallchainExecutionData;
import org.qubership.automation.itf.execution.manager.AbstractExecutorManager;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.integration.bv.utils.BvHelper;
import org.springframework.stereotype.Service;

@Service
public class CallChainExecutorManager
extends AbstractExecutorManager
implements Executor<CallchainExecutionData> {
    private static final Gson GSON = new GsonBuilder().create();
    private final ProjectSettingsService projectSettingsService;

    public CallChainInstance prepare(CallchainExecutionData executionData, boolean startedByAtp) throws Exception {
        Object datasetName;
        CallChain entity = executionData.getCallChain() != null ? executionData.getCallChain() : (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)executionData.getCallChainId());
        Environment env = executionData.getEnvironment() != null ? executionData.getEnvironment() : (Environment)Iterables.getFirst((Iterable)((SearchByParameterAndProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, SearchByParameterAndProjectIdManager.class)).getByNameAndProjectId(executionData.getEnvironmentName(), executionData.getProjectId()), null);
        Preconditions.checkNotNull((Object)env, (Object)("No environment with name [" + executionData.getEnvironment() + "] found"));
        IDataSet dataSet = executionData.getDataset() != null ? executionData.getDataset() : (executionData.getDatasetId() == null || executionData.getDatasetId().isEmpty() ? entity.findDataSetByName(executionData.getDatasetName(), (Object)executionData.getProjectId()) : entity.findDataSetById(executionData.getDatasetId(), (Object)executionData.getProjectId()));
        CallChainInstance instance = ExecutionServices.getCallChainExecutorService().prepare(executionData.getProjectId(), executionData.getProjectUuid(), (TestCase)entity, null, env, dataSet, executionData.getCustomDataset(), startedByAtp, executionData.isValidateMessageOnStep());
        instance.getContext().setProjectUuid(executionData.getProjectUuid());
        instance.setDatasetDefault(entity.getDatasetId() != null && dataSet != null && entity.getDatasetId().equals(dataSet.getIdDs()));
        TcContext tcContext = instance.getContext().tc();
        tcContext.setNeedToReportToAtp(executionData.isNeedToLogInATP() || tcContext.getStartedByAtp());
        tcContext.setAndCalculateNeedToReportToItf();
        if (Objects.isNull(executionData.getDatasetName()) && Objects.nonNull(datasetName = tcContext.get((Object)"DATASET_NAME"))) {
            executionData.setDatasetName(datasetName.toString());
            tcContext.setName(String.format("%s [%s]", instance.getName(), executionData.getDatasetName()));
        }
        instance.setCallchainExecutionData(GSON.toJson((Object)executionData));
        if (dataSet != null && executionData.isRunBvCase()) {
            Object action;
            Object object = action = tcContext.containsKey((Object)"bv.action") ? tcContext.get((Object)"bv.action") : null;
            String resultAction = action != null ? action.toString() : (StringUtils.isEmpty((CharSequence)executionData.getBvAction()) ? this.projectSettingsService.get((Object)tcContext.getProjectId(), "bv.default.action", "CreateNewTestRun") : executionData.getBvAction());
            BvHelper.addOnCaseFinishValidation((CallChainInstance)instance, (CallChain)entity, (String)dataSet.getName(), (boolean)executionData.isRunBvCase(), (String)resultAction);
        }
        if (executionData.isValidateMessageOnStep()) {
            BvHelper.addMessageOnStepValidation((CallChainInstance)instance);
        }
        if (executionData.getTcpDumpParams() != null && executionData.isCreateTcpDump()) {
            PcapHelper.createPcapManager((String)tcContext.getID().toString(), (BigInteger)tcContext.getProjectId(), (String)executionData.getTcpDumpParams().get(PcapHelper.TCPDUMP_NETWORK_INTERFACE_NAME_KEY), (String)executionData.getTcpDumpParams().get(PcapHelper.TCPDUMP_FILTER_KEY), (String)executionData.getTcpDumpParams().get(PcapHelper.TCPDUMP_PACKET_COUNT_KEY));
        }
        return instance;
    }

    @ConstructorProperties(value={"projectSettingsService"})
    public CallChainExecutorManager(ProjectSettingsService projectSettingsService) {
        this.projectSettingsService = projectSettingsService;
    }
}

