/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp.exector;

import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.environments.openapi.dto.EnvironmentFullVer1ViewDto;
import org.qubership.automation.itf.core.model.extension.Extension;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.exception.ExtensionException;
import org.qubership.automation.itf.core.util.manager.ExtensionManager;
import org.qubership.automation.itf.core.util.manager.MonitorManager;
import org.qubership.automation.itf.execution.data.CallchainExecutionData;
import org.qubership.automation.itf.execution.manager.CallChainExecutorManager;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.executor.service.TCContextService;
import org.qubership.automation.itf.integration.atp.util.CallchainRunInfo;
import org.qubership.automation.itf.integration.atp.util.TestRunInfo;
import org.qubership.automation.itf.integration.environments.AtpEnvironmentsEnvironmentFeignClient;
import org.qubership.automation.itf.report.extension.TCContextRamExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AtpCallchainExecutor {
    private static final Logger log = LoggerFactory.getLogger(AtpCallchainExecutor.class);
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private final CallChainExecutorManager callChainExecutorManager;
    private final AtpEnvironmentsEnvironmentFeignClient atpEnvironmentsEnvironmentFeignClient;
    private final ProjectSettingsService projectSettingsService;
    @Value(value="${executor.context.start.max.time}")
    private int contextStartMaxTimeMillis;
    @Value(value="${executor.context.from.atp.finish.max.time}")
    private int contextFromAtpFinishMaxTimeMillis;
    @Value(value="${executor.context.check.interval}")
    private int contextCheckIntervalMillis;

    public TcContext execute(CallchainRunInfo callchainRunInfo, TestRunInfo testRunInfo) throws Exception {
        CallchainExecutionData data = new CallchainExecutionData(callchainRunInfo.getCallChain(), testRunInfo.getEnvironment(), callchainRunInfo.getDataset(), testRunInfo.getContextToMerge(), StringUtils.isNotEmpty((CharSequence)testRunInfo.getBvAction()), testRunInfo.getBvAction(), testRunInfo.getTcpDumpOptions(), testRunInfo.isValidateMessageOnStep(), testRunInfo.getProjectId(), testRunInfo.getProjectUuid());
        CallChainInstance instance = this.callChainExecutorManager.prepare(data, true);
        TcContext tcContext = instance.getContext().tc();
        ExtensionManager.getInstance().extend((Object)tcContext, (Extension)this.createTCContextExtension(testRunInfo));
        tcContext.setStartedFrom(testRunInfo.getStartedFrom());
        tcContext.setPartNum(TCContextService.getCurrentPartitionNumberByProject((UUID)testRunInfo.getProjectUuid()));
        tcContext.putIfAbsent((Object)"DATASET_NAME", (Object)data.getDatasetName());
        Map<String, Map<?, ?>> simpleEnvironmentInfo = this.syncAtpEnvironmentInfo(testRunInfo.getAtpEnvironmentId());
        instance.getContext().put((Object)"ENV", simpleEnvironmentInfo);
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(oldThreadName + "/run-from-" + testRunInfo.getStartedFrom() + "/[" + tcContext.getID() + "]");
        ExecutionServices.getCallChainExecutorService().executeInstance(instance);
        this.waitExecutionCompletion(instance, tcContext);
        Thread.currentThread().setName(oldThreadName);
        return tcContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitExecutionCompletion(CallChainInstance instance, TcContext tcContext) throws InterruptedException {
        long elapsed = 0L;
        if (!tcContext.isFinished()) {
            Object syncObject;
            Object object = syncObject = MonitorManager.getInstance().get(tcContext.getID().toString());
            synchronized (object) {
                long safetyDelta = 5000L;
                while (!tcContext.isFinished()) {
                    syncObject.wait(this.contextCheckIntervalMillis);
                    log.debug("Execution from ATP2 loop: one more wait {} ms is completed", (Object)this.contextCheckIntervalMillis);
                    elapsed += (long)this.contextCheckIntervalMillis;
                    if (tcContext.getLastUpdateTime() > 0L && System.currentTimeMillis() > tcContext.getLastUpdateTime() + tcContext.getTimeToLive() + safetyDelta) {
                        log.error("Execution from ATP2 is broken due to context fail timeout is exceeded, {} elapsed", (Object)elapsed);
                        ExecutionServices.getCallChainExecutorService().reportErrorThenStop(instance, tcContext, "Too long execution of CallChain", "Execution is terminated by timeout", "Last event in the context was at " + SIMPLE_DATE_FORMAT.format(tcContext.getLastUpdateTime()) + " but 'Context Timeout Fail' setting is " + tcContext.getTimeToLive(), null);
                        break;
                    }
                    if (elapsed >= (long)this.contextStartMaxTimeMillis && Status.NOT_STARTED.equals((Object)tcContext.getStatus())) {
                        log.error("Execution from ATP2 is broken due to still not started, {} elapsed", (Object)elapsed);
                        ExecutionServices.getCallChainExecutorService().reportErrorThenStop(instance, tcContext, "Too long start of CallChain", "Execution is not started in time", "Context is not started yet, after " + elapsed + " ms", null);
                        break;
                    }
                    if (elapsed < (long)this.contextFromAtpFinishMaxTimeMillis) continue;
                    log.error("Execution from ATP2 is broken after {} millis, {} elapsed", (Object)this.contextFromAtpFinishMaxTimeMillis, (Object)elapsed);
                    ExecutionServices.getCallChainExecutorService().reportErrorThenStop(instance, tcContext, "Too long execution of CallChain", "Execution is still not completed", "Context is not completed yet, after " + elapsed + " ms", null);
                    break;
                }
            }
        }
        log.debug("Execution from ATP2 is finished, status: {}, elapsed: {}", (Object)tcContext.getStatus(), (Object)elapsed);
        tcContext.setNotified(true);
        CacheServices.getTcContextCacheService().evict(tcContext);
    }

    private TCContextRamExtension createTCContextExtension(TestRunInfo testRunInfo) throws ExtensionException {
        TCContextRamExtension extension = (TCContextRamExtension)ExtensionManager.getInstance().createExtendable(TCContextRamExtension.class);
        extension.setRunId(testRunInfo.getTestRunId());
        extension.setProjectName(testRunInfo.getProject());
        extension.setSectionId(testRunInfo.getLogRecordId());
        extension.setExternalRun(Boolean.valueOf(true));
        extension.setRunContext(testRunInfo.getRamTestRunContext());
        extension.setStartedFrom(testRunInfo.getStartedFrom());
        if (testRunInfo.getTestRunId() != null && testRunInfo.getAtpRamUrl() != null) {
            extension.setReportUrl(testRunInfo.getAtpRamUrl() + (testRunInfo.getAtpRamUrl().endsWith("/") ? "" : "/") + "common/uobject.jsp?object=" + testRunInfo.getTestRunId() + "&tab=_Test+Run+Tree+View");
        }
        extension.setExternalAppName("ATP server url: " + testRunInfo.getAtpRamUrl());
        return extension;
    }

    private Map<String, Map<?, ?>> syncAtpEnvironmentInfo(UUID id) {
        Map<String, Map<?, ?>> simpleEnvironment = (Map<String, Map<?, ?>>)CacheServices.getEnvironmentCacheService().get((Object)id);
        if (simpleEnvironment == null) {
            EnvironmentFullVer1ViewDto environment = (EnvironmentFullVer1ViewDto)this.atpEnvironmentsEnvironmentFeignClient.getEnvironment(id, Boolean.valueOf(true)).getBody();
            if (environment != null) {
                simpleEnvironment = this.simplifyEnvironmentInfo(environment);
                CacheServices.getEnvironmentCacheService().set(environment.getId(), simpleEnvironment);
            } else {
                throw new IllegalArgumentException("Cannot find ATP Environment by UUID " + id + " in Environment Configuration Service.");
            }
        }
        return simpleEnvironment;
    }

    private Map<String, Map<?, ?>> simplifyEnvironmentInfo(EnvironmentFullVer1ViewDto environment) {
        HashMap systemsMap = new HashMap();
        for (Object system : environment.getSystems()) {
            HashMap<String, Map> connectionsMap = new HashMap<String, Map>();
            String systemName = (String)((Map)system).get("name");
            systemsMap.put(systemName, connectionsMap);
            for (Object connection : (ArrayList)((Map)system).get("connections")) {
                String connectionName = (String)((Map)connection).get("name");
                Map parameters = (Map)((Map)connection).get("parameters");
                connectionsMap.put(connectionName, parameters);
            }
        }
        return systemsMap;
    }

    @ConstructorProperties(value={"callChainExecutorManager", "atpEnvironmentsEnvironmentFeignClient", "projectSettingsService"})
    public AtpCallchainExecutor(CallChainExecutorManager callChainExecutorManager, AtpEnvironmentsEnvironmentFeignClient atpEnvironmentsEnvironmentFeignClient, ProjectSettingsService projectSettingsService) {
        this.callChainExecutorManager = callChainExecutorManager;
        this.atpEnvironmentsEnvironmentFeignClient = atpEnvironmentsEnvironmentFeignClient;
        this.projectSettingsService = projectSettingsService;
    }
}

