/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.integration.atp.action.ATPActionFactory;
import org.qubership.automation.itf.integration.atp.action.model.impl.AbstractAtpAction;
import org.qubership.automation.itf.integration.atp.model.DefinitionEntry;
import org.qubership.automation.itf.integration.atp.model.StepAdditionalInfo;
import org.qubership.automation.itf.integration.atp.model.StepEntity;
import org.qubership.automation.itf.integration.atp.model.TestingTargetSystem;
import org.qubership.automation.itf.integration.atp.util.DefinitionBuilder;
import org.qubership.automation.itf.integration.atp.util.TestRunInfo;
import org.qubership.automation.itf.integration.atp.util.TestRunInfoBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtpRunManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtpRunManager.class);
    private static AtpRunManager ourInstance = new AtpRunManager();
    private Map<BigInteger, TestRunInfo> infos = Maps.newHashMapWithExpectedSize((int)50);
    private long started = System.currentTimeMillis();

    private AtpRunManager() {
    }

    public static AtpRunManager getInstance() {
        return ourInstance;
    }

    public void put(TestRunInfo info) {
        this.infos.put(info.getTestRunId(), info);
    }

    public TestRunInfo get(BigInteger runId) {
        return this.infos.get(runId);
    }

    public void remove(BigInteger runId) {
        this.infos.remove(runId);
    }

    public long uptime() {
        return System.currentTimeMillis() - this.started;
    }

    public List<DefinitionEntry> getDefinitions(BigInteger projectId) {
        LOGGER.debug("getDefinitions request from ATP processing is started...");
        ArrayList definitions = Lists.newArrayListWithCapacity((int)2);
        for (AbstractAtpAction atpAction : ATPActionFactory.getActions()) {
            DefinitionEntry entry = new DefinitionEntry();
            entry.setId(atpAction.getName());
            entry.setDescription(atpAction.getDescription());
            entry.setDeprecated(atpAction.isDeprecated());
            entry.setMask(atpAction.getMask());
            entry.setSupportedSystems(Lists.newArrayList((Object[])new TestingTargetSystem[]{TestingTargetSystem.T_O_M_S, TestingTargetSystem.R_B_M, TestingTargetSystem.MANO, TestingTargetSystem.ICOMS}));
            entry.setAvailableValues(atpAction.getAvailableValues(projectId));
            definitions.add(entry);
        }
        LOGGER.debug("getDefinitions request from ATP is processed.");
        return definitions;
    }

    public String getAvailableActionsHash() {
        Collection<AbstractAtpAction> atpActions = ATPActionFactory.getActions();
        if (!atpActions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (AbstractAtpAction atpAction : atpActions) {
                sb.append(atpAction.getName());
            }
            return String.valueOf(sb.toString().hashCode());
        }
        return "";
    }

    public List<StepAdditionalInfo> getStepAdditionalInfo(List<StepEntity> stepEntities) {
        ArrayList result = Lists.newArrayList();
        for (StepEntity stepEntity : stepEntities) {
            String idOrName = stepEntity.getActions().get(0).getParameters().get(0).getValue();
            Collection<? extends CallChain> callchains = TestRunInfoBuilder.getCallchainsByIdOrName(idOrName, null);
            if (!callchains.isEmpty()) {
                for (CallChain callChain : callchains) {
                    StepAdditionalInfo stepAdditionalInfo = new StepAdditionalInfo();
                    stepAdditionalInfo.setInfoUrlName(callChain.getName());
                    stepAdditionalInfo.setInfoUrl(this.getCallchainUrl(callChain.getID().toString()));
                    result.add(stepAdditionalInfo);
                }
                continue;
            }
            LOGGER.warn(TestRunInfoBuilder.getCallchainNotFoundErrorMessage(idOrName));
        }
        return result;
    }

    private String getCallchainUrl(String callchainId) {
        String backUrl = DefinitionBuilder.getBackUrl();
        return StringUtils.isNotEmpty((CharSequence)backUrl) ? backUrl.concat(callchainId) : "";
    }
}

