/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.qubership.atp.adapter.common.context.TestRunContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvironmentManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByParameterAndProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.ServerObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SystemObjectManager;
import org.qubership.automation.itf.core.model.extension.Extension;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.integration.atp.action.ATPActionFactory;
import org.qubership.automation.itf.integration.atp.action.model.impl.AbstractAtpAction;
import org.qubership.automation.itf.integration.atp.model.ActionEntity;
import org.qubership.automation.itf.integration.atp.model.ConfigurationEntity;
import org.qubership.automation.itf.integration.atp.model.ContextEntity;
import org.qubership.automation.itf.integration.atp.model.DataSetEntity;
import org.qubership.automation.itf.integration.atp.model.DataSetItem;
import org.qubership.automation.itf.integration.atp.model.ResourceAttribute;
import org.qubership.automation.itf.integration.atp.model.ScopeEntity;
import org.qubership.automation.itf.integration.atp.model.StepEntity;
import org.qubership.automation.itf.integration.atp.model.TestAutomationResource;
import org.qubership.automation.itf.integration.atp.model.ram2.Ram2ExecuteStepRequest;
import org.qubership.automation.itf.integration.atp.util.CallchainRunInfo;
import org.qubership.automation.itf.integration.atp.util.TestRunInfoBuilder;
import org.qubership.automation.itf.report.extension.InstanceRamExtension;
import org.qubership.automation.itf.report.extension.TCContextRamExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunInfo {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestRunInfo.class);
    private static final String INBOUND = "inbound";
    private static final String OUTBOUND = "outbound";
    private String project;
    private BigInteger testRunId;
    private String ram2TestRunId;
    private String testRunName;
    private DataSetEntity dataSet;
    private String atpRamUrl;
    private ContextEntity context;
    private JsonContext contextToMerge;
    private JSONObject atpContext;
    private BigInteger logRecordId;
    private ScopeEntity scope;
    private ConfigurationEntity configuration;
    private List<CallchainRunInfo> callchainsToExecute = new ArrayList<CallchainRunInfo>();
    private Environment environment;
    private Map<String, Set<System>> systems = new HashMap<String, Set<System>>();
    private Map<String, String> tcpDumpOptions = null;
    private String bvAction = null;
    private TestRunContext ramTestRunContext;
    private UUID atpEnvironmentId;
    private boolean validateMessageOnStep = false;
    private boolean prepared = false;
    private StartedFrom startedFrom;
    private BigInteger projectId;
    private UUID projectUuid;

    public BigInteger getTestRunId() {
        return this.testRunId;
    }

    public void setTestRunId(BigInteger testRunId) {
        this.testRunId = testRunId;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getTestRunName() {
        return this.testRunName;
    }

    public void setTestRunName(String testRunName) {
        this.testRunName = testRunName;
    }

    public DataSetEntity getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSetEntity dataSet) {
        this.dataSet = dataSet;
    }

    public String getAtpRamUrl() {
        return this.atpRamUrl;
    }

    public void setAtpRamUrl(String atpRamUrl) {
        this.atpRamUrl = atpRamUrl;
    }

    public ContextEntity getContext() {
        return this.context;
    }

    public void setContext(ContextEntity context) {
        this.context = context;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public StartedFrom getStartedFrom() {
        return this.startedFrom;
    }

    public void setStartedFrom(StartedFrom startedFrom) {
        this.startedFrom = startedFrom;
    }

    public String getRam2TestRunId() {
        return this.ram2TestRunId;
    }

    public void setRam2TestRunId(String ram2TestRunId) {
        this.ram2TestRunId = ram2TestRunId;
    }

    public JsonContext getContextToMerge() {
        JsonContext context = new JsonContext();
        context.putAll((Map)this.contextToMerge);
        return context;
    }

    public void fillParamsFromRequest(Ram2ExecuteStepRequest request) {
        this.setContext(request.getContext());
        this.setProjectInfo(request.getContext());
        this.setLogRecordId(request.getLogRecordId());
        this.setScope(request.getScope());
        this.setConfiguration(request.getConfiguration());
        this.setProject(request.getProjectName());
        this.setAtpRamUrl(request.getAtpRamUrl());
        this.setAtpEnvironmentId(request.getContext());
    }

    public void build() {
        this.prepareContext();
        LOGGER.debug("{} - Context is prepared", (Object)this.erInfo());
        this.prepareScope();
        LOGGER.debug("{} - Scope is prepared", (Object)this.erInfo());
        this.prepareEnvironment();
        LOGGER.debug("{} - Environment is prepared", (Object)this.erInfo());
        this.prepared = true;
    }

    public AbstractInstance createInstanceForReport() {
        TCContextRamExtension tcContextRamExtension = new TCContextRamExtension();
        tcContextRamExtension.setAsync(Boolean.valueOf(false));
        tcContextRamExtension.setRunId(this.getTestRunId());
        tcContextRamExtension.setRunContext(this.ramTestRunContext);
        TcContext tc = new TcContext();
        if (this.ramTestRunContext.getAtpCompaund() != null) {
            tc.setID((Object)this.ramTestRunContext.getAtpCompaund().getSectionId());
        }
        tc.setStartedFrom(this.startedFrom);
        tc.setProjectId(this.projectId);
        tc.setProjectUuid(this.projectUuid);
        tc.setNeedToReportToAtp(true);
        tc.extend((Extension)tcContextRamExtension);
        InstanceRamExtension extension = new InstanceRamExtension();
        extension.setSectionId(this.getLogRecordId());
        CallChainInstance instance = new CallChainInstance();
        instance.setName("Errors");
        instance.setID((Object)BigInteger.valueOf(1000 + (int)(Math.random() * 999001.0)));
        instance.getContext().setTC(tc);
        instance.extend((Extension)extension);
        tc.setInitiator((AbstractContainerInstance)instance);
        return instance;
    }

    private void prepareScope() {
        for (StepEntity entity : this.scope.getSteps()) {
            for (ActionEntity actionEntity : entity.getActions()) {
                CallChain callChain;
                String callChainName;
                boolean actionWasIdentified = false;
                for (AbstractAtpAction atpAction : ATPActionFactory.getActions()) {
                    Pattern atpActionPattern = Pattern.compile(atpAction.getTemplate());
                    Matcher matcher = atpActionPattern.matcher(actionEntity.getName());
                    if (!matcher.find() || matcher.groupCount() < 1) continue;
                    atpAction.setTestRunInfoParams(this, matcher);
                    actionWasIdentified = true;
                    break;
                }
                if (actionWasIdentified || StringUtils.isBlank((CharSequence)(callChainName = actionEntity.getName())) || (callChain = (CallChain)Iterables.getFirst((Iterable)((SearchByParameterAndProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(CallChain.class, SearchByParameterAndProjectIdManager.class)).getByNameAndProjectId(callChainName, this.getProjectId()), null)) == null) continue;
                this.callchainsToExecute.add(new CallchainRunInfo(callChain, null));
            }
        }
    }

    private void prepareContext() {
        this.contextToMerge = new JsonContext();
        JSONObject dataSetObject = new JSONObject();
        if (this.dataSet != null) {
            for (DataSetItem dataSetItem : this.dataSet.getVariables()) {
                String dataSetItemName = dataSetItem.getName();
                if (this.itemNameNotValid(dataSetItemName)) continue;
                String dataSetItemValue = dataSetItem.getValue();
                if (dataSetItemName.contains(".")) {
                    dataSetObject = this.parseItem(dataSetItemName, dataSetItemValue, dataSetObject);
                    continue;
                }
                dataSetObject.put((Object)dataSetItemName, (Object)dataSetItemValue);
            }
            this.contextToMerge.merge((Map)dataSetObject);
            this.contextToMerge.put((Object)"dataset", (Object)dataSetObject);
        }
        try {
            this.atpContext = (JSONObject)new JSONParser().parse(this.context.getJsonString());
            JSONObject atpContextObject = new JSONObject();
            this.performContext(this.atpContext, atpContextObject);
            this.contextToMerge.merge((Map)atpContextObject);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse ATP context ", (Throwable)e);
            throw this.reportException("Cannot parse ATP context because of error: " + e.getMessage());
        }
    }

    protected void performContext(JSONObject flatContext, JSONObject contextObject) {
        for (String item : flatContext.keySet()) {
            if (item.contains(".")) {
                Object value = flatContext.get((Object)item) == null ? null : flatContext.get((Object)item);
                contextObject = this.parseItem(item, value, contextObject);
                continue;
            }
            this.parseItemValue(item, flatContext, contextObject);
        }
    }

    private boolean itemNameNotValid(String name) {
        return StringUtils.isEmpty((CharSequence)name) || ".".equals(name) || StringUtils.isWhitespace((CharSequence)name);
    }

    protected JSONObject parseItem(String contextItem, Object itemValue, JSONObject contextObject) {
        String element;
        String[] arrayOfElements = contextItem.split("\\.");
        int amountOfElements = arrayOfElements.length - 1;
        int elementNumber = 0;
        JSONObject currentObject = contextObject;
        if (elementNumber == amountOfElements && currentObject.containsKey((Object)contextItem)) {
            return contextObject;
        }
        while (elementNumber < amountOfElements) {
            JSONObject in;
            Object obj;
            element = arrayOfElements[elementNumber];
            String nextElement = arrayOfElements[elementNumber + 1];
            if (!currentObject.containsKey((Object)element)) {
                currentObject.put((Object)element, (Object)new JSONObject());
            }
            if (!((obj = currentObject.get((Object)element)) instanceof JSONObject)) {
                currentObject.put((Object)element, (Object)new JSONObject());
            }
            if (!(in = (JSONObject)currentObject.get((Object)element)).containsKey((Object)nextElement)) {
                ((Map)currentObject.get((Object)element)).put(nextElement, amountOfElements - elementNumber != 1 ? new JSONObject() : "");
            }
            ++elementNumber;
            currentObject = (JSONObject)currentObject.get((Object)element);
        }
        element = arrayOfElements[arrayOfElements.length - 1];
        if (itemValue instanceof String && StringUtils.isEmpty((CharSequence)((String)itemValue)) || Objects.isNull(itemValue)) {
            currentObject.putIfAbsent((Object)element, itemValue);
        } else if (itemValue instanceof JSONObject) {
            JSONObject childJsonObject = (JSONObject)itemValue;
            JSONObject newChildJsonObject = new JSONObject();
            this.performContext(childJsonObject, newChildJsonObject);
            if (currentObject.containsKey((Object)element) && "".equals(currentObject.get((Object)element))) {
                currentObject.remove((Object)element);
            }
            currentObject.putIfAbsent((Object)element, (Object)newChildJsonObject);
        } else if (itemValue instanceof JSONArray) {
            JSONArray childJsonArray = (JSONArray)itemValue;
            JSONArray newChildJsonArray = new JSONArray();
            for (Object obj : childJsonArray) {
                if (obj instanceof JSONObject) {
                    JSONObject childJsonObject = (JSONObject)obj;
                    JSONObject newChildJsonObject = new JSONObject();
                    this.performContext(childJsonObject, newChildJsonObject);
                    newChildJsonArray.add((Object)newChildJsonObject);
                    continue;
                }
                newChildJsonArray.add(obj);
            }
            currentObject.put((Object)element, (Object)newChildJsonArray);
        } else {
            currentObject.put((Object)element, itemValue);
        }
        return contextObject;
    }

    private void parseItemValue(String item, JSONObject flatContext, JSONObject contextObject) {
        if (flatContext.get((Object)item) instanceof JSONObject) {
            JSONObject childJsonObject = (JSONObject)flatContext.get((Object)item);
            JSONObject newChildJsonObject = new JSONObject();
            this.performContext(childJsonObject, newChildJsonObject);
            contextObject.putIfAbsent((Object)item, (Object)newChildJsonObject);
        } else if (flatContext.get((Object)item) instanceof JSONArray) {
            JSONArray childJsonArray = (JSONArray)flatContext.get((Object)item);
            JSONArray newChildJsonArray = new JSONArray();
            for (Object obj : childJsonArray) {
                if (obj instanceof JSONObject) {
                    JSONObject childJsonObject = (JSONObject)obj;
                    JSONObject newChildJsonObject = new JSONObject();
                    this.performContext(childJsonObject, newChildJsonObject);
                    newChildJsonArray.add((Object)newChildJsonObject);
                    continue;
                }
                newChildJsonArray.add(obj);
            }
            contextObject.putIfAbsent((Object)item, (Object)newChildJsonArray);
        } else {
            contextObject.putIfAbsent((Object)item, flatContext.get((Object)item));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareEnvironment() {
        String url = this.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw this.reportException("Can't determine environment; cause: configuration#currentResource.URL is null or empty!");
        }
        this.getSystemsFromCallChains();
        if (this.systems.get(OUTBOUND).isEmpty()) throw this.reportException(String.format("Can't determine environment by configuration#currentResource.URL (URL is: '%s'); cause: Systems List is empty for callchain!", url));
        List servers = ((ServerObjectManager)CoreObjectManager.getInstance().getSpecialManager(Server.class, ServerObjectManager.class)).getByUrlSlashedAndProjectId(url, this.getProjectId());
        if (servers == null || servers.isEmpty()) throw this.reportException(String.format("Can't determine environment; cause: Server is not found by configuration#currentResource.URL (URL is: '%s')!", url));
        Environment env = ((EnvironmentManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentManager.class)).findByServerAndSystems((BigInteger)((Server)servers.get(0)).getID(), this.getIds(this.systems.get(OUTBOUND)));
        if (env == null) {
            throw this.reportException(String.format("Can't determine environment by configuration#currentResource.URL (URL is: '%s'); cause: There is no environment with proper system+server settings.", url));
        }
        this.environment = env;
    }

    private List<BigInteger> getIds(Set<System> objs) {
        return objs.stream().map(system -> (BigInteger)system.getID()).collect(Collectors.toList());
    }

    private void getSystemsFromCallChains() {
        HashSet inboundSystems = new HashSet();
        HashSet outboundSystems = new HashSet();
        HashSet<Object> chainIds = new HashSet<Object>();
        this.systems.put(INBOUND, inboundSystems);
        this.systems.put(OUTBOUND, outboundSystems);
        for (CallchainRunInfo callchainRunInfo : this.callchainsToExecute) {
            if (callchainRunInfo.getCallChain() == null || chainIds.contains(callchainRunInfo.getCallChain().getID())) continue;
            outboundSystems.addAll(((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getReceiverSystemsFromCallChainSteps(callchainRunInfo.getCallChain().getID()));
            chainIds.add(callchainRunInfo.getCallChain().getID());
        }
    }

    public BigInteger getLogRecordId() {
        return this.logRecordId;
    }

    public void setLogRecordId(BigInteger logRecordId) {
        this.logRecordId = logRecordId;
    }

    public ScopeEntity getScope() {
        return this.scope;
    }

    public void setScope(ScopeEntity scope) {
        this.scope = scope;
    }

    public ConfigurationEntity getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationEntity configuration) {
        this.configuration = configuration;
    }

    public ContextEntity getContextToReturn() {
        ContextEntity contextEntity = new ContextEntity();
        contextEntity.setJsonString(this.atpContext == null ? "{}" : this.atpContext.toJSONString());
        return contextEntity;
    }

    private String getUrl() {
        TestAutomationResource currentResource = this.configuration.getCurrentResource();
        if (currentResource != null) {
            List<ResourceAttribute> attributes = currentResource.getAttributes();
            if (attributes != null) {
                for (ResourceAttribute attribute : attributes) {
                    if (!"url".equals(attribute.getName())) continue;
                    return attribute.getValue();
                }
            }
            throw this.reportException(String.format("Can't determine environment; cause: configuration#currentResource (id: %s, type: %s): 'url' attribute is missed!", currentResource.getId(), currentResource.getType()));
        }
        throw this.reportException("Can't determine environment; cause: configuration#currentResource is missed!");
    }

    public Map<String, String> getTcpDumpOptions() {
        return this.tcpDumpOptions;
    }

    public void setTcpDumpOptions(Map<String, String> tcpDumpOptions) {
        this.tcpDumpOptions = tcpDumpOptions;
    }

    public String getBvAction() {
        return this.bvAction;
    }

    public void setBvAction(String bvAction) {
        this.bvAction = bvAction;
    }

    public List<CallchainRunInfo> getCallchainsToExecute() {
        return this.callchainsToExecute;
    }

    public void setCallchainsToExecute(List<CallchainRunInfo> callchainsToExecute) {
        this.callchainsToExecute = callchainsToExecute;
    }

    public TestRunContext getRamTestRunContext() {
        return this.ramTestRunContext;
    }

    public void setRamTestRunContext(TestRunContext ramTestRunContext) {
        this.ramTestRunContext = ramTestRunContext;
    }

    public boolean isValidateMessageOnStep() {
        return this.validateMessageOnStep;
    }

    public void setValidateMessageOnStep(boolean validateMessageOnStep) {
        this.validateMessageOnStep = validateMessageOnStep;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public IllegalArgumentException reportException(String message) {
        LOGGER.error("{} failed: {}", (Object)this.erInfo(), (Object)message);
        IllegalArgumentException exception = new IllegalArgumentException(message);
        AbstractInstance abstractInstance = this.createInstanceForReport();
        Report.openSection((AbstractInstance)abstractInstance, (String)"Errors");
        Report.error((AbstractInstance)abstractInstance, (String)exception.getMessage(), (String)exception.getMessage(), (Throwable)exception);
        Report.closeSection((AbstractInstance)abstractInstance);
        Report.stopRun((InstanceContext)abstractInstance.getContext(), (Status)Status.FAILED);
        return exception;
    }

    private String erInfo() {
        return "ER from " + this.startedFrom.toString() + " (project: " + this.project + ", RunId: " + this.ram2TestRunId + ", Test Run Name: " + this.testRunName + ")";
    }

    public void reportError(String sectionName, String title, String message, Throwable exception) {
        AbstractInstance abstractInstance = this.createInstanceForReport();
        Report.openSection((AbstractInstance)abstractInstance, (String)sectionName);
        Report.error((AbstractInstance)abstractInstance, (String)title, (String)message, (Throwable)exception);
        Report.closeSection((AbstractInstance)abstractInstance);
        Report.stopRun((InstanceContext)abstractInstance.getContext(), (Status)Status.FAILED);
    }

    public BigInteger getProjectId() {
        return this.projectId;
    }

    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    public UUID getProjectUuid() {
        return this.projectUuid;
    }

    public void setProjectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
    }

    private void setProjectInfo(ContextEntity contextEntity) {
        try {
            String projectUUID = TestRunInfoBuilder.getParameterValueFromContextEntity(contextEntity, "projectId");
            if (StringUtils.isEmpty((CharSequence)projectUUID)) {
                String error = "Project UUID from ATP-request is empty! ITF-project can not be found!";
                LOGGER.error(error);
                throw new IllegalArgumentException(error);
            }
            UUID projectUuid = UUID.fromString(projectUUID);
            BigInteger internalProjectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
            if (internalProjectId == null) {
                String error = String.format("ITF-project was not found by UUID = %s", projectUuid);
                LOGGER.error(error);
                throw new IllegalArgumentException(error);
            }
            this.setProjectId(internalProjectId);
            this.setProjectUuid(projectUuid);
        }
        catch (JsonProcessingException e) {
            String error = "Can not parse the request from ATP to get the project UUID!";
            LOGGER.error(error);
            throw new IllegalArgumentException(error, e);
        }
    }

    public UUID getAtpEnvironmentId() {
        return this.atpEnvironmentId;
    }

    private void setAtpEnvironmentId(ContextEntity contextEntity) {
        try {
            String environmentId = TestRunInfoBuilder.getParameterValueFromContextEntity(contextEntity, "environmentId");
            if (StringUtils.isEmpty((CharSequence)environmentId)) {
                String error = "Environment UUID from ATP-request is empty! Please check parameter 'environmentId' in ATP context.";
                LOGGER.error(error);
                throw new IllegalArgumentException(error);
            }
            this.atpEnvironmentId = UUID.fromString(environmentId);
        }
        catch (JsonProcessingException e) {
            String error = "Can not parse the request from ATP to get the environment UUID!";
            LOGGER.error(error);
            throw new IllegalArgumentException(error, e);
        }
    }
}

