/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.integration.atp.exector.AtpCallchainExecutor;
import org.qubership.automation.itf.integration.atp.util.CallchainRunInfo;
import org.qubership.automation.itf.integration.atp.util.TestRunInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class CallchainRunner
implements Runnable {
    public static final Logger LOGGER = LoggerFactory.getLogger(CallchainRunner.class);
    private CallchainRunInfo callchainRunInfo;
    private TestRunInfo testRunInfo;
    private AtomicBoolean isFailed;
    private AtpCallchainExecutor atpCallchainExecutor;

    @Autowired
    public CallchainRunner(AtpCallchainExecutor atpCallchainExecutor) {
        this.atpCallchainExecutor = atpCallchainExecutor;
    }

    public void fillRunInfo(CallchainRunInfo callchainRunInfo, TestRunInfo testRunInfo, AtomicBoolean isFailed) {
        this.callchainRunInfo = callchainRunInfo;
        this.testRunInfo = testRunInfo;
        this.isFailed = isFailed;
    }

    @Override
    public void run() {
        TcContext result;
        try {
            result = this.executeCallChain();
        }
        catch (Exception e) {
            String title = String.format("Execution of '%s' callchain from ATP is failed.", this.callchainRunInfo.getCallChain().getName());
            this.testRunInfo.reportError("Errors", title, "", e);
            LOGGER.error(title, (Throwable)e);
            result = new TcContext();
            result.setStatus(Status.FAILED);
            this.isFailed.set(true);
        }
        this.callchainRunInfo.setTcContext(result);
    }

    private TcContext executeCallChain() throws Exception {
        TcContext context = this.atpCallchainExecutor.execute(this.callchainRunInfo, this.testRunInfo);
        if (context == null) {
            return new TcContext();
        }
        switch (context.getStatus()) {
            case FAILED: 
            case FAILED_BY_TIMEOUT: 
            case STOPPED: {
                this.isFailed.set(true);
                break;
            }
            default: {
                this.isFailed.set(false);
            }
        }
        context.remove((Object)"dataset");
        return context;
    }
}

