/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp.util;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.CallChainObjectManager;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.integration.atp.action.ATPActionConstants;
import org.qubership.automation.itf.integration.atp.model.AdvancedValue;
import org.qubership.automation.itf.integration.atp.model.ArgumentValue;

public class DefinitionBuilder {
    public static ArgumentValue getAvailableCallchainsList(BigInteger projectId) {
        return DefinitionBuilder.newArgumentValue(ATPActionConstants.CALLCHAIN_INDEX.intValue(), DefinitionBuilder.createAdvancedValueListWithCallChains(projectId));
    }

    public static ArgumentValue getAvailableDatasetsEmptyList() {
        return DefinitionBuilder.newArgumentValue(ATPActionConstants.DATASET_INDEX.intValue(), Lists.newArrayList());
    }

    public static ArgumentValue getAvailableCallchainLabelList() {
        return DefinitionBuilder.newArgumentValue(ATPActionConstants.LABEL_INDEX.intValue(), Lists.newArrayList());
    }

    public static ArgumentValue getAvailableValuesList(int argumentNumber, String[] values) {
        return DefinitionBuilder.newArgumentValue(argumentNumber, DefinitionBuilder.createAdvancedValueListWithStringValues(values));
    }

    static String getBackUrl() {
        return Config.getConfig().getRunningUrl() + ATPActionConstants.ITF_TC_URL_TEMPLATE.stringValue();
    }

    public static List<AdvancedValue> createAdvancedValueListWithCallChains(BigInteger projectId) {
        ArrayList result = Lists.newArrayList();
        if (projectId != null) {
            List list = ((CallChainObjectManager)CoreObjectManager.getInstance().getSpecialManager(CallChain.class, CallChainObjectManager.class)).getSimpleListByProject(projectId);
            for (IdNamePair elem : list) {
                AdvancedValue data = new AdvancedValue();
                data.setId(elem.getId());
                data.setValue(elem.getName());
                result.add(data);
            }
        }
        return result;
    }

    private static List<AdvancedValue> createAdvancedValueListWithStringValues(String[] values) {
        ArrayList result = Lists.newArrayList();
        for (String value : values) {
            AdvancedValue data = new AdvancedValue();
            data.setId("");
            data.setValue(value);
            result.add(data);
        }
        return result;
    }

    private static ArgumentValue newArgumentValue(int argumentNumber, List<AdvancedValue> availableValues) {
        ArgumentValue argumentValue = new ArgumentValue();
        argumentValue.setArgumentNumber(argumentNumber);
        argumentValue.setCanBeCustom(false);
        argumentValue.setBackUrl(DefinitionBuilder.getBackUrl());
        argumentValue.setAdvValues(availableValues);
        return argumentValue;
    }
}

