/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp2.kafka;

import java.util.UUID;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"})
public class EnvironmentsNotificationKafkaListener {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsNotificationKafkaListener.class);

    @KafkaListener(topics={"${kafka.topic.environments_notification}"})
    public void listen(@Payload String message) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(message);
            UUID id = UUID.fromString(json.get((Object)"id").toString());
            CacheServices.getEnvironmentCacheService().invalidate((Object)id);
        }
        catch (ParseException e) {
            log.error("Converting message to JSON fails with error. Message: {}. Error: {}", (Object)message, (Object)e.getMessage());
        }
    }
}

