/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp2.kafka.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.UUID;
import org.qubership.automation.itf.core.util.constants.DatasetFormat;
import org.qubership.automation.itf.integration.atp2.kafka.dto.EventType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectEvent {
    private UUID projectId;
    private String projectName;
    private DatasetFormat datasetFormat;
    private EventType type;
    private SimpleDateFormat dateFormat;
    private DateTimeFormatter timeFormat;
    private TimeZone timeZone;

    public ProjectEvent(@JsonProperty(value="projectId") String projectId, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="datasetFormat") String datasetFormat, @JsonProperty(value="type") String type, @JsonProperty(value="dateFormat") String dateFormat, @JsonProperty(value="timeFormat") String timeFormat, @JsonProperty(value="timeZone") String timeZone) {
        this.projectId = UUID.fromString(projectId);
        this.projectName = projectName;
        this.datasetFormat = DatasetFormat.valueOf((String)datasetFormat.toUpperCase());
        this.type = EventType.valueOf(type.toUpperCase());
        this.dateFormat = new SimpleDateFormat(dateFormat);
        this.timeFormat = DateTimeFormatter.ofPattern(timeFormat);
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public DatasetFormat getDatasetFormat() {
        return this.datasetFormat;
    }

    public EventType getType() {
        return this.type;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public DateTimeFormatter getTimeFormat() {
        return this.timeFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDatasetFormat(DatasetFormat datasetFormat) {
        this.datasetFormat = datasetFormat;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setTimeFormat(DateTimeFormatter timeFormat) {
        this.timeFormat = timeFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectEvent)) {
            return false;
        }
        ProjectEvent other = (ProjectEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        DatasetFormat this$datasetFormat = this.getDatasetFormat();
        DatasetFormat other$datasetFormat = other.getDatasetFormat();
        if (this$datasetFormat == null ? other$datasetFormat != null : !this$datasetFormat.equals(other$datasetFormat)) {
            return false;
        }
        EventType this$type = this.getType();
        EventType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        SimpleDateFormat this$dateFormat = this.getDateFormat();
        SimpleDateFormat other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !((Object)this$dateFormat).equals(other$dateFormat)) {
            return false;
        }
        DateTimeFormatter this$timeFormat = this.getTimeFormat();
        DateTimeFormatter other$timeFormat = other.getTimeFormat();
        if (this$timeFormat == null ? other$timeFormat != null : !this$timeFormat.equals(other$timeFormat)) {
            return false;
        }
        TimeZone this$timeZone = this.getTimeZone();
        TimeZone other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 0 : ((Object)$projectId).hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 0 : $projectName.hashCode());
        DatasetFormat $datasetFormat = this.getDatasetFormat();
        result = result * 59 + ($datasetFormat == null ? 0 : $datasetFormat.hashCode());
        EventType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : ((Object)((Object)$type)).hashCode());
        SimpleDateFormat $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 0 : ((Object)$dateFormat).hashCode());
        DateTimeFormatter $timeFormat = this.getTimeFormat();
        result = result * 59 + ($timeFormat == null ? 0 : $timeFormat.hashCode());
        TimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 0 : $timeZone.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectEvent(projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", datasetFormat=" + this.getDatasetFormat() + ", type=" + (Object)((Object)this.getType()) + ", dateFormat=" + this.getDateFormat() + ", timeFormat=" + this.getTimeFormat() + ", timeZone=" + this.getTimeZone() + ")";
    }
}

