/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp2;

import java.util.Optional;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.qubership.atp.adapter.common.utils.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"default"})
public class AuthTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(AuthTokenProvider.class);
    private final AccessTokenProvider accessTokenProvider;
    private final OAuth2ProtectedResourceDetails protectedResourceDetails;
    private final AccessTokenRequest accessTokenRequest = new DefaultAccessTokenRequest();

    public AuthTokenProvider(AccessTokenProvider accessTokenProvider, OAuth2ProtectedResourceDetails protectedResourceDetails) {
        this.accessTokenProvider = accessTokenProvider;
        this.protectedResourceDetails = protectedResourceDetails;
        this.registerHttpClientInterceptors();
    }

    public Optional<String> getAuthToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Optional<String> relayToken = Optional.ofNullable(authentication).map(Authentication::getPrincipal).filter(principal -> principal instanceof KeycloakPrincipal).map(principal -> (KeycloakPrincipal)principal).map(KeycloakPrincipal::getKeycloakSecurityContext).map(KeycloakSecurityContext::getTokenString);
        if (relayToken.isPresent()) {
            return relayToken;
        }
        OAuth2AccessToken accessToken = this.accessTokenProvider.obtainAccessToken(this.protectedResourceDetails, this.accessTokenRequest);
        return Optional.ofNullable(accessToken.getValue());
    }

    private void registerHttpClientInterceptors() {
        RequestUtils.registerHttpInterceptor((httpRequest, httpContext) -> {
            log.debug("Getting a token. Process [httpRequest={}]", (Object)httpRequest);
            Optional<String> bearerToken = this.getAuthToken();
            if (bearerToken.isPresent()) {
                httpRequest.addHeader("Authorization", String.format("%s %s", "Bearer", bearerToken.get()));
            } else {
                log.warn("Token is empty.");
            }
        });
    }
}

