/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp2.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.integration.atp2.kafka.ProjectEventListener;
import org.qubership.automation.itf.integration.atp2.kafka.dto.ItfLiteEventDiameter;
import org.qubership.automation.itf.integration.atp2.kafka.dto.ItfLiteEventRestSoap;
import org.qubership.automation.itf.integration.atp2.kafka.dto.RequestTransportType;
import org.qubership.automation.itf.integration.atp2.kafka.service.impl.ItfLiteExportServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"})
public class ItfLiteEventKafkaListener
implements ProjectEventListener {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ItfLiteExportServiceImpl itfLiteExportService;
    private final CoreObjectManagerService coreObjectManagerService;
    @Value(value="${atp.multi-tenancy.enabled}")
    private boolean multiTenancyEnabled;

    @Override
    @KafkaListener(topics={"${kafka.topic.itf.lite.export.start}"})
    public void listen(@Payload String event) {
        try {
            JsonNode jsonNode = new ObjectMapper().readTree(event);
            if (jsonNode.get("itfUrl").asText().contains("atp-itf-executor")) {
                String projectUuid = jsonNode.get("projectId").asText();
                if (this.multiTenancyEnabled) {
                    TenantContext.setTenantInfo((String)projectUuid);
                    this.processEvent(event, jsonNode, projectUuid);
                    TenantContext.setDefaultTenantInfo();
                } else {
                    this.processEvent(event, jsonNode, projectUuid);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong while processing itf lite export event: '" + event + "'", e);
        }
    }

    private void processEvent(String event, JsonNode jsonNode, String projectUuid) throws JsonProcessingException, IllegalArgumentException {
        this.checkProjectExist(projectUuid);
        String transportType = jsonNode.get("request").get("transportType").asText();
        switch (RequestTransportType.valueOf(transportType.toUpperCase())) {
            case REST: 
            case SOAP: {
                ItfLiteEventRestSoap itfLiteEventRestSoap = (ItfLiteEventRestSoap)MAPPER.readValue(event, ItfLiteEventRestSoap.class);
                MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)itfLiteEventRestSoap.getProjectId());
                this.itfLiteExportService.createTemplateFromRestSoapTransportType(event, itfLiteEventRestSoap);
                break;
            }
            case DIAMETER: {
                ItfLiteEventDiameter itfLiteEventDiameter = (ItfLiteEventDiameter)MAPPER.readValue(event, ItfLiteEventDiameter.class);
                MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)itfLiteEventDiameter.getProjectId());
                this.itfLiteExportService.createTemplateFromDiameterTransportType(event, itfLiteEventDiameter);
                break;
            }
            default: {
                throw new RuntimeException("Unknown transport event type: " + transportType);
            }
        }
    }

    private void checkProjectExist(String projectUuid) {
        BigInteger projectId = ((SearchManager)this.coreObjectManagerService.getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(UUID.fromString(projectUuid));
        if (Objects.isNull(projectId)) {
            throw new IllegalArgumentException("Project id was not found for the specified project UUID: " + projectUuid);
        }
        StubProject project = (StubProject)this.coreObjectManagerService.getManager(StubProject.class).getById((Object)projectId);
        if (Objects.isNull(project)) {
            throw new IllegalArgumentException("Project is not found by id: " + projectId);
        }
    }

    @ConstructorProperties(value={"itfLiteExportService", "coreObjectManagerService"})
    public ItfLiteEventKafkaListener(ItfLiteExportServiceImpl itfLiteExportService, CoreObjectManagerService coreObjectManagerService) {
        this.itfLiteExportService = itfLiteExportService;
        this.coreObjectManagerService = coreObjectManagerService;
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true);
    }
}

