/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp2.kafka;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.integration.atp2.kafka.ProjectEventListener;
import org.qubership.automation.itf.integration.atp2.kafka.dto.ProjectEvent;
import org.qubership.automation.itf.integration.atp2.kafka.service.ProjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@EnableKafka
@Component
@ComponentScan(value={"org.qubership.automation.itf.integration.atp2.kafka"})
@ConditionalOnProperty(value={"kafka.enable"})
public class ProjectEventKafkaListener
implements ProjectEventListener {
    private final ObjectMapper objectMapper = this.initMapper();
    private final ProjectService projectService;

    @Autowired
    public ProjectEventKafkaListener(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Override
    @KafkaListener(id="${spring.kafka.consumer.group-id}", topics={"${kafka.topic}"})
    public void listen(@Payload String event) {
        ProjectEvent projectEvent;
        try {
            projectEvent = (ProjectEvent)this.objectMapper.readValue(event, ProjectEvent.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't parse project event received: '" + event + "'", e);
        }
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectEvent.getProjectId());
        switch (projectEvent.getType()) {
            case CREATE: {
                this.projectService.create(event, projectEvent);
                break;
            }
            case UPDATE: {
                this.projectService.update(event, projectEvent);
                break;
            }
            case DELETE: {
                this.projectService.delete(event, projectEvent);
                break;
            }
            default: {
                throw new RuntimeException("Unknown project event type: " + (Object)((Object)projectEvent.getType()));
            }
        }
    }

    private ObjectMapper initMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }
}

