/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp2.kafka.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.qubership.automation.itf.core.exceptions.common.NotValidValueException;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.integration.atp2.kafka.dto.ItfLiteEvent;
import org.qubership.automation.itf.integration.atp2.kafka.dto.ItfLiteEventDiameter;
import org.qubership.automation.itf.integration.atp2.kafka.dto.ItfLiteEventRestSoap;
import org.qubership.automation.itf.integration.atp2.kafka.dto.RequestTransportType;
import org.qubership.automation.itf.integration.atp2.kafka.dto.messages.request.DiameterRequestData;
import org.qubership.automation.itf.integration.atp2.kafka.dto.messages.request.RestSoapRequestData;
import org.qubership.automation.itf.integration.atp2.kafka.dto.messages.response.ResponseData;
import org.qubership.automation.itf.integration.atp2.kafka.dto.messages.response.ResponseStatus;
import org.qubership.automation.itf.integration.atp2.kafka.service.impl.KafkaProducerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ItfLiteExportService")
public class ItfLiteExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ItfLiteExportServiceImpl.class);
    private static final String REST_OUTBOUND_TRANSPORT = "org.qubership.automation.itf.transport.rest.outbound.RESTOutboundTransport";
    private static final String DIAMETER_OUTBOUND_TRANSPORT = "org.qubership.automation.itf.transport.diameter.outbound.DiameterOutbound";
    private static final String SOAP_OUTBOUND_TRANSPORT = "org.qubership.automation.itf.transport.soap.http.outbound.SOAPOverHTTPOutboundTransport";
    private final KafkaProducerService kafkaProducerService;
    private final Environment environment;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public ItfLiteExportServiceImpl(KafkaProducerService kafkaProducerService, Environment environment) {
        this.kafkaProducerService = kafkaProducerService;
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void createTemplateFromRestSoapTransportType(String event, ItfLiteEventRestSoap itfLiteEvent) throws JsonProcessingException {
        log.info("'Create Template' Event is received: {}", (Object)event);
        RestSoapRequestData request = itfLiteEvent.getRequest();
        ResponseData response = new ResponseData();
        try {
            OperationTemplate template = this.createTemplate(itfLiteEvent);
            template.setName(request.getName());
            template.setText(request.getBody() == null ? null : request.getBody().getContent());
            template.fillTransportProperties(this.createTransportConfig(template, request));
            template.store();
            log.info("Template {} is created", (Object)template);
            this.createSituation(itfLiteEvent, template);
            response.setItfRequestUrl(this.getItfRequestUrl(itfLiteEvent, template.getID()));
            response.setStatus(ResponseStatus.Done);
        }
        catch (Exception e) {
            this.processException(itfLiteEvent.getId(), e, response);
        }
        finally {
            this.sendMessageToKafka(itfLiteEvent.getId(), request.getId(), response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void createTemplateFromDiameterTransportType(String event, ItfLiteEventDiameter itfLiteEvent) {
        log.info("'Create Template' Event is received: {}", (Object)event);
        DiameterRequestData request = itfLiteEvent.getRequest();
        ResponseData response = new ResponseData();
        try {
            OperationTemplate template = this.createTemplate(itfLiteEvent);
            template.setName(request.getName());
            template.setText(request.getBody() == null ? null : request.getBody().getContent());
            ArrayList templateProperties = Lists.newArrayList();
            OutboundTemplateTransportConfiguration outboundTemplateTransportConfiguration = new OutboundTemplateTransportConfiguration(DIAMETER_OUTBOUND_TRANSPORT, (Template)template);
            HashMap configuration = Maps.newHashMap();
            configuration.put("interceptorName", request.getResponseType());
            outboundTemplateTransportConfiguration.fillConfiguration((Map)configuration);
            templateProperties.add(outboundTemplateTransportConfiguration);
            template.fillTransportProperties((Collection)templateProperties);
            template.store();
            log.info("Template {} is created", (Object)template);
            this.createSituation(itfLiteEvent, template);
            response.setItfRequestUrl(this.getItfRequestUrl(itfLiteEvent, template.getID()));
            response.setStatus(ResponseStatus.Done);
        }
        catch (Exception e) {
            this.processException(itfLiteEvent.getId(), e, response);
        }
        finally {
            this.sendMessageToKafka(itfLiteEvent.getId(), request.getId(), response);
        }
    }

    private void processException(UUID itfLiteEventId, Exception exception, ResponseData response) {
        String msg = exception instanceof IllegalArgumentException ? "Request has an inappropriate Transport" : String.format("Unexpected exception when create Template with eventId '%s'", itfLiteEventId);
        log.error(msg, (Throwable)exception);
        response.setStatus(ResponseStatus.Error);
        response.setErrorMessage(msg);
    }

    private void sendMessageToKafka(UUID itfLiteEventId, UUID requestId, ResponseData response) {
        try {
            log.info("Send message to kafka with eventId '{}'", (Object)itfLiteEventId);
            response.setId(itfLiteEventId);
            response.setRequestId(requestId);
            this.kafkaProducerService.send(this.objectMapper.writeValueAsString((Object)response), itfLiteEventId.toString());
        }
        catch (Exception e) {
            String msg = String.format("Exception thrown when sending with key {%s}. KafkaProducerService can't write tokafka. Request {%s}", response.getId(), response);
            log.error(msg, (Throwable)e);
        }
    }

    private OperationTemplate createTemplate(ItfLiteEvent event) {
        Operation parentOperation = this.getOperation(event.getOperationId(), "create Template under it");
        String requestTransport = event instanceof ItfLiteEventRestSoap ? ((ItfLiteEventRestSoap)event).getRequest().getTransportType() : (event instanceof ItfLiteEventDiameter ? ((ItfLiteEventDiameter)event).getRequest().getTransportType() : "");
        String parentTransportType = parentOperation.getTransport().getTypeName();
        if ("REST".equals(requestTransport) && !REST_OUTBOUND_TRANSPORT.equals(parentTransportType) || "SOAP".equals(requestTransport) && !SOAP_OUTBOUND_TRANSPORT.equals(parentTransportType) || "Diameter".equals(requestTransport) && !DIAMETER_OUTBOUND_TRANSPORT.equals(parentTransportType)) {
            throw new NotValidValueException(String.format("Request and Operation Transport Types mismatch: '%s' vs '%s'", requestTransport, parentTransportType));
        }
        OperationTemplate template = (OperationTemplate)CoreObjectManager.getInstance().getManager(OperationTemplate.class).create((Storable)parentOperation);
        template.setName("New " + template.getClass().getSimpleName());
        template.setDescription("Exported from Itf-Lite, request " + event.getId() + " at " + ZonedDateTime.now());
        return template;
    }

    private Situation createSituation(ItfLiteEvent event, OperationTemplate template) {
        if (Objects.isNull(event.getReceiver())) {
            return null;
        }
        Operation operation = this.getOperation(event.getOperationId(), "create Situation under it");
        System receiver = this.getSystem(event.getReceiver(), "create Situation with it as 'Receiver'");
        System system = this.getSystem(event.getSystemId(), "create Situation with it as 'Sender'");
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).create((Storable)operation);
        situation.setName("New Situation");
        situation.setDescription("Exported from Itf-Lite, request " + event.getId() + " at " + ZonedDateTime.now());
        IntegrationStep step = new IntegrationStep((Storable)situation);
        step.setOperation(operation);
        step.setReceiver(receiver);
        step.setSender(system);
        step.setTemplate((Template)template);
        step.setName(step.getSender().getName() + " sends " + step.getOperation().getName() + " to " + step.getReceiver().getName() + " with template " + step.returnStepTemplate().getName());
        situation.store();
        log.info("Situation {} is created", (Object)situation);
        return situation;
    }

    private Operation getOperation(BigInteger objectId, String message) {
        Operation operation = (Operation)CoreObjectManager.getInstance().getManager(Operation.class).getById((Object)objectId);
        if (Objects.isNull(operation)) {
            throw new ObjectNotFoundException("Operation", objectId.toString(), null, message);
        }
        return operation;
    }

    private System getSystem(BigInteger objectId, String message) {
        System system = (System)CoreObjectManager.getInstance().getManager(System.class).getById((Object)objectId);
        if (Objects.isNull(system)) {
            throw new ObjectNotFoundException("System", objectId.toString(), null, message);
        }
        return system;
    }

    private String fillHeaders(Map<String, String> headers) {
        StringBuilder result = new StringBuilder();
        if (Objects.nonNull(headers) && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                result.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
        }
        return result.toString().endsWith("\n") ? result.substring(0, result.toString().length() - 1) : result.toString();
    }

    private String fillEndpoint(String url, Map<String, String> queryParameters) {
        StringBuilder result = new StringBuilder();
        result.append(url.substring(url.indexOf("/", 8)));
        if (Objects.nonNull(queryParameters) && !queryParameters.isEmpty()) {
            result.append("?");
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                result.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        return result.toString().endsWith("&") ? result.substring(0, result.toString().length() - 1) : result.toString();
    }

    private Collection<OutboundTemplateTransportConfiguration> createTransportConfig(OperationTemplate template, RestSoapRequestData request) {
        OutboundTemplateTransportConfiguration outboundTemplateTransportConfiguration;
        switch (RequestTransportType.valueOf(request.getTransportType().toUpperCase())) {
            case REST: {
                outboundTemplateTransportConfiguration = new OutboundTemplateTransportConfiguration(REST_OUTBOUND_TRANSPORT, (Template)template);
                break;
            }
            case SOAP: {
                outboundTemplateTransportConfiguration = new OutboundTemplateTransportConfiguration(SOAP_OUTBOUND_TRANSPORT, (Template)template);
                break;
            }
            default: {
                throw new NotValidValueException("Unknown transport type: " + request.getTransportType());
            }
        }
        HashMap configuration = Maps.newHashMap();
        configuration.put("method", request.getHttpMethod());
        configuration.put("endpoint", this.fillEndpoint(request.getUrl(), request.getQueryParameters()));
        configuration.put("headers", this.fillHeaders(request.getRequestHeaders()));
        outboundTemplateTransportConfiguration.fillConfiguration((Map)configuration);
        ArrayList templateProperties = Lists.newArrayList();
        templateProperties.add(outboundTemplateTransportConfiguration);
        return templateProperties;
    }

    private String getItfRequestUrl(ItfLiteEvent itfLiteEvent, Object templateId) {
        String itfUrl = itfLiteEvent.getItfUrl();
        StringBuilder result = new StringBuilder();
        if (itfUrl.contains("api/atp-itf-executor/v1")) {
            String url = this.environment.getProperty("atp.catalogue.url", "atp.catalogue.url");
            result.append(url.endsWith("/") ? url : url + "/");
            result.append("project/").append(itfLiteEvent.getProjectId().toString());
            result.append("/itf#/template/").append(templateId);
        } else if (itfUrl.contains("atp-itf-executor")) {
            String url = this.environment.getProperty("configurator.url", "configurator.url");
            result.append(url.endsWith("/") ? url : url + "/");
            BigInteger projectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(itfLiteEvent.getProjectId());
            result.append("project/").append(projectId);
            result.append("#/template/").append(templateId);
        }
        return result.toString();
    }
}

