/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.atp2.kafka.service.impl;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.descriptor.ProjectSettingsDescriptor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.integration.atp2.kafka.dto.ProjectEvent;
import org.qubership.automation.itf.integration.atp2.kafka.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectService")
public class ProjectServiceImpl
implements ProjectService {
    private static final Logger log = LoggerFactory.getLogger(ProjectServiceImpl.class);
    private final ProjectSettingsDescriptor projectSettingsDescriptor;
    private final ProjectSettingsService projectSettingsService;
    private final CoreObjectManagerService coreObjectManagerService;
    @Value(value="${atp.multi-tenancy.enabled}")
    private boolean multiTenancyEnabled;

    @Override
    @Transactional
    public void create(String event, ProjectEvent projectEvent) {
        log.info("'Create Project' Event is received: {}", (Object)event);
        UUID projectUuid = projectEvent.getProjectId();
        BigInteger projectId = ((SearchManager)this.coreObjectManagerService.getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
        if (projectId != null) {
            log.error("Such project already exists: {}, {}", (Object)projectUuid, (Object)projectId);
        } else {
            this.createProject(projectEvent);
        }
    }

    @Override
    public void update(String event, ProjectEvent projectEvent) {
        log.info("'Update Project' Event is received: {}", (Object)event);
        if (this.multiTenancyEnabled) {
            TenantContext.setTenantInfo((String)projectEvent.getProjectId().toString());
            this.update(projectEvent);
            TenantContext.setDefaultTenantInfo();
        } else {
            this.update(projectEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void update(ProjectEvent projectEvent) {
        UUID projectUuid = projectEvent.getProjectId();
        BigInteger projectId = ((SearchManager)this.coreObjectManagerService.getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
        UUID uUID = projectUuid;
        synchronized (uUID) {
            if (projectId == null) {
                log.info("Create non-existent project {}, {}", (Object)projectUuid, (Object)projectEvent.getProjectName());
                this.createProject(projectEvent);
            } else {
                log.info("Event Project ID {} is ours; project name and settings are to be updated", (Object)projectUuid);
                StubProject project = (StubProject)this.coreObjectManagerService.getManager(StubProject.class).getById((Object)projectId);
                boolean projectNameChanged = this.changeProjectName(project, projectEvent.getProjectName());
                Map projectSettings = this.projectSettingsService.getAll((Object)projectId);
                boolean dataSetFormatChanged = this.changeDataSetFormat(projectSettings, projectEvent);
                if (projectNameChanged || dataSetFormatChanged) {
                    if (dataSetFormatChanged) {
                        project.setStorableProp(projectSettings);
                        this.projectSettingsService.update((Object)projectId, "dataset.service.datasetFormat", (String)projectSettings.get("dataset.service.datasetFormat"), false);
                    }
                    project.store();
                }
            }
        }
    }

    @Override
    public void delete(String event, ProjectEvent projectEvent) {
        log.info("'Delete Project' Event is received: {}; ignored.", (Object)event);
    }

    private void createProject(ProjectEvent projectEvent) {
        Map projectSettings = this.projectSettingsDescriptor.asMapWithDefaultValues();
        this.changeDataSetFormat(projectSettings, projectEvent);
        StubProject project = (StubProject)this.coreObjectManagerService.getManager(StubProject.class).create(null, StubProject.class.getName(), projectSettings);
        project.setName(projectEvent.getProjectName());
        project.setUuid(projectEvent.getProjectId());
        project.store();
        this.projectSettingsService.fillCache(project, projectSettings);
    }

    private boolean changeDataSetFormat(Map<String, String> projectSettings, ProjectEvent projectEvent) {
        String newDatasetFormat = projectEvent.getDatasetFormat().toString();
        if (newDatasetFormat.equals(projectSettings.getOrDefault("dataset.service.datasetFormat", "Itf"))) {
            log.info("Old and New DatasetFormat settings are the same: {}", (Object)newDatasetFormat);
            return false;
        }
        projectSettings.put("dataset.service.datasetFormat", newDatasetFormat);
        log.info("DatasetFormat setting is changed to {}", (Object)newDatasetFormat);
        return true;
    }

    private boolean changeProjectName(StubProject project, String newName) {
        if (StringUtils.isBlank((CharSequence)newName) || newName.equals(project.getName())) {
            log.info("The new project name is blank or the same with old: {}, the name is unchanged", (Object)newName);
            return false;
        }
        project.setName(newName.trim());
        log.info("Project name is changed to {}", (Object)newName);
        return true;
    }

    @ConstructorProperties(value={"projectSettingsDescriptor", "projectSettingsService", "coreObjectManagerService"})
    public ProjectServiceImpl(ProjectSettingsDescriptor projectSettingsDescriptor, ProjectSettingsService projectSettingsService, CoreObjectManagerService coreObjectManagerService) {
        this.projectSettingsDescriptor = projectSettingsDescriptor;
        this.projectSettingsService = projectSettingsService;
        this.coreObjectManagerService = coreObjectManagerService;
    }
}

