/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.bv.utils;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.extension.Extension;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.exception.EngineIntegrationException;
import org.qubership.automation.itf.core.util.logger.ItfLogger;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.integration.bv.engine.BvEngineIntegration;
import org.qubership.automation.itf.integration.bv.engine.BvInstance;
import org.qubership.automation.itf.integration.bv.engine.BvInstanceExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BvHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(BvHelper.class);
    private static final Logger ITF_LOGGER = ItfLogger.getLogger(BvEngineIntegration.class);

    public static URL normalizeUrl(String url, String endpoint) {
        URI uri = URI.create(url.trim());
        try {
            uri = uri.getPath().endsWith("/") ? uri.resolve(uri.getPath()) : uri.resolve(uri.getPath() + "/");
            return uri.resolve(endpoint.trim()).toURL();
        }
        catch (NullPointerException | MalformedURLException e) {
            throw new EngineIntegrationException("Error building URL for Bulk Validator request: URL = " + (StringUtils.isBlank((CharSequence)url) ? "null or empty" : url) + ", Endpoint = " + (StringUtils.isBlank((CharSequence)endpoint) ? "null or empty" : endpoint) + "!", (Throwable)e);
        }
    }

    public static void endWithFailed(String errorMessage, BvInstance bvInstance) {
        EngineIntegrationException exception = new EngineIntegrationException(errorMessage);
        bvInstance.setStatus(Status.FAILED);
        bvInstance.setError((Throwable)exception);
        bvInstance.setEndTime(new Date());
        SpContext spContext = null;
        Report.error((AbstractInstance)bvInstance, (String)"Validation Phase failed", spContext, (Throwable)exception);
        ITF_LOGGER.debug(errorMessage, (Throwable)exception);
        throw exception;
    }

    public static void completeSuccessfully(CallChainInstance chainInstance, BvInstance bvInstance, String reportLink, String message, String status) {
        LOGGER.info(message);
        String deleteKey = "Bulk Validator Link : Not validated";
        Map rl = chainInstance.getContext().tc().getReportLinks();
        rl.remove(deleteKey);
        rl.put("Bulk Validator Link : " + status, reportLink);
        bvInstance.setStatus(Status.PASSED);
        bvInstance.setEndTime(new Date());
    }

    public static void addOnCaseFinishValidation(CallChainInstance instance, CallChain callChain, String datasetName, boolean validateTestcase, String bvAction) {
        String bvCaseId = (String)callChain.getBvCases().get(datasetName);
        if (!Strings.isNullOrEmpty((String)bvCaseId)) {
            BvInstanceExtension extension = (BvInstanceExtension)instance.getExtension(BvInstanceExtension.class);
            if (extension == null) {
                extension = new BvInstanceExtension();
                instance.extend((Extension)extension);
            }
            extension.validate = validateTestcase && !Strings.isNullOrEmpty((String)bvCaseId);
            extension.bvCaseId = bvCaseId;
            extension.bvAction = bvAction;
        } else {
            LOGGER.info("Bulk validation won't be started after completing the {} callchain, because there is no BV-case for {} dataset", (Object)callChain.getName(), (Object)datasetName);
        }
    }

    public static void addMessageOnStepValidation(CallChainInstance instance) {
        BvInstanceExtension extension = (BvInstanceExtension)instance.getExtension(BvInstanceExtension.class);
        if (extension == null) {
            extension = new BvInstanceExtension();
            instance.extend((Extension)extension);
        }
        extension.validateMessages = true;
    }

    public static String buildBVConfPath(String confFromIntegrationTab, CallChainInstance callchainInstance) {
        if (confFromIntegrationTab.contains("/") || confFromIntegrationTab.isEmpty()) {
            return confFromIntegrationTab;
        }
        String fromEnv = BvHelper.getBVPathFromEnv(callchainInstance);
        HashMap owners = Maps.newHashMap();
        owners.put("___environment___", callchainInstance.getContext().getTC().getEnvironmentById());
        return TemplateEngineFactory.get().process((Map)owners, fromEnv, (JsonContext)callchainInstance.getContext(), "BvHelper#buildBVConfPath");
    }

    private static String getBVPathFromEnv(CallChainInstance callchainInstance) {
        Environment env = callchainInstance.getContext().getTC().getEnvironmentById();
        Set reportCollectors = env.getReportCollectors();
        return reportCollectors != null && !reportCollectors.isEmpty() ? ((LinkCollectorConfiguration)reportCollectors.iterator().next()).get((Object)"bv.conf.path") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectUUID(BigInteger projectId) {
        String uuid;
        BigInteger bigInteger = projectId;
        synchronized (bigInteger) {
            UUID uuidFromDB = ((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)projectId)).getUuid();
            if (Objects.isNull(uuidFromDB)) {
                throw new EngineIntegrationException("BulkValidator Project UUID not found!");
            }
            uuid = uuidFromDB.toString();
        }
        return uuid;
    }
}

