/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.bv.messages.response;

import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.integration.bv.messages.response.BvResponseData;
import org.qubership.automation.itf.integration.bv.utils.BvResponseProcessor;

public class HttpBvResponse {
    private BvResponseData bvResponseData = null;
    private int httpResponseCode = -1;
    private int bvStatusCode = -1;
    private boolean success;
    private String httpResponseBody;
    private String bvStatusMessage;

    public HttpBvResponse(int httpResponseCode, boolean httpSuccess, String httpResponseBody) {
        this.httpResponseCode = httpResponseCode;
        this.httpResponseBody = httpResponseBody;
        this.success = httpSuccess;
        if (httpSuccess) {
            this.bvResponseData = BvResponseProcessor.parseResponse(httpResponseBody);
            if (this.bvResponseData != null) {
                String statusCode = this.bvResponseData.getStatusCode();
                if (!StringUtils.isBlank((CharSequence)statusCode)) {
                    this.bvStatusCode = Integer.parseInt(statusCode);
                    if (this.bvStatusCode < 10000 || this.bvStatusCode >= 20000) {
                        this.success = false;
                    }
                }
                this.bvStatusMessage = this.bvResponseData.getStatusMessage();
            }
        }
    }

    public HttpBvResponse() {
    }

    public BvResponseData getBvResponseData() {
        return this.bvResponseData;
    }

    public void setBvResponseData(BvResponseData bvResponseData) {
        this.bvResponseData = bvResponseData;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public void setHttpResponseCode(int httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getHttpResponseBody() {
        return this.httpResponseBody;
    }

    public void setHttpResponseBody(String httpResponseBody) {
        this.httpResponseBody = httpResponseBody;
    }

    public int getBvStatusCode() {
        return this.bvStatusCode;
    }

    public void setBvStatusCode(int bvStatusCode) {
        this.bvStatusCode = bvStatusCode;
    }

    public String getBvStatusMessage() {
        return this.bvStatusMessage;
    }

    public void setBvStatusMessage(String bvStatusMessage) {
        this.bvStatusMessage = bvStatusMessage;
    }
}

