/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.bv.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.adapter.common.context.AtpCompaund;
import org.qubership.atp.adapter.common.context.TestRunContext;
import org.qubership.atp.bv.dto.CopyWithNameRequestDto;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.exception.EngineIntegrationException;
import org.qubership.automation.itf.integration.bv.engine.BvInstance;
import org.qubership.automation.itf.integration.bv.messages.request.BvReadMode;
import org.qubership.automation.itf.integration.bv.messages.request.BvReadType;
import org.qubership.automation.itf.integration.bv.messages.request.BvSource;
import org.qubership.automation.itf.integration.bv.messages.request.Label;
import org.qubership.automation.itf.integration.bv.messages.request.ReportData;
import org.qubership.automation.itf.integration.bv.messages.request.RequestData;
import org.qubership.automation.itf.integration.bv.messages.request.Servers;
import org.qubership.automation.itf.integration.bv.messages.request.TestCase;
import org.qubership.automation.itf.integration.bv.messages.request.ValidationObject;
import org.qubership.automation.itf.integration.bv.messages.request.quickCompare.QuickCompareRequest;
import org.qubership.automation.itf.integration.bv.messages.request.quickCompare.ValidationParameter;
import org.qubership.automation.itf.integration.bv.messages.response.TestcaseVobjectsResponse;
import org.qubership.automation.itf.integration.bv.messages.response.Vobject;
import org.qubership.automation.itf.integration.bv.utils.BvHelper;
import org.qubership.automation.itf.report.extension.TCContextRamExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BvRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BvRequestBuilder.class);
    private static final Pattern SERVER_REGEXP = Pattern.compile("//([^/]*)/?");
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Splitter KEY_VALUE_MAP_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings().trimResults();

    public static RequestData buildReadCompareRequest(IntegrationConfig integrationConf, CallChainInstance callchainInstance, BvInstance bvInstance) {
        RequestData requestData = new RequestData();
        Map<String, String> inputParameters = BvRequestBuilder.collectInputParams(integrationConf, callchainInstance);
        if (Boolean.parseBoolean(integrationConf.get((Object)"bv.use.report.link"))) {
            Map reportLinks = callchainInstance.getContext().tc().getReportLinks();
            inputParameters.put("URLtoISL", (String)reportLinks.get(integrationConf.get((Object)"bv.report.link.name")));
        }
        String bvCaseId = BvRequestBuilder.getBVCaseId(callchainInstance);
        TestCase testCase = BvRequestBuilder.createTestCase(bvCaseId, inputParameters);
        requestData.setTestCases(new TestCase[]{testCase});
        String confFromIntegrationTab = integrationConf.get((Object)"bv.conf.path");
        String bvConfPath = BvHelper.buildBVConfPath(confFromIntegrationTab, callchainInstance);
        Servers servers = new Servers(bvConfPath, new String[]{integrationConf.get((Object)"bv.source.name").trim()});
        requestData.setServers(new Servers[]{servers});
        requestData.setReadMode(BvReadMode.AR);
        requestData.setReadType(BvReadType.READ);
        BvRequestBuilder.setAtpReportRequestSettingsIfNotNull(requestData, bvInstance);
        return requestData;
    }

    public static RequestData buildCompareRequest(String trId, BvInstance bvInstance) {
        RequestData requestData = new RequestData();
        TestCase testCase = BvRequestBuilder.createTestCaseForCompareRequest(trId);
        requestData.setTestCases(new TestCase[]{testCase});
        BvRequestBuilder.setAtpReportRequestSettingsIfNotNull(requestData, bvInstance);
        return requestData;
    }

    public static RequestData buildCreateNewTRRequest(IntegrationConfig integrationConf, CallChainInstance callChainInstance, BvInstance bvInstance) {
        RequestData requestData = new RequestData();
        String bvCaseId = BvRequestBuilder.getBVCaseId(callChainInstance);
        requestData.setTcId(bvCaseId);
        Map<String, String> inputParameters = BvRequestBuilder.collectInputParams(integrationConf, callChainInstance);
        if (!inputParameters.isEmpty()) {
            requestData.setInputParameters(inputParameters);
        }
        requestData.setValidationObjects(BvRequestBuilder.collectValidationObjects(integrationConf, callChainInstance));
        BvRequestBuilder.setAtpReportRequestSettingsIfNotNull(requestData, bvInstance);
        return requestData;
    }

    public static RequestData buildCreateRequestData(CallChain callChain, IntegrationConfig integrationConf, Map<String, String> properties) {
        BvSource source = new BvSource();
        source.setSourceName(integrationConf.get((Object)"bv.source.name").trim());
        ArrayList<Label> labels = new ArrayList<Label>();
        for (String chainLabel : callChain.getLabels()) {
            Label label = new Label();
            label.setName(chainLabel);
            labels.add(label);
        }
        return BvRequestBuilder.fillRequestData(callChain.getName() + " " + properties.get("dataset.name"), integrationConf.get((Object)"bv.testcase.type"), new BvSource[]{source}, labels);
    }

    public static RequestData buildCreateRequestData(Situation situation, IntegrationConfig integrationConf) {
        BvSource source = new BvSource();
        source.setSourceName(integrationConf.get((Object)"bv.source.name").trim());
        ArrayList<Label> labels = new ArrayList<Label>();
        return BvRequestBuilder.fillRequestData(situation.getParent().getName() + " / " + situation.getName(), integrationConf.get((Object)"bv.testcase.type"), new BvSource[]{source}, labels);
    }

    public static CopyWithNameRequestDto buildCopyRequestData(String newName, String sourceTcId) {
        CopyWithNameRequestDto copyWithNameRequest = new CopyWithNameRequestDto();
        copyWithNameRequest.setNewName(newName);
        copyWithNameRequest.setSourceTcId(sourceTcId);
        return copyWithNameRequest;
    }

    private static RequestData fillRequestData(String name, String type, BvSource[] sources, List<Label> labels) {
        RequestData requestData = new RequestData();
        requestData.setName(name);
        requestData.setType(type);
        requestData.setSources(sources);
        requestData.setLabels(labels);
        return requestData;
    }

    public static RequestData buildSimpleRequestData(Storable storable, Map<String, String> properties) {
        if (storable instanceof CallChain) {
            return new RequestData((String)((CallChain)storable).getBvCases().get(properties.get("dataset.name")));
        }
        return new RequestData(((Situation)storable).getBvTestcase());
    }

    public static RequestData buildReadRequestData(CallChain callChain, IntegrationConfig integrationConf, Map<String, String> properties) {
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        inputParameters.put("URLtoISL", properties.get("islLink"));
        String bvCaseId = (String)callChain.getBvCases().get(properties.get("dataset.name"));
        TestCase testCase = BvRequestBuilder.createTestCase(bvCaseId, inputParameters);
        Servers server = new Servers(BvRequestBuilder.getServerName(properties.get("islLink")), new String[]{integrationConf.get((Object)"bv.source.name").trim()});
        RequestData requestData = new RequestData();
        requestData.setReadMode(BvReadMode.ER);
        requestData.setReadType(BvReadType.CLEAR_AND_REWRITE);
        requestData.setTestCases(new TestCase[]{testCase});
        requestData.setServers(new Servers[]{server});
        return requestData;
    }

    public static QuickCompareRequest buildQuickCompareRequest(String situationName, Message message, String bvCaseId) {
        QuickCompareRequest requestData = new QuickCompareRequest();
        requestData.setTcId(bvCaseId);
        ArrayList<ValidationParameter> children = new ArrayList<ValidationParameter>();
        ValidationParameter childObject = new ValidationParameter();
        childObject.setName("incoming");
        childObject.setAr(message.getText());
        children.add(childObject);
        ValidationParameter parentObject = new ValidationParameter();
        parentObject.setName(situationName);
        parentObject.setChildren(children);
        ArrayList<ValidationParameter> validationObjects = new ArrayList<ValidationParameter>();
        validationObjects.add(parentObject);
        requestData.setValidationObjects(validationObjects);
        return requestData;
    }

    public static QuickCompareRequest buildQuickCompareRequest(SituationInstance instance, Situation situation, SpContext sp, TestcaseVobjectsResponse testcaseVobjectsResponse, String bvCaseId) {
        if (testcaseVobjectsResponse.getVObjects() == null || testcaseVobjectsResponse.getVObjects().isEmpty()) {
            throw new EngineIntegrationException("There is no validation parameters in BV testcase, id=" + bvCaseId);
        }
        QuickCompareRequest requestData = new QuickCompareRequest();
        requestData.setTcId(bvCaseId);
        requestData.setLoadHighlight(true);
        TcContext tc = instance.getContext().getTC();
        JsonContext saved = new JsonContext();
        try {
            Object savedObj = tc.get((Object)"saved");
            if (savedObj instanceof Map) {
                saved.putAll((Map)savedObj);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred during unpacking tc.saved: [" + tc.get((Object)"saved").toString() + "]: ", (Throwable)e);
        }
        ArrayList<ValidationParameter> validationObjects = new ArrayList<ValidationParameter>();
        for (Vobject obj : testcaseVobjectsResponse.getVObjects()) {
            ValidationParameter parentObject = new ValidationParameter();
            parentObject.setName(obj.getName());
            if (obj.getChilds().isEmpty()) {
                parentObject.setAr(BvRequestBuilder.getValueFromContext(saved, sp, obj.getName()));
                parentObject.setValue(TemplateEngineFactory.get().process((Storable)situation, obj.getDecodedValue(), (JsonContext)instance.getContext(), "ER value of '" + obj.getName() + "'"));
            } else {
                ArrayList<ValidationParameter> children = new ArrayList<ValidationParameter>();
                for (Vobject child : obj.getChilds()) {
                    ValidationParameter childObject = new ValidationParameter();
                    childObject.setName(child.getName());
                    childObject.setAr(BvRequestBuilder.getValueFromContext(saved, sp, child.getName()));
                    childObject.setValue(TemplateEngineFactory.get().process((Storable)situation, child.getDecodedValue(), (JsonContext)instance.getContext(), "ER value of '" + child.getName() + "'"));
                    children.add(childObject);
                }
                parentObject.setChildren(children);
            }
            validationObjects.add(parentObject);
        }
        requestData.setValidationObjects(validationObjects);
        return requestData;
    }

    private static String getValueFromContext(JsonContext savedMap, SpContext sp, String varName) {
        if (varName.equals("incoming")) {
            return BvRequestBuilder.getMessageBody(sp.getIncomingMessage());
        }
        if (varName.equals("outgoing")) {
            return BvRequestBuilder.getMessageBody(sp.getOutgoingMessage());
        }
        if (sp.containsKey((Object)varName)) {
            return BvRequestBuilder.value2String(sp.get((Object)varName));
        }
        if (savedMap != null && savedMap.containsKey((Object)varName)) {
            return BvRequestBuilder.value2String(savedMap.get((Object)varName));
        }
        return "";
    }

    private static String value2String(Object obj) {
        try {
            if (obj == null || obj.toString().isEmpty()) {
                return "";
            }
            if (obj instanceof ArrayList) {
                ArrayList objList = (ArrayList)obj;
                if (!objList.isEmpty()) {
                    try {
                        ArrayList<Object> newobjs = new ArrayList<Object>();
                        for (Object o : objList) {
                            if (o instanceof String) {
                                newobjs.add(mapper.readTree(o.toString()));
                                continue;
                            }
                            newobjs.add(o);
                        }
                        return mapper.writeValueAsString(newobjs);
                    }
                    catch (Exception ex1) {
                        return mapper.writeValueAsString(obj);
                    }
                }
                return "[]";
            }
            if (obj instanceof Map) {
                return mapper.writeValueAsString(obj);
            }
            if (obj instanceof String) {
                String sobj = obj.toString();
                if (sobj.startsWith("{") || sobj.startsWith("[")) {
                    JsonNode jn = mapper.readTree(sobj);
                    return mapper.writeValueAsString((Object)jn);
                }
                return sobj;
            }
            return obj.toString();
        }
        catch (Exception ex) {
            return obj.toString();
        }
    }

    private static String getMessageBody(Message message) {
        return message == null ? "" : message.getText();
    }

    private static ReportData getAtpReportRequestSettings(BvInstance bvInstance) {
        ReportData report = new ReportData();
        TCContextRamExtension ramExtension = (TCContextRamExtension)bvInstance.getContext().tc().getExtension(TCContextRamExtension.class);
        if (ramExtension != null) {
            String reportUrl;
            BigInteger runId = ramExtension.getRunId();
            TestRunContext ram2Context = ramExtension.getRunContext();
            if (runId == null && ram2Context == null) {
                return null;
            }
            report.setBuilder("ATP_RAM_REPORT");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("atpAdapterMode", "ntt");
            if (runId != null) {
                parameters.put("atpTestRunId", runId.toString());
                BigInteger sectionId = ramExtension.getSectionId();
                if (sectionId != null) {
                    parameters.put("atpSectionId", sectionId.toString());
                    LOGGER.debug("BV_REQUEST: ATP_SECTION_ID: {}", (Object)sectionId);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)(reportUrl = ramExtension.getReportUrl()))) {
                String[] tokens = reportUrl.split("/");
                parameters.put("atpRamUrl", tokens[0] + "//" + tokens[2]);
            }
            LOGGER.debug("BV_REQUEST: Ram2Context:{}", (Object)(ram2Context != null ? 1 : 0));
            if (ram2Context != null) {
                parameters.put("ram2TestRunId", ram2Context.getTestRunId());
                LOGGER.debug("BV_REQUEST: ram2TestRunId:{}", (Object)ram2Context.getTestRunId());
                String ram2SectionId = ram2Context.getCurrentSectionId();
                String ram2SectionName = "ITF Integration";
                AtpCompaund compaund = ram2Context.getAtpCompaund();
                if (compaund != null) {
                    ram2SectionId = compaund.getSectionId();
                    ram2SectionName = compaund.getSectionName();
                }
                parameters.put("ram2SectionId", ram2SectionId);
                parameters.put("ram2SectionName", ram2SectionName);
                parameters.put("atpRamLoggerUrl", System.getProperty("atp.logger.url"));
                if (StartedFrom.RAM2.equals((Object)ramExtension.getStartedFrom())) {
                    parameters.put("atpReportTo", "ATP RAM 2");
                }
                LOGGER.debug("BV_REQUEST: {}, {}", (Object)ram2SectionId, (Object)ram2SectionName);
            }
            parameters.put("atpAdapterMode", "ntt");
            parameters.put("atpCustomer", "DT");
            parameters.put("atpProject", "Demo");
            report.setParameters(parameters);
            return report;
        }
        return null;
    }

    private static void setAtpReportRequestSettingsIfNotNull(RequestData requestData, BvInstance bvInstance) {
        ReportData reportData = BvRequestBuilder.getAtpReportRequestSettings(bvInstance);
        if (reportData != null) {
            requestData.setReport(reportData);
        }
    }

    private static TestCase createTestCase(String bvCaseId, Map<String, String> inputParameters) {
        TestCase testCase = new TestCase();
        testCase.setTcId(bvCaseId);
        if (!inputParameters.isEmpty()) {
            testCase.setInputParameters(inputParameters);
        }
        return testCase;
    }

    private static TestCase createTestCaseForCompareRequest(String trId) {
        TestCase testCases = new TestCase();
        testCases.setTrId(trId);
        return testCases;
    }

    private static Map<String, String> collectInputParams(IntegrationConfig integrationConf, CallChainInstance callChainInstance) {
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        String inputContextKeys = integrationConf.get((Object)"bv.input.params.names");
        if (!Strings.isNullOrEmpty((String)inputContextKeys)) {
            Iterable keys = KEY_VALUE_MAP_SPLITTER.split((CharSequence)inputContextKeys);
            for (String key : keys) {
                String[] pair = key.split("=", 2);
                if (pair.length < 2) {
                    LOGGER.warn("BV Testcase Input parameters - incorrect entry format of '{}'", (Object)key);
                    continue;
                }
                String bvKeyValue = TemplateEngineFactory.get().process((Storable)callChainInstance.getStepContainer(), pair[1], (JsonContext)callChainInstance.getContext(), "BV Testcase Input parameter '" + pair[0] + "'");
                inputParameters.put(pair[0], bvKeyValue);
            }
        }
        return inputParameters;
    }

    private static List<ValidationObject> collectValidationObjects(IntegrationConfig integrationConf, CallChainInstance callChainInstance) {
        String validateContextKeys = integrationConf.get((Object)"bv.valid.params.names");
        if (Strings.isNullOrEmpty((String)validateContextKeys)) {
            throw new EngineIntegrationException("Validation parameters for BulkValidator are not specified");
        }
        Iterable validateKeys = KEY_VALUE_MAP_SPLITTER.split((CharSequence)validateContextKeys);
        ArrayList<ValidationObject> validationObjects = new ArrayList<ValidationObject>();
        for (String key : validateKeys) {
            String[] pair = key.split("=", 2);
            if (pair.length < 2) {
                LOGGER.warn("BV Testcase Validation parameters - incorrect entry format of '{}'", (Object)key);
                continue;
            }
            String bvKeyVal = TemplateEngineFactory.get().process((Storable)callChainInstance.getStepContainer(), pair[1], (JsonContext)callChainInstance.getContext(), "BV Testcase Validation parameter '" + pair[0] + "'");
            validationObjects.add(new ValidationObject(pair[0], bvKeyVal, "XML"));
        }
        return validationObjects;
    }

    public static String getBVCaseId(CallChainInstance callChainInstance) {
        CallChain callchain = (CallChain)callChainInstance.getSource();
        return (String)callchain.getBvCases().get(callChainInstance.getDatasetName());
    }

    private static String getServerName(String serverUrl) {
        try {
            Matcher m = SERVER_REGEXP.matcher(serverUrl);
            m.find();
            return m.group(1);
        }
        catch (Exception e) {
            throw new EngineIntegrationException("Error while building server name, URL is not correct: " + (StringUtils.isBlank((CharSequence)serverUrl) ? "null or empty" : serverUrl) + "!", (Throwable)e);
        }
    }
}

