/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.bv.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.exception.EngineIntegrationException;
import org.qubership.automation.itf.core.util.logger.ItfLogger;
import org.qubership.automation.itf.integration.bv.engine.BvEngineIntegration;
import org.qubership.automation.itf.integration.bv.engine.BvInstance;
import org.qubership.automation.itf.integration.bv.messages.response.BvResponseData;
import org.qubership.automation.itf.integration.bv.messages.response.TestcaseVobjectsResponse;
import org.qubership.automation.itf.integration.bv.messages.response.quickCompare.QuickCompareResponse;
import org.qubership.automation.itf.integration.bv.utils.BvHelper;
import org.slf4j.Logger;

public class BvResponseProcessor {
    private static final Logger ITF_LOGGER = ItfLogger.getLogger(BvEngineIntegration.class);
    private static final ObjectMapper objectMapper;

    public static String processResponse(String response, String bvAction, CallChainInstance callChainInstance, BvInstance bvInstance, IntegrationConfig integrationConfig) {
        BvResponseData responseData = BvResponseProcessor.parseResponse(response);
        BigInteger projectId = callChainInstance.getContext().tc().getProjectId();
        switch (bvAction) {
            case "ReadCompare": {
                return BvResponseProcessor.processResponseReadCompare(responseData, callChainInstance, bvInstance, integrationConfig, projectId);
            }
            case "CreateNewTestRun": {
                return BvResponseProcessor.processResponseCreateTr(responseData, callChainInstance, bvInstance, integrationConfig, projectId);
            }
            case "Compare": {
                return BvResponseProcessor.processResponseCompare(responseData, callChainInstance, bvInstance, integrationConfig, projectId);
            }
        }
        return null;
    }

    private static String processResponseReadCompare(BvResponseData responseData, CallChainInstance chainInstance, BvInstance bvInstance, IntegrationConfig integrationConf, BigInteger projectId) {
        if (responseData.getStatusCode() != null) {
            String statusCode = responseData.getStatusCode();
            if (statusCode.equals("10000")) {
                String successMessage = "Response from Bulk Validator to read and compare for test case " + responseData.getTcName() + " : Actual results were successfully read!";
                String uuid = chainInstance.getContext().tc().getProjectUuid().toString();
                String reportLink = BvHelper.normalizeUrl(ApplicationConfig.env.getProperty("atp.catalogue.url", ""), String.format("/project/%s/bvtool/bvt/validation?trid=", uuid)) + responseData.getTrId();
                BvHelper.completeSuccessfully(chainInstance, bvInstance, reportLink, successMessage, responseData.getCompareResult());
                BvResponseProcessor.changeTcContextStatus(chainInstance.getContext().tc(), responseData.getCompareResult());
                return responseData.getTrId();
            }
            String errorMessage = "Response returned an error from the Bulk Validator while read and compare! Status Message " + responseData.getStatusMessage();
            chainInstance.getContext().tc().setStatus(Status.FAILED);
            BvHelper.endWithFailed(errorMessage, bvInstance);
        }
        return null;
    }

    private static String processResponseCompare(BvResponseData responseData, CallChainInstance chainInstance, BvInstance bvInstance, IntegrationConfig integrationConf, BigInteger projectId) {
        if (responseData.getStatusCode() != null) {
            String statusCode = responseData.getStatusCode();
            if (statusCode.equals("10000")) {
                String successMessage = "Response from Bulk Validator to compare for TestRun " + responseData.getTrId() + " : TestRun was successfully validated!";
                String uuid = chainInstance.getContext().tc().getProjectUuid().toString();
                String reportLink = BvHelper.normalizeUrl(ApplicationConfig.env.getProperty("atp.catalogue.url", ""), String.format("/project/%s/bvtool/bvt/validation?trid=", uuid)) + responseData.getTrId();
                BvHelper.completeSuccessfully(chainInstance, bvInstance, reportLink, successMessage, responseData.getCompareResult());
                BvResponseProcessor.changeTcContextStatus(chainInstance.getContext().tc(), responseData.getCompareResult());
                return responseData.getTrId();
            }
            String errorMessage = "Response returned an error from the Bulk Validator while compare! Status Message " + responseData.getStatusMessage();
            chainInstance.getContext().tc().setStatus(Status.FAILED);
            BvHelper.endWithFailed(errorMessage, bvInstance);
        }
        return null;
    }

    private static String processResponseCreateTr(BvResponseData responseData, CallChainInstance chainInstance, BvInstance bvInstance, IntegrationConfig integrationConf, BigInteger projectId) {
        if (responseData.getTrId() != null) {
            String successMessage = "Response from Bulk Validator. Create new testrun for test case " + responseData.getTcId() + " : successfully!";
            String uuid = chainInstance.getContext().tc().getProjectUuid().toString();
            String reportLink = BvHelper.normalizeUrl(ApplicationConfig.env.getProperty("atp.catalogue.url", ""), String.format("/project/%s/bvtool/bvt/validation?trid=", uuid)) + responseData.getTrId();
            BvHelper.completeSuccessfully(chainInstance, bvInstance, reportLink, successMessage, "Not validated");
            return responseData.getTrId();
        }
        String errorMessage = "Response from Bulk Validator returned an error! New testrun not created. Status Message " + responseData.getStatusMessage();
        chainInstance.getContext().tc().setStatus(Status.FAILED);
        BvHelper.endWithFailed(errorMessage, bvInstance);
        return null;
    }

    private static void changeTcContextStatus(TcContext tcContext, String compareResult) {
        Status calculatedValidationStatus = BvResponseProcessor.compareResult2contextStatus(compareResult);
        Status mergedStatus = BvResponseProcessor.mergeStatuses(tcContext.getStatus(), calculatedValidationStatus);
        if (!mergedStatus.equals((Object)tcContext.getStatus())) {
            tcContext.setStatus(mergedStatus);
        }
    }

    private static Status compareResult2contextStatus(String compareResult) {
        if (compareResult == null) {
            return Status.PASSED;
        }
        switch (compareResult) {
            case "PASSED": 
            case "SUCCESS": 
            case "IDENTICAL": 
            case "IGNORED": 
            case "SKIPPED": {
                return Status.PASSED;
            }
            case "SIMILAR": {
                return Status.WARNING;
            }
        }
        return Status.FAILED;
    }

    private static Status mergeStatuses(Status currentStatus, Status newStatus) {
        if (currentStatus.equals((Object)Status.FAILED) || currentStatus.equals((Object)Status.FAILED_BY_TIMEOUT)) {
            return currentStatus;
        }
        return newStatus;
    }

    public static BvResponseData parseResponse(String inputResponse) {
        String response = BvResponseProcessor.checkResponse(inputResponse);
        try {
            return (BvResponseData)objectMapper.readValue(response, BvResponseData.class);
        }
        catch (IOException e) {
            ITF_LOGGER.debug("Parsing of response from Bulk Validator is completed with error:", (Throwable)e);
            throw new EngineIntegrationException((Throwable)e);
        }
    }

    private static String checkResponse(String inputResponse) {
        if (inputResponse.startsWith("[")) {
            return inputResponse.substring(1, inputResponse.length() - 1);
        }
        return inputResponse;
    }

    public static QuickCompareResponse processQuickCompareResponse(String responseData) {
        QuickCompareResponse quickCompareResponse;
        try {
            quickCompareResponse = (QuickCompareResponse)objectMapper.readValue(responseData, QuickCompareResponse.class);
        }
        catch (IOException e) {
            ITF_LOGGER.debug("Parsing of response from Bulk Validator is completed with error:", (Throwable)e);
            throw new EngineIntegrationException((Throwable)e);
        }
        return quickCompareResponse;
    }

    public static TestcaseVobjectsResponse parseTestcaseVobjectsResponse(String inputResponse) {
        try {
            return (TestcaseVobjectsResponse)BvEngineIntegration.GSON_INSTANCE.fromJson(inputResponse, TestcaseVobjectsResponse.class);
        }
        catch (Exception e) {
            ITF_LOGGER.debug("Parsing of response from Bulk Validator is completed with error:", (Throwable)e);
            throw new EngineIntegrationException((Throwable)e);
        }
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper = mapper;
    }
}

