/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.bv.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.atp.bv.dto.CopyWithNameRequestDto;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.engine.EngineAfterIntegration;
import org.qubership.automation.itf.core.util.engine.EngineControlIntegration;
import org.qubership.automation.itf.core.util.engine.EngineOnStepIntegration;
import org.qubership.automation.itf.core.util.exception.EngineIntegrationException;
import org.qubership.automation.itf.core.util.feign.http.HttpClientFactory;
import org.qubership.automation.itf.core.util.logger.ItfLogger;
import org.qubership.automation.itf.integration.bv.engine.BvInstance;
import org.qubership.automation.itf.integration.bv.engine.BvInstanceExtension;
import org.qubership.automation.itf.integration.bv.messages.request.RequestData;
import org.qubership.automation.itf.integration.bv.messages.request.quickCompare.QuickCompareRequest;
import org.qubership.automation.itf.integration.bv.messages.response.BvResponseData;
import org.qubership.automation.itf.integration.bv.messages.response.HttpBvResponse;
import org.qubership.automation.itf.integration.bv.messages.response.quickCompare.QuickCompareResponse;
import org.qubership.automation.itf.integration.bv.messages.response.quickCompare.Step;
import org.qubership.automation.itf.integration.bv.utils.BvHelper;
import org.qubership.automation.itf.integration.bv.utils.BvRequestBuilder;
import org.qubership.automation.itf.integration.bv.utils.BvResponseProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@UserName(value="Bulk Validator Integration")
public class BvEngineIntegration
implements EngineAfterIntegration,
EngineControlIntegration,
EngineOnStepIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(BvEngineIntegration.class);
    private static final Logger ITF_LOGGER = ItfLogger.getLogger(BvEngineIntegration.class);
    public static Gson GSON_INSTANCE = new GsonBuilder().disableHtmlEscaping().create();
    @Parameter(shortName="bv.testcase.type", longName="Test Case Type", description="BulkValidator TestCase Type")
    private String testCaseType;
    @Parameter(shortName="bv.source.name", longName="Source Name", description="BulkValidator Source Name")
    private String sourceName;
    @Parameter(shortName="bv.use.report.link", longName="Use report link as validation parameter (URLtoISL)", description="")
    private Boolean useReportLink;
    @Parameter(shortName="bv.report.link.name", longName="Report link name (URLtoISL)", description="Integration Sessions Log (as given in Environment)")
    private String reportLink;
    @Parameter(shortName="bv.input.params.names", longName="Context keys to use as input parameters (Template)", description="bvName1=$tc.Keys.CRM\nbvName2=$tc.Keys.processId")
    private List<String> inputKey;
    @Parameter(shortName="bv.valid.params.names", longName="Context keys to use as validation parameters (Template)", description="bvName1=$tc.Keys.CRM\nbvName2=$tc.Keys.processId")
    private List<String> validKey;
    @Parameter(shortName="bv.conf.path", longName="Bulk Validator configuration path / Environment Extra Settings name", description="bv_env_name/bv_system_name/bv_connection_name or Extra_Settings_Name")
    private String groupName;

    public void executeAfter(CallChainInstance chainInstance, IntegrationConfig integrationConf) throws EngineIntegrationException {
        String response;
        ResponseEntity responseEntity;
        BvInstanceExtension extension = (BvInstanceExtension)chainInstance.getExtension(BvInstanceExtension.class);
        if (extension == null) {
            LOGGER.warn("BVInstanceExtension is not available for call chain '{}'", (Object)chainInstance);
            return;
        }
        if (!extension.validate) {
            LOGGER.warn("BVInstanceExtension: testcase validation is turned OFF for call chain '{}'", (Object)chainInstance);
            return;
        }
        String action = extension.bvAction;
        if (!"ReadCompare".equals(action) && !"CreateNewTestRun".equals(action)) {
            throw new EngineIntegrationException("BulkValidator actions in project settings are not correct or empty");
        }
        BvInstance bvInstance = new BvInstance((CallChain)chainInstance.getStepContainer());
        bvInstance.getContext().setTC(chainInstance.getContext().tc());
        RequestData requestData = null;
        String endpoint = null;
        UUID projectUuid = chainInstance.getContext().tc().getProjectUuid();
        switch (action) {
            case "ReadCompare": {
                requestData = BvRequestBuilder.buildReadCompareRequest(integrationConf, chainInstance, bvInstance);
                endpoint = String.format("/api/bvtool/project/%s/api/v1/readAndCompare", projectUuid);
                break;
            }
            case "CreateNewTestRun": {
                requestData = BvRequestBuilder.buildCreateNewTRRequest(integrationConf, chainInstance, bvInstance);
                endpoint = String.format("/api/bvtool/project/%s/public/v1/createTr", projectUuid);
                break;
            }
        }
        bvInstance.setStatus(Status.IN_PROGRESS);
        bvInstance.setStartTime(new Date());
        String request = GSON_INSTANCE.toJson((Object)requestData);
        if ("ReadCompare".equals(action)) {
            responseEntity = HttpClientFactory.getBvApiResourceFeignClient().readAndCompare(projectUuid, request);
            response = this.sendRequest("Executing after: {}", endpoint, request, (String)responseEntity.getBody());
        } else {
            responseEntity = HttpClientFactory.getBvPublicApiResourceFeignClient().createTr(projectUuid, request);
            response = this.sendRequest("Executing after: {}", endpoint, request, GSON_INSTANCE.toJson(responseEntity.getBody()));
        }
        String trId = BvResponseProcessor.processResponse(Objects.requireNonNull(response), action, chainInstance, bvInstance, integrationConf);
        if ("CreateNewTestRun".equals(action) && trId != null) {
            requestData = BvRequestBuilder.buildCompareRequest(trId, bvInstance);
            request = GSON_INSTANCE.toJson((Object)requestData);
            endpoint = String.format("/api/bvtool/project/%s/api/v1/compare", projectUuid);
            ResponseEntity responseEntity2 = HttpClientFactory.getBvApiResourceFeignClient().compare(projectUuid, request);
            response = this.sendRequest("Executing after with " + action + ": {}", endpoint, request, (String)responseEntity2.getBody());
            BvResponseProcessor.processResponse(response, "Compare", chainInstance, bvInstance, integrationConf);
        }
    }

    public void create(CallChain callChain, IntegrationConfig integrationConf, Map<String, String> properties, BigInteger projectId) throws EngineIntegrationException {
        RequestData requestData = BvRequestBuilder.buildCreateRequestData(callChain, integrationConf, properties);
        UUID projectUuid = UUID.fromString(BvHelper.getProjectUUID(projectId));
        String request = GSON_INSTANCE.toJson((Object)requestData);
        String endpoint = String.format("/api/bvtool/project/%s/testcases/v1/create", projectUuid);
        ResponseEntity responseEntity = HttpClientFactory.getBvTestCaseResourceFeignClient().create(projectUuid, request);
        String response = this.sendRequest("Creation: {}", endpoint, request, (String)responseEntity.getBody());
        try {
            JSONObject jsResponse = (JSONObject)new JSONParser().parse(response);
            callChain.getBvCases().put(properties.get("dataset.name"), jsResponse.get((Object)"tcId").toString());
        }
        catch (ParseException ex) {
            throw new EngineIntegrationException("Error while parsing response", (Throwable)ex);
        }
    }

    public void create(Situation situation, IntegrationConfig integrationConf, BigInteger projectId) throws EngineIntegrationException {
        RequestData requestData = BvRequestBuilder.buildCreateRequestData(situation, integrationConf);
        UUID projectUuid = UUID.fromString(BvHelper.getProjectUUID(projectId));
        String request = GSON_INSTANCE.toJson((Object)requestData);
        String endpoint = String.format("/api/bvtool/project/%s/testcases/v1/create", projectUuid);
        ResponseEntity responseEntity = HttpClientFactory.getBvTestCaseResourceFeignClient().create(projectUuid, request);
        String response = this.sendRequest("Creation: {}", endpoint, request, (String)responseEntity.getBody());
        try {
            JSONObject jsResponse = (JSONObject)new JSONParser().parse(response);
            situation.setBvTestcase(jsResponse.get((Object)"tcId").toString());
        }
        catch (ParseException ex) {
            throw new EngineIntegrationException("Error while parsing response", (Throwable)ex);
        }
    }

    public void delete(CallChain callChain, IntegrationConfig integrationConf, Map<String, String> properties, BigInteger projectId) {
        RequestData requestData = BvRequestBuilder.buildSimpleRequestData((Storable)callChain, properties);
        String request = GSON_INSTANCE.toJson((Object)requestData);
        UUID projectUuid = UUID.fromString(BvHelper.getProjectUUID(projectId));
        String endpoint = String.format("/api/bvtool/project/%s/testcases/v1/remove", projectUuid);
        ResponseEntity response = HttpClientFactory.getBvTestCaseResourceFeignClient().remove(projectUuid, request);
        this.sendRequest("Deleting: {}", endpoint, request, (String)response.getBody());
    }

    public void delete(Situation situation, IntegrationConfig integrationConf, BigInteger projectId) {
        RequestData requestData = new RequestData(situation.getBvTestcase());
        String request = GSON_INSTANCE.toJson((Object)requestData);
        UUID projectUuid = UUID.fromString(BvHelper.getProjectUUID(projectId));
        String endpoint = String.format("/api/bvtool/project/%s/testcases/v1/remove", projectUuid);
        ResponseEntity response = HttpClientFactory.getBvTestCaseResourceFeignClient().remove(projectUuid, request);
        this.sendRequest("Deleting: {}", endpoint, request, (String)response.getBody());
    }

    public void configure(CallChain callChain, IntegrationConfig integrationConf, Map<String, String> properties, BigInteger projectId) {
        ResponseEntity responseEntity;
        RequestData requestData = BvRequestBuilder.buildReadRequestData(callChain, integrationConf, properties);
        String request = GSON_INSTANCE.toJson((Object)requestData);
        UUID projectUuid = UUID.fromString(BvHelper.getProjectUUID(projectId));
        String endpoint = String.format("/api/bvtool/project/%s/api/v1/read", projectUuid);
        String response = this.sendRequest("Configuring: {}", endpoint, request, (String)(responseEntity = HttpClientFactory.getBvApiResourceFeignClient().read(projectUuid, request)).getBody());
        BvResponseData responseData = BvResponseProcessor.parseResponse(response);
        if (!"10000".equals(responseData.getStatusCode())) {
            String errorMessage = "Response from BulkValidator contains error(s)! Check URLtoISL, existence of the testCase in the BulkValidator by reference and check config BV Integration. Status Message: \n\r";
            throw new EngineIntegrationException(errorMessage + responseData.getStatusMessage());
        }
        LOGGER.info(responseData.getStatusMessage());
    }

    public boolean isExist(Storable storable, IntegrationConfig integrationConf, Map<String, String> properties, BigInteger projectId) throws EngineIntegrationException {
        ResponseEntity responseEntity;
        RequestData requestData = BvRequestBuilder.buildSimpleRequestData(storable, properties);
        String request = GSON_INSTANCE.toJson((Object)requestData);
        UUID projectUuid = UUID.fromString(BvHelper.getProjectUUID(projectId));
        String endpoint = String.format("/api/bvtool/project/%s/testcases/v1/getTestCaseStatus", projectUuid);
        String response = this.sendRequest("isExist: {}", endpoint, request, (String)(responseEntity = HttpClientFactory.getBvTestCaseResourceFeignClient().getTestCaseStatus(projectUuid, request)).getBody());
        String status = BvResponseProcessor.parseResponse(response).getTcStatus().getStatus();
        return !"TEST_CASE_DOESN'T_EXIST.".equals(status);
    }

    public String copyWithName(IntegrationConfig integrationConf, String newName, String sourceTcId, BigInteger projectId) throws EngineIntegrationException {
        CopyWithNameRequestDto request = BvRequestBuilder.buildCopyRequestData(newName, sourceTcId);
        String requestString = GSON_INSTANCE.toJson((Object)request);
        UUID projectUuid = UUID.fromString(BvHelper.getProjectUUID(projectId));
        String endpoint = String.format("/api/bvtool/project/%s/testcases/v1/copyWithName", projectUuid);
        ResponseEntity responseEntity = HttpClientFactory.getBvTestCaseResourceFeignClient().copyWithName(projectUuid, request);
        return this.sendRequest("copyWithName: {}", endpoint, requestString, (String)responseEntity.getBody());
    }

    private String sendRequest(String requestAction, String endpoint, String content, String response) throws EngineIntegrationException {
        try {
            ITF_LOGGER.debug("Request to BulkValidator:\n{}", (Object)content);
            HttpBvResponse httpBVResponse = new HttpBvResponse(200, true, response);
            if (!httpBVResponse.isSuccess()) {
                String error = "BulkValidator returned an error response:\n HTTP response code: " + httpBVResponse.getHttpResponseCode() + (httpBVResponse.getBvStatusCode() != -1 ? ",\n Status code: " + httpBVResponse.getBvStatusCode() + ",\n Status message: " + httpBVResponse.getBvStatusMessage() : ",\n Response body: " + httpBVResponse.getHttpResponseBody());
                ITF_LOGGER.debug(error);
                throw new ClientProtocolException(error);
            }
            ITF_LOGGER.debug("Response from BulkValidator:\n{}", (Object)response);
            return response;
        }
        catch (Exception ex) {
            String message = String.format("Request to BV failed: endpoint=%s\n%s", endpoint, ex);
            ITF_LOGGER.debug(message);
            throw new EngineIntegrationException(message);
        }
    }

    public boolean executeOnStep(SituationInstance instance, SpContext spContext, AbstractContainerInstance initiator, IntegrationConfig integrationConf) {
        return this.executeOnStep(instance, spContext, initiator, integrationConf, instance.getSituationById());
    }

    public boolean executeOnStep(SituationInstance instance, SpContext spContext, AbstractContainerInstance initiator, IntegrationConfig integrationConf, Situation situation) {
        QuickCompareRequest quickCompareRequest;
        String response;
        ResponseEntity responseEntity;
        String endpoint;
        String request;
        if (!this.checkExtension(situation, initiator)) {
            return true;
        }
        boolean situationTestcase = true;
        String tcId = situation.getBvTestcase();
        if (StringUtils.isBlank((CharSequence)tcId) && initiator instanceof CallChainInstance) {
            tcId = BvRequestBuilder.getBVCaseId((CallChainInstance)initiator);
            situationTestcase = false;
        }
        if (StringUtils.isBlank((CharSequence)tcId)) {
            throw new EngineIntegrationException("BulkValidator Testcase ID isn't specified! Validation at the situation '" + instance.getName() + "' is failed.");
        }
        UUID projectUuid = initiator.getContext().tc().getProjectUuid();
        if (situationTestcase) {
            request = "{\"testCasesIds\": [\"" + tcId + "\"] }";
            endpoint = String.format("/api/bvtool/project/%s/testcases/v1/getParameters", projectUuid);
            responseEntity = HttpClientFactory.getBvTestCaseResourceFeignClient().getParameters(projectUuid, request);
            response = this.sendRequest("Getting testcase vobjects: {}", endpoint, request, (String)responseEntity.getBody());
            quickCompareRequest = BvRequestBuilder.buildQuickCompareRequest(instance, situation, spContext, BvResponseProcessor.parseTestcaseVobjectsResponse(response), tcId);
        } else {
            quickCompareRequest = BvRequestBuilder.buildQuickCompareRequest(instance.getName(), spContext.getIncomingMessage(), tcId);
        }
        request = GSON_INSTANCE.toJson((Object)quickCompareRequest);
        endpoint = String.format("/api/bvtool/project/%s/public/v1/quickCompare", projectUuid);
        responseEntity = HttpClientFactory.getBvPublicApiResourceFeignClient().quickCompare(projectUuid, request);
        response = this.sendRequest("Executing message validation: {}", endpoint, request, GSON_INSTANCE.toJson(responseEntity.getBody()));
        QuickCompareResponse compareResult = BvResponseProcessor.processQuickCompareResponse(response);
        boolean result = "IDENTICAL".equals(compareResult.getCompareResult());
        String hlTable = this.printHlResult(compareResult.getSteps(), "");
        if (compareResult.getSteps() != null && compareResult.getSteps().size() > 0) {
            hlTable = "<div class=\"highlighter-container\">" + hlTable + "</div>";
        }
        if (!result) {
            initiator.setErrorName("Situation '" + instance.getName() + "': incoming message validation is failed (Compare Result is '" + compareResult.getCompareResult() + "')");
            initiator.setErrorMessage(hlTable);
        }
        initiator.getContext().tc().put((Object)"saved.summaryValidationResult", (Object)compareResult.getCompareResult());
        spContext.put((Object)"bvResultForRam2", (Object)response);
        spContext.setValidationResults(hlTable);
        return result;
    }

    private boolean checkExtension(Situation situation, AbstractContainerInstance initiator) {
        if (initiator instanceof CallChainInstance) {
            BvInstanceExtension extension = (BvInstanceExtension)initiator.getExtension(BvInstanceExtension.class);
            if (extension == null) {
                LOGGER.debug("BVInstanceExtension is not available for call chain '{}'", (Object)initiator);
                return false;
            }
            if (!extension.validateMessages) {
                LOGGER.debug("BVInstanceExtension: messages validation is turned OFF for call chain '{}'", (Object)initiator);
                return false;
            }
            return true;
        }
        return situation.getBooleanValidateIncoming();
    }

    private String printHlResult(List<Step> steps, String parentName) {
        StringBuilder sb = new StringBuilder();
        if (steps != null && !steps.isEmpty()) {
            for (Step step : steps) {
                String statusColor = this.compareResultToLabelColor(step.getCompareResult());
                String displayedDescription = StringUtils.isBlank((CharSequence)step.getDescription()) ? "" : "<br>&nbsp;<b>Description: </b>" + step.getDescription();
                sb.append("<div class=\"panel panel-").append(statusColor).append("\">").append("<div class=\"panel-heading\">").append(parentName).append(step.getStepName()).append(" <span data-block-id=\"pc-highlight-block\" class=\"").append(step.getCompareResult()).append("\">").append(StringUtils.upperCase((String)step.getCompareResult())).append("</span>").append(displayedDescription).append("</div>");
                sb.append("<div class=\"panel-body\">").append("<table border=\"1\"><tr><th width=\"50%\">ER</th><th width=\"50%\">AR</th></tr><tr style=\"vertical-align: top;\"><td width=\"50%\">").append(step.getHighlightedEr()).append("</td><td width=\"50%\">").append(step.getHighlightedAr()).append("</td></tr></table></div>");
                sb.append("</div>");
            }
        }
        return sb.toString();
    }

    private String compareResultToLabelColor(String compareResult) {
        if (StringUtils.isBlank((CharSequence)compareResult)) {
            return "default";
        }
        switch (compareResult.toLowerCase()) {
            case "identical": 
            case "passed": 
            case "success": {
                return "success";
            }
            case "similar": {
                return "warning";
            }
        }
        return "danger";
    }
}

