/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.convert.impl;

import java.math.BigInteger;
import java.util.UUID;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.environments.convert.Converter;
import org.qubership.automation.itf.environments.object.ECEntity;
import org.qubership.automation.itf.environments.object.impl.ECServer;

abstract class AbstractConverter<T extends EciConfigurable, V extends ECEntity<? extends EciConfigurable>>
implements Converter<T, V> {
    AbstractConverter() {
    }

    public void setMainParams(T storable, V ecEntity) {
        storable.setName(ecEntity.getName());
        storable.setDescription(ecEntity.getDescription());
    }

    public void setECIParams(T storable, V ecEntity) {
        storable.setEcId(ecEntity.getEcId());
        if (ecEntity.getEcProjectId() != null) {
            storable.setEcProjectId(ecEntity.getEcProjectId());
        }
    }

    @Override
    public T convert(V ecEntity, BigInteger parentId, UUID eciSessionId) {
        Storable parent = CoreObjectManager.getInstance().getManager(ecEntity.getParentClass()).getById((Object)parentId);
        return parent != null ? (T)this.convert(ecEntity, parent, eciSessionId, new Object[0]) : null;
    }

    @Override
    public abstract T convert(V var1, Storable var2, UUID var3, Object ... var4);

    @Override
    public void convert(V ecEntity, UUID eciSessionId) {
    }

    @Override
    public T getConfigurableEntity(V objectToConvert) {
        return (T)(objectToConvert instanceof ECServer ? ((EnvConfigurationManager)CoreObjectManager.getInstance().getSpecialManager(objectToConvert.getGenericType(), EnvConfigurationManager.class)).getByEcId(objectToConvert.getEcId(), new Object[]{objectToConvert.getName(), ((ECServer)objectToConvert).getUrl()}) : ((EnvConfigurationManager)CoreObjectManager.getInstance().getSpecialManager(objectToConvert.getGenericType(), EnvConfigurationManager.class)).getByEcId(objectToConvert.getEcId(), new Object[0]));
    }
}

