/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.convert.impl;

import java.util.Collection;
import java.util.UUID;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.environments.convert.impl.AbstractConverter;
import org.qubership.automation.itf.environments.object.impl.ECConnection;

public class OutboundTransportConfigurationConverter
extends AbstractConverter<OutboundTransportConfiguration, ECConnection> {
    @Override
    public OutboundTransportConfiguration convert(ECConnection ecConnection, Storable parent, UUID eciSessionId, Object ... objects) {
        OutboundTransportConfiguration otc = this.findOrCreateStorableByEnvConfId(ecConnection, parent, eciSessionId, objects);
        if (otc != null) {
            this.setMainParams(otc, ecConnection);
            otc.putAll(ecConnection.getParameters());
        }
        return otc;
    }

    @Override
    public OutboundTransportConfiguration findOrCreateStorableByEnvConfId(ECConnection ecConnection, Storable parent, UUID eciSessionId, Object ... objects) {
        OutboundTransportConfiguration otc = this.getConfigurableEntity(ecConnection);
        if (otc == null) {
            otc = this.getOTCByType(parent, ecConnection.getConnectionType());
            if (otc == null) {
                otc = new OutboundTransportConfiguration(ecConnection.getConnectionType(), (Server)parent, (System)objects[0]);
                ((Server)parent).getOutbounds().add(otc);
                this.setECIParams(otc, ecConnection);
            } else if (otc.getEcId() == null) {
                this.setECIParams(otc, ecConnection);
            }
        }
        return otc;
    }

    @Override
    public OutboundTransportConfiguration getConfigurableEntity(ECConnection ecConnection) {
        return (OutboundTransportConfiguration)((EnvConfigurationManager)CoreObjectManager.getInstance().getSpecialManager(OutboundTransportConfiguration.class, EnvConfigurationManager.class)).getByEcId(ecConnection.getEcId(), new Object[0]);
    }

    private OutboundTransportConfiguration getOTCByType(Storable parent, String typeName) {
        Collection otcByParentId = CoreObjectManager.getInstance().getManager(OutboundTransportConfiguration.class).getAllByParentId(parent.getID());
        for (OutboundTransportConfiguration otc : otcByParentId) {
            if (!typeName.equals(otc.getTypeName())) continue;
            return otc;
        }
        return null;
    }
}

