/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.util.validation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.environments.util.validation.ECIValidationError;
import org.qubership.automation.itf.environments.util.validation.ValidationLevel;

public class ECIErrorsCache {
    private static final ECIErrorsCache INSTANCE = new ECIErrorsCache();
    private static final int EXPIRED_TIMEOUT = 2;
    private static final Cache<UUID, List<ECIValidationError>> errorsCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();

    public static ECIErrorsCache getInstance() {
        return INSTANCE;
    }

    public Cache<UUID, List<ECIValidationError>> getErrorsCache() {
        return errorsCache;
    }

    public void put(UUID eciSessionId, String loadedEntityName, String loadedEntityType, String error, ValidationLevel validationLevel) {
        List errors = (List)ECIErrorsCache.getInstance().getErrorsCache().asMap().get(eciSessionId);
        ECIValidationError eciValidationError = new ECIValidationError(eciSessionId, loadedEntityName, loadedEntityType, error, validationLevel);
        if (errors != null) {
            errors.add(eciValidationError);
        } else {
            errors = Lists.newArrayList((Object[])new ECIValidationError[]{eciValidationError});
            errorsCache.put((Object)eciSessionId, (Object)errors);
        }
    }
}

