/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.convert;

import com.google.common.collect.Maps;
import java.util.Map;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.environments.convert.Converter;
import org.qubership.automation.itf.environments.convert.impl.ConnectionConverter;
import org.qubership.automation.itf.environments.convert.impl.EnvironmentConverter;
import org.qubership.automation.itf.environments.convert.impl.InboundTransportConfigurationConverter;
import org.qubership.automation.itf.environments.convert.impl.OutboundTransportConfigurationConverter;
import org.qubership.automation.itf.environments.convert.impl.ServerConverter;
import org.qubership.automation.itf.environments.convert.impl.SystemConverter;
import org.qubership.automation.itf.environments.object.ECEntity;

public class ConverterFactory {
    private static final Map<Class<? extends EciConfigurable>, Converter> converterMap = Maps.newHashMap();

    public static <T extends EciConfigurable, V extends ECEntity<? extends EciConfigurable>> Converter<T, V> getConverter(Class<T> clazz) {
        return converterMap.get(clazz);
    }

    static {
        converterMap.put(Environment.class, new EnvironmentConverter());
        converterMap.put(System.class, new SystemConverter());
        converterMap.put(TransportConfiguration.class, new ConnectionConverter());
        converterMap.put(Server.class, new ServerConverter());
        converterMap.put(OutboundTransportConfiguration.class, new OutboundTransportConfigurationConverter());
        converterMap.put(InboundTransportConfiguration.class, new InboundTransportConfigurationConverter());
    }
}

