/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.object.impl;

import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.environments.ECIConstants;
import org.qubership.automation.itf.environments.object.impl.ConvertableECEntity;
import org.qubership.automation.itf.environments.util.validation.ECIErrorsCache;
import org.qubership.automation.itf.environments.util.validation.ValidationLevel;

public class ECConnection
extends ConvertableECEntity<TransportConfiguration> {
    private Map<String, String> parameters;
    private String connectionType;

    public ECConnection() {
        this.setGenericType(TransportConfiguration.class);
        this.setParentClass(System.class);
    }

    public ECConnection(String ecId) {
        this.setEcId(ecId);
        this.setGenericType(TransportConfiguration.class);
        this.setParentClass(System.class);
    }

    public Pair<String, ECIConstants> getItfTypeOfConnection(UUID eciSessionId) {
        try {
            Map transportTypes = TransportRegistryManager.getInstance().getTransportTypes();
            String direction = this.parameters.get(ECIConstants.DIRECTION_EC_PARAM_NAME.value());
            if (StringUtils.isNotEmpty((CharSequence)direction)) {
                String ecTransportName = (direction + " " + this.getName()).toLowerCase();
                for (Map.Entry entry : transportTypes.entrySet()) {
                    if (!ecTransportName.contains(((String)entry.getValue()).toLowerCase())) continue;
                    return new ImmutablePair(entry.getKey(), (Object)ECIConstants.fromStringValue(direction));
                }
            }
        }
        catch (Exception e) {
            ECIErrorsCache.getInstance().put(eciSessionId, this.getName(), this.getClass().getSimpleName(), String.format("Error while trying to get the transport type for connection: %s", this.getName()), ValidationLevel.ERROR);
        }
        ECIErrorsCache.getInstance().put(eciSessionId, this.getName(), this.getClass().getSimpleName(), String.format("Unrecognized type of connection: %s. Please, check the name of connection and its direction.", this.getName()), ValidationLevel.ERROR);
        return null;
    }

    public boolean forEnvironment() {
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (!ECIConstants.CONNECTION_FOR_ENVIRONMENT_PARAMETER.value().equals(entry.getKey().toLowerCase()) || !"true".equals(entry.getValue().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String getEcLabel() {
        return this.parameters.get(ECIConstants.TRANSPORT_EC_LABEL.value());
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }
}

