/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.convert.impl;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.environments.ECIConstants;
import org.qubership.automation.itf.environments.convert.ConverterFactory;
import org.qubership.automation.itf.environments.convert.impl.AbstractConverter;
import org.qubership.automation.itf.environments.object.impl.ECEnvironment;
import org.qubership.automation.itf.environments.object.impl.ECSystem;
import org.qubership.automation.itf.environments.util.validation.ECIErrorsCache;
import org.qubership.automation.itf.environments.util.validation.ValidationLevel;

public class EnvironmentConverter
extends AbstractConverter<Environment, ECEnvironment> {
    @Override
    public Environment convert(ECEnvironment ecEnvironment, Storable parent, UUID eciSessionId, Object ... objects) {
        Environment env = this.findOrCreateStorableByEnvConfId(ecEnvironment, parent, eciSessionId, new Object[0]);
        this.setMainParams(env, ecEnvironment);
        this.unbindSystemsWhichAreNotExistInEC(ecEnvironment, env.getInbound(), eciSessionId);
        this.unbindSystemsWhichAreNotExistInEC(ecEnvironment, env.getOutbound(), eciSessionId);
        Map<System, Server> convertedSystemServerPairs = this.updateExistingAndCreateNewSystemsWithServers(ecEnvironment, env, eciSessionId);
        this.createNewSystemServerPairs(env.getInbound(), convertedSystemServerPairs, ECIConstants.INBOUND_DIRECTION);
        this.createNewSystemServerPairs(env.getOutbound(), convertedSystemServerPairs, ECIConstants.OUTBOUND_DIRECTION);
        return env;
    }

    @Override
    public Environment findOrCreateStorableByEnvConfId(ECEnvironment ecEnvironment, Storable parent, UUID eciSessionId, Object ... objects) {
        Environment environment = (Environment)this.getConfigurableEntity(ecEnvironment);
        if (environment == null) {
            environment = (Environment)CoreObjectManager.managerFor(Environment.class).create(parent);
            this.setECIParams(environment, ecEnvironment);
            environment.setProjectId((BigInteger)((EnvFolder)parent).getProject().getID());
        }
        return environment;
    }

    private Map<System, Server> updateExistingAndCreateNewSystemsWithServers(ECEnvironment ecEnvironment, Environment environment, UUID eciSessionId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)ecEnvironment.getSystems().size());
        StubProject project = (StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)environment.getProjectId());
        Folder systemFolder = project.getSystems();
        for (ECSystem ecSystem : ecEnvironment.getSystems()) {
            System system = ConverterFactory.getConverter(System.class).convert(ecSystem, (Storable)systemFolder, eciSessionId, new Object[0]);
            Server server = ConverterFactory.getConverter(Server.class).getConfigurableEntity(ecSystem.getServer());
            result.put(system, server);
        }
        return result;
    }

    private void unbindSystemsWhichAreNotExistInEC(ECEnvironment ecEnvironment, Map<System, Server> systemServerPairs, UUID eciSessionId) {
        for (Map.Entry<System, Server> systemServerPair : systemServerPairs.entrySet()) {
            System system = systemServerPair.getKey();
            if (!StringUtils.isNotEmpty((CharSequence)system.getEcId())) continue;
            boolean systemIsFound = false;
            for (ECSystem ecSystem : ecEnvironment.getSystems()) {
                if (!ecSystem.getEcId().equals(system.getEcId()) && !ecSystem.getName().equals(system.getEcLabel())) continue;
                systemIsFound = true;
                break;
            }
            if (systemIsFound) continue;
            system.unbindEntityWithHierarchy();
            ECIErrorsCache.getInstance().put(eciSessionId, system.getName(), system.getClass().getSimpleName(), String.format("System [id=%s, name=%s] has become unbind from EC during updating", system.getID(), system.getName()), ValidationLevel.INFO);
        }
    }

    private void createNewSystemServerPairs(Map<System, Server> pairs, Map<System, Server> convertedSystemServerPairs, ECIConstants direction) {
        for (Map.Entry<System, Server> convertedEntry : convertedSystemServerPairs.entrySet()) {
            System convertedSystem = convertedEntry.getKey();
            Server convertedServer = convertedEntry.getValue();
            boolean pairWasFound = false;
            for (Map.Entry<System, Server> existingSystemServerPairs : pairs.entrySet()) {
                if (!convertedSystem.getID().toString().equals(existingSystemServerPairs.getKey().getID().toString()) || !convertedServer.getID().toString().equals(existingSystemServerPairs.getValue().getID().toString())) continue;
                pairWasFound = true;
                break;
            }
            if (pairWasFound || (!ECIConstants.INBOUND_DIRECTION.equals((Object)direction) || !this.itIsInbound(convertedSystem)) && (!ECIConstants.OUTBOUND_DIRECTION.equals((Object)direction) || !this.itIsOutbound(convertedSystem))) continue;
            pairs.put(convertedSystem, convertedServer);
        }
    }

    private boolean itIsOutbound(System system) {
        for (TransportConfiguration transport : system.getTransports()) {
            if (!transport.getMep().isOutbound()) continue;
            return true;
        }
        return false;
    }

    private boolean itIsInbound(System system) {
        for (TransportConfiguration transport : system.getTransports()) {
            if (!transport.getMep().isInbound()) continue;
            return true;
        }
        return false;
    }
}

