/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.convert.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.environments.ECIConstants;
import org.qubership.automation.itf.environments.convert.ConverterFactory;
import org.qubership.automation.itf.environments.convert.impl.AbstractConverter;
import org.qubership.automation.itf.environments.object.impl.ECConnection;
import org.qubership.automation.itf.environments.object.impl.ECSystem;
import org.qubership.automation.itf.environments.util.validation.ECIErrorsCache;
import org.qubership.automation.itf.environments.util.validation.ValidationLevel;

public class SystemConverter
extends AbstractConverter<System, ECSystem> {
    @Override
    public System convert(ECSystem ecSystem, Storable parent, UUID eciSessionId, Object ... objects) {
        System system = this.findSystemByEcLabel(ecSystem, parent.getProjectId());
        if (system == null) {
            system = this.findOrCreateStorableByEnvConfId(ecSystem, parent, eciSessionId, new Object[0]);
            this.setMainParams(system, ecSystem);
            system.setEcLabel(ecSystem.getName());
        }
        this.convertSystem(ecSystem, system, eciSessionId, parent.getProjectId());
        return system;
    }

    @Override
    public System findOrCreateStorableByEnvConfId(ECSystem ecSystem, Storable parent, UUID eciSessionId, Object ... objects) {
        System system = (System)this.getConfigurableEntity(ecSystem);
        if (system == null) {
            system = (System)CoreObjectManager.managerFor(System.class).create(parent);
            this.setECIParams(system, ecSystem);
        }
        return system;
    }

    private void convertSystem(ECSystem ecSystem, System system, UUID eciSessionId, BigInteger projectId) {
        Server server = this.convertServer(ecSystem, system, eciSessionId, projectId);
        this.updateExistingAndCreateNewEnvironmentTransportConfiguration(ecSystem, system, server, eciSessionId);
        this.updateExistingAndCreateNewTransports(ecSystem, system, server, eciSessionId);
    }

    private System findSystemByEcLabel(ECSystem ecSystem, BigInteger projectId) {
        return (System)((EnvConfigurationManager)CoreObjectManager.getInstance().getSpecialManager(System.class, EnvConfigurationManager.class)).findByEcLabel(ecSystem.getName(), projectId);
    }

    private void updateExistingAndCreateNewTransports(ECSystem ecSystem, System system, Server server, UUID eciSessionId) {
        Map<ECIConstants, Map<String, Map<ECIConstants, List<ECConnection>>>> connectionsByDirectionTypeTarget = this.getConnectionsByDirectionTypeTarget(ecSystem, eciSessionId);
        Map<String, Map<ECIConstants, List<ECConnection>>> connectionsByTypeTarget = connectionsByDirectionTypeTarget.get((Object)ECIConstants.INBOUND_DIRECTION);
        if (connectionsByTypeTarget != null) {
            this.convertInboundConnections(connectionsByTypeTarget, system, server, eciSessionId);
        }
        if ((connectionsByTypeTarget = connectionsByDirectionTypeTarget.get((Object)ECIConstants.OUTBOUND_DIRECTION)) != null) {
            this.convertOutboundConnections(connectionsByTypeTarget, system, server, eciSessionId);
        }
    }

    private void updateExistingAndCreateNewEnvironmentTransportConfiguration(ECSystem ecSystem, System system, Server server, UUID eciSessionId) {
        Map<ECIConstants, Map<String, Map<ECIConstants, List<ECConnection>>>> connectionsByDirectionTypeTarget = this.getConnectionsByDirectionTypeTarget(ecSystem, eciSessionId);
        Map<String, Map<ECIConstants, List<ECConnection>>> connectionsByTypeTarget = connectionsByDirectionTypeTarget.get((Object)ECIConstants.OUTBOUND_DIRECTION);
        if (connectionsByTypeTarget != null) {
            this.convertOutboundTransportConfiguration(connectionsByTypeTarget, system, server, eciSessionId);
        }
        if ((connectionsByTypeTarget = connectionsByDirectionTypeTarget.get((Object)ECIConstants.INBOUND_DIRECTION)) != null) {
            this.convertInboundTransportConfiguration(connectionsByTypeTarget, system, server, eciSessionId);
        }
    }

    private void convertInboundConnections(Map<String, Map<ECIConstants, List<ECConnection>>> connectionsByTypeTarget, System system, Server server, UUID eciSessionId) {
        for (Map.Entry<String, Map<ECIConstants, List<ECConnection>>> byType : connectionsByTypeTarget.entrySet()) {
            Map<ECIConstants, List<ECConnection>> byTarget = byType.getValue();
            for (ECConnection ecConnection : byTarget.get((Object)ECIConstants.FOR_TRANSPORT)) {
                ecConnection.setConnectionType(byType.getKey());
                TransportConfiguration transport = ConverterFactory.getConverter(TransportConfiguration.class).convert(ecConnection, (Storable)system, eciSessionId, new Object[0]);
                system.getTransports().add(transport);
            }
        }
    }

    private void convertOutboundConnections(Map<String, Map<ECIConstants, List<ECConnection>>> connectionsByTypeTarget, System system, Server server, UUID eciSessionId) {
        for (Map.Entry<String, Map<ECIConstants, List<ECConnection>>> byType : connectionsByTypeTarget.entrySet()) {
            Map<ECIConstants, List<ECConnection>> byTarget = byType.getValue();
            ECConnection connectionForEnvironment = this.getConnectionForEnvironment(system, server, byType.getKey(), byTarget, eciSessionId);
            if (connectionForEnvironment != null) {
                ConverterFactory.getConverter(OutboundTransportConfiguration.class).convert(connectionForEnvironment, (Storable)server, eciSessionId, system);
            }
            if (!byTarget.containsKey((Object)ECIConstants.FOR_TRANSPORT)) continue;
            for (ECConnection ecConnection : byTarget.get((Object)ECIConstants.FOR_TRANSPORT)) {
                ecConnection.setConnectionType(byType.getKey());
                TransportConfiguration transport = ConverterFactory.getConverter(TransportConfiguration.class).convert(ecConnection, (Storable)system, eciSessionId, new Object[0]);
                system.getTransports().add(transport);
            }
        }
    }

    private void convertInboundTransportConfiguration(Map<String, Map<ECIConstants, List<ECConnection>>> connectionsByTypeTarget, System system, Server server, UUID eciSessionId) {
        for (Map.Entry<String, Map<ECIConstants, List<ECConnection>>> byType : connectionsByTypeTarget.entrySet()) {
            Map<ECIConstants, List<ECConnection>> byTarget = byType.getValue();
            List<ECConnection> ecConnections = byTarget.get((Object)ECIConstants.FOR_TRANSPORT);
            if (ecConnections == null) continue;
            for (ECConnection ecConnection : ecConnections) {
                TransportConfiguration transportByEcLabel;
                String ecLabel = ecConnection.getEcLabel();
                if (!StringUtils.isNotEmpty((CharSequence)ecLabel) || (transportByEcLabel = this.getTransportByEcLabel(system.getTransports(), ecLabel)) == null) continue;
                ConverterFactory.getConverter(InboundTransportConfiguration.class).convert(ecConnection, (Storable)server, eciSessionId, transportByEcLabel);
            }
        }
    }

    private void convertOutboundTransportConfiguration(Map<String, Map<ECIConstants, List<ECConnection>>> connectionsByTypeTarget, System system, Server server, UUID eciSessionId) {
        for (Map.Entry<String, Map<ECIConstants, List<ECConnection>>> byType : connectionsByTypeTarget.entrySet()) {
            Map<ECIConstants, List<ECConnection>> byTarget = byType.getValue();
            ECConnection connectionForEnvironment = this.getConnectionForEnvironment(system, server, byType.getKey(), byTarget, eciSessionId);
            if (connectionForEnvironment == null) continue;
            ConverterFactory.getConverter(OutboundTransportConfiguration.class).convert(connectionForEnvironment, (Storable)server, eciSessionId, system);
        }
    }

    private ECConnection getConnectionForEnvironment(System system, Server server, String connectionType, Map<ECIConstants, List<ECConnection>> byTarget, UUID eciSessionId) {
        ECConnection connectionForEnvironment = null;
        if (byTarget.get((Object)ECIConstants.FOR_ENV) != null) {
            int connectionForEnvCount = byTarget.get((Object)ECIConstants.FOR_ENV).size();
            if (connectionForEnvCount > 1) {
                ECIErrorsCache.getInstance().put(eciSessionId, "", connectionType, String.format("There are more then 1 special connection for %s transports", connectionType), ValidationLevel.INFO);
            } else if (connectionForEnvCount == 1 && !server.getOutbounds().isEmpty() && server.getOutbound(system, connectionType).getEcId() != null && !server.getOutbound(system, connectionType).getEcId().equals(byTarget.get((Object)ECIConstants.FOR_ENV).get(0).getEcId())) {
                ECIErrorsCache.getInstance().put(eciSessionId, "", connectionType, String.format("Environment already has the %s transport configuration for %s/%s", connectionType, system.getName(), server.getName()), ValidationLevel.INFO);
            } else {
                connectionForEnvironment = byTarget.get((Object)ECIConstants.FOR_ENV).get(0);
                connectionForEnvironment.setConnectionType(connectionType);
            }
        }
        return connectionForEnvironment;
    }

    private TransportConfiguration getTransportByEcLabel(Set<TransportConfiguration> transports, String ecLabel) {
        for (TransportConfiguration transport : transports) {
            if (!ecLabel.equals(transport.get((Object)ECIConstants.TRANSPORT_EC_LABEL.value()))) continue;
            return transport;
        }
        return null;
    }

    private void unbindTransportsWhichAreNotExistInEC(ECSystem ecSystem, System system, UUID eciSessionId) {
        for (TransportConfiguration transport : system.getTransports()) {
            boolean transportIsFound = false;
            for (ECConnection ecConnection : ecSystem.getConnections()) {
                if (transport.getEcId() == null || !transport.getEcId().equals(ecConnection.getEcId())) continue;
                transportIsFound = true;
                break;
            }
            if (transportIsFound || transport.getEcId() == null) continue;
            transport.unbindEntityWithHierarchy();
            ECIErrorsCache.getInstance().put(eciSessionId, transport.getName(), transport.getTypeName(), String.format("Transport [id=%s, name=%s] has become unbind from EC during updating", transport.getID(), transport.getName()), ValidationLevel.INFO);
        }
    }

    private Server convertServer(ECSystem ecSystem, System system, UUID eciSessionId, BigInteger projectId) {
        ecSystem.getServer().setEcId(ecSystem.getEcId());
        ecSystem.getServer().setEcProjectId(system.getEcProjectId());
        return ConverterFactory.getConverter(Server.class).convert(ecSystem.getServer(), (Storable)((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)projectId)).getServers(), eciSessionId, new Object[0]);
    }

    private Map<ECIConstants, Map<String, Map<ECIConstants, List<ECConnection>>>> getConnectionsByDirectionTypeTarget(ECSystem ecSystem, UUID eciSessionId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        for (ECConnection connection : ecSystem.getConnections()) {
            Pair<String, ECIConstants> itfTypeOfConnection = connection.getItfTypeOfConnection(eciSessionId);
            if (itfTypeOfConnection == null) continue;
            Map byDirection = (Map)result.get(itfTypeOfConnection.getRight());
            if (byDirection == null) {
                byDirection = Maps.newHashMap();
                HashMap target2connection = Maps.newHashMap();
                if (connection.forEnvironment()) {
                    target2connection.put(ECIConstants.FOR_ENV, Lists.newArrayList((Object[])new ECConnection[]{connection}));
                } else {
                    target2connection.put(ECIConstants.FOR_TRANSPORT, Lists.newArrayList((Object[])new ECConnection[]{connection}));
                }
                byDirection.put(itfTypeOfConnection.getLeft(), target2connection);
                result.put(itfTypeOfConnection.getRight(), byDirection);
                continue;
            }
            Map byType = (Map)byDirection.get(itfTypeOfConnection.getLeft());
            if (byType == null) {
                HashMap target2connection = Maps.newHashMap();
                if (connection.forEnvironment()) {
                    target2connection.put(ECIConstants.FOR_ENV, Lists.newArrayList((Object[])new ECConnection[]{connection}));
                } else {
                    target2connection.put(ECIConstants.FOR_TRANSPORT, Lists.newArrayList((Object[])new ECConnection[]{connection}));
                }
                byDirection.put(itfTypeOfConnection.getLeft(), target2connection);
                continue;
            }
            ECIConstants target = connection.forEnvironment() ? ECIConstants.FOR_ENV : ECIConstants.FOR_TRANSPORT;
            List ecConnections = (List)byType.get((Object)target);
            if (ecConnections == null) {
                ecConnections = Lists.newArrayList((Object[])new ECConnection[]{connection});
                byType.put(target, ecConnections);
                continue;
            }
            ecConnections.add(connection);
        }
        return result;
    }
}

