/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.environments.parse;

import com.google.common.collect.Maps;
import java.util.Map;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.environments.object.ECEntity;
import org.qubership.automation.itf.environments.parse.Parser;
import org.qubership.automation.itf.environments.parse.parsers.ECConnectionParser;
import org.qubership.automation.itf.environments.parse.parsers.ECSystemParser;
import org.qubership.automation.itf.environments.parse.parsers.EnvironmentParser;

public class ParserFactory {
    private static final Map<Class<? extends EciConfigurable>, Parser> FACTORY = Maps.newHashMap();

    public static <T extends EciConfigurable & ECEntity<? extends EciConfigurable>, V> Parser<T, V> getParser(Class<? extends EciConfigurable> clazz) {
        return FACTORY.get(clazz);
    }

    static {
        FACTORY.put(Environment.class, new EnvironmentParser());
        FACTORY.put(System.class, new ECSystemParser());
        FACTORY.put(TransportConfiguration.class, new ECConnectionParser());
    }
}

