/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.items;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.report.items.ATPReportItem;
import org.qubership.automation.itf.report.items.HtmlBuilder;

public abstract class ATPReportMessage
extends ATPReportItem {
    protected Throwable exception;
    protected TcContext tcContext;
    protected Status status;
    protected Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ATPReportMessage(AbstractInstance object) {
        super(object);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setTcContext(TcContext tcContext) {
        this.tcContext = tcContext;
    }

    public String buildSimpleSnapShotRam2(Message message, Collection<MessageParameter> messageParameters, String contextMessage) {
        return this.buildSimpleSnapShotRam2(message, messageParameters, contextMessage, null);
    }

    public String buildSimpleSnapShotRam2(Message message, Collection<MessageParameter> messageParameters, String contextMessage, Message responseMessage) {
        HtmlBuilder builder = new HtmlBuilder();
        builder.beginDiv();
        builder.beginTable("Properties");
        builder.addHeaders("Key", "Value");
        builder.addRow("Message", "<a onclick='atp_ram_toggle(this)'>Collapse</a><pre><div>" + StringEscapeUtils.escapeXml10((String)(message == null ? "" : message.getText())) + "</div></pre>");
        if (message != null) {
            this.appendPropertiesFromMessage(message, builder, "Headers");
            this.appendMessageParameters(messageParameters, builder);
        }
        if (responseMessage != null) {
            builder.addRow("Response Message", "<a onclick='atp_ram_toggle(this)'>Collapse</a><pre><div>" + StringEscapeUtils.escapeXml10((String)responseMessage.getText()) + "</div></pre>");
            this.appendPropertiesFromMessage(responseMessage, builder, "Response Headers");
        }
        builder.addRow("Step Context", "<pre>" + StringEscapeUtils.escapeXml10((String)contextMessage) + "</pre>");
        String tcJson = this.GSON.toJson((Object)this.tcContext);
        builder.addRow("Testcase Context", "<a onclick='atp_ram_toggle(this)'>Collapse</a><pre><div>" + StringEscapeUtils.escapeXml10((String)tcJson) + "</div></pre>");
        builder.endTable();
        builder.endDiv();
        return builder.build();
    }

    private void appendMessageParameters(Collection<MessageParameter> messageParameters, HtmlBuilder builder) {
        builder.beginRow().cell("Message Parameters").beginCell().beginTable();
        this.addMessageParameters(builder, messageParameters);
        builder.endTable().endCell().endRow();
    }

    private void appendPropertiesFromMessage(Message message, HtmlBuilder builder, String tableTitle) {
        this.addProperties(builder, message.getConnectionProperties());
        builder.beginRow().cell(tableTitle).beginCell().beginTable();
        this.addProperties(builder, message.getHeaders());
        builder.endTable().endCell().endRow();
    }

    private void addProperties(HtmlBuilder builder, Map<String, ?> properties) {
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            Object value = property.getValue();
            builder.addRow(property.getKey(), value != null ? value.toString() : "null");
        }
    }

    private void addMessageParameters(HtmlBuilder builder, Collection<MessageParameter> properties) {
        if (properties == null) {
            return;
        }
        for (MessageParameter property : properties) {
            List multipleValue = property.getMultipleValue();
            if (multipleValue == null) continue;
            for (String value : multipleValue) {
                builder.addRow(property.getParamName(), value);
            }
        }
    }
}

