/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.items;

public class HtmlBuilder {
    private static String bvHighlighterBulkValidatorStyles = " .IDENTICAL { color:black;  background-color: lightgreen; } .SIMILAR { color: #000000; background-color: #FFFF77; } .NORMAL { color:blue; } .CHANGED { color:#ff9999; } .MODIFIED { background-color:#ff9999; } .EXTRA { background-color: orange; } .MISSED { background-color: #C7EDFC; } .ERROR { background-color:yellow; color:red } .highlight-container .line-numbers .line-number { background-color:#EEEEEE; color: #B7B7B7; border-right: 1px solid #ccc; padding-left: 20px; text-align: right; /* make line number as unselectable */ -webkit-user-select: none; /* Chrome/Safari */ -moz-user-select: none; /* Firefox */ -ms-user-select: none; /* IE10+ */ /* Rules below not implemented in browsers yet */ -o-user-select: none; user-select: none; } .highlight-container .text-content-wrapper { overflow : hidden; overflow-x : scroll; } .highlight-container .text-content { margin:0; width:100%; } .highlight-container .text-content span.modified { background-color:#F2DEDE; } .highlight-container .text-content span.skip { background-color:#EEEEEE; text-decoration:line-through; } /* END :: XML XPath highlighter */ /* Bootstrap */ /* Add margin for button toolbal in tab,callout */ .callout .btn-toolbar:first-child, .tab-pane .btn-toolbar:first-child { margin-top: 10px; margin-bottom: 10px; } /* Add bold text and background for optgroup */ .form-control optgroup { font-weight: bold; } .form-control optgroup option { font-weight: normal; } /* Change font size for PRE */ .container-step-details pre { font-size: 10px; } /* XLarge modal Size */ .modal-xl { width: 1300px; } .modal-full-width { width: 100%; margin-left: 0px; margin-right: 0px; } .testrun-container .popover{ z-index: 3000; } /* Custom Label Color */ .label.label-none { border:1px solid #616161; color: #616161; } /* Show spinner by center page */ .spinner-center { position: fixed; top: 50%; left: 50%; /* bring your own prefixes */ transform: translate(-50%, -50%); } /* COMPARATOR RESULTS */ .comparator-result-identical { background-color:#DFF0D8 !important; } .comparator-result-identical-with-wrong-step { background: repeating-linear-gradient( 135deg, #FBBD7F, #FBBD7F 2px, #DFF0D8 3px, #DFF0D8 20px ); } .comparator-result-changed { background-color:#F2DEDE !important; } .comparator-result-missed-step { background: repeating-linear-gradient( 135deg, #EDD3D3, #EDD3D3 10px, #F2DEDE 10px, #F2DEDE 20px ); } .comparator-result-changed-with-wrong-step { background: repeating-linear-gradient( 135deg, #FBBD7F, #FBBD7F 5px, #F2DEDE 5px, #F2DEDE 20px ); } .comparator-result-similar { background-color: #FCFC90 !important; } .comparator-result-similar-with-wrong-step { background: repeating-linear-gradient( 135deg, #FBBD7F, #FBBD7F 5px, #FCFC90 5px, #FCFC90 20px ); } .comparator-result-wrong-step { background-color:#FBBD7F !important; }\n";
    private StringBuilder builder = new StringBuilder();

    public HtmlBuilder() {
        this.builder.append("<html>");
        this.builder.append("<script type='application/javascript' src='/scripts/jquery.js'></script>");
        this.builder.append("<style>").append("table {\n").append("    border-collapse: collapse;\n").append("}\n").append("\n").append("table, th, td {\n").append("    border: 1px solid black;\n").append("}\n").append('\n').append("td {\n").append("    white-space: pre-wrap;\n").append("}\n").append(bvHighlighterBulkValidatorStyles).append("</style>");
        this.builder.append("<script type='application/javascript'>").append("function toggle(root) {\n\tjQuery(root).parent().find('pre').toggle();\n\tjQuery(root).text(jQuery(root).text() == 'Collapse'?'Expand':'Collapse');\n}").append("</script>");
    }

    public HtmlBuilder beginTable(String title) {
        this.builder.append("<h3>").append(title).append("</h3>").append("<br/>").append("<table>");
        return this;
    }

    public HtmlBuilder beginTable() {
        this.builder.append("<table>");
        return this;
    }

    public HtmlBuilder endTable() {
        this.builder.append("</table>");
        return this;
    }

    public HtmlBuilder beginRow() {
        this.builder.append("<tr>");
        return this;
    }

    public HtmlBuilder endRow() {
        this.builder.append("</tr>");
        return this;
    }

    public HtmlBuilder addRow(String ... values) {
        this.beginRow();
        for (String value : values) {
            this.cell(value);
        }
        this.endRow();
        return this;
    }

    public HtmlBuilder beginDiv() {
        this.builder.append("<div>");
        return this;
    }

    public HtmlBuilder endDiv() {
        this.builder.append("</div>");
        return this;
    }

    public HtmlBuilder addHeaders(String ... values) {
        this.beginRow();
        for (String value : values) {
            this.header(value);
        }
        this.endRow();
        return this;
    }

    public HtmlBuilder cell(String value) {
        this.beginCell().addValue(value).endCell();
        return this;
    }

    public HtmlBuilder beginCell() {
        this.builder.append("<td>");
        return this;
    }

    public HtmlBuilder endCell() {
        this.builder.append("</td>");
        return this;
    }

    public HtmlBuilder header(String header) {
        this.builder.append("<th>").append(header).append("</th>");
        return this;
    }

    public HtmlBuilder addValue(String element) {
        this.builder.append(element);
        return this;
    }

    public HtmlBuilder element(String element) {
        this.builder.append(element);
        return this;
    }

    public String build() {
        return this.builder.append("</html>").toString();
    }
}

