/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.MapDifference;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.atp.adapter.common.AtpRamAdapter;
import org.qubership.atp.adapter.common.adapters.providers.RamAdapterProvider;
import org.qubership.atp.adapter.common.context.TestRunContext;
import org.qubership.atp.adapter.common.context.TestRunContextHolder;
import org.qubership.atp.adapter.common.entities.Message;
import org.qubership.atp.adapter.common.ws.StartRunRequest;
import org.qubership.atp.ram.dto.response.MessageParameter;
import org.qubership.atp.ram.enums.OpenMode;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.models.CustomLink;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.logrecords.ItfLogRecord;
import org.qubership.atp.ram.models.logrecords.parts.ContextVariable;
import org.qubership.atp.ram.models.logrecords.parts.Request;
import org.qubership.atp.ram.models.logrecords.parts.RequestHeader;
import org.qubership.atp.ram.models.logrecords.parts.Response;
import org.qubership.automation.itf.core.instance.situation.TCContextDiffCache;
import org.qubership.automation.itf.core.instance.step.impl.IntegrationStepHelper;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.report.ReportLinkCreator;
import org.qubership.automation.itf.core.util.FlatMapUtil;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.constants.SituationLevelValidation;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.manager.ExtensionManager;
import org.qubership.automation.itf.core.util.transport.service.report.ReportAdapter;
import org.qubership.automation.itf.executor.transports.holder.TransportHolder;
import org.qubership.automation.itf.report.extension.InstanceRam2Extension;
import org.qubership.automation.itf.report.extension.TCContextRamExtension;
import org.qubership.automation.itf.report.items.ATPReportMessage;
import org.qubership.automation.itf.report.util.ATPReportUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAM2ReportAdapter
implements ReportAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RAM2ReportAdapter.class);
    private static final int ATP_NAME_MAX_LENGTH = 200;
    private static final String DOTS = "...";
    private static final int ATP_NAME_TRIM_SIZE = 200 - "...".length() + 1;
    private String logName;
    private final ConcurrentHashMap<Object, AtpRamAdapter> adapters = new ConcurrentHashMap();
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private static String getShortTransportName(AbstractInstance instance) {
        if (instance instanceof StepInstance) {
            return RAM2ReportAdapter.getShortTransportName(((IntegrationStep)((StepInstance)instance).getStep()).getOperation().getTransport().getTypeName());
        }
        return "ITF";
    }

    private static String getShortTransportName(String fullTransportName) {
        return TransportHolder.getInstance().getShortName(fullTransportName);
    }

    private AtpRamAdapter getAdapter(Object sessionId) {
        return this.adapters.computeIfAbsent(sessionId, adapter -> RamAdapterProvider.getNewAdapter((String)this.logName));
    }

    public void openSection(AbstractInstance instance, String title) {
        if (instance instanceof SituationInstance) {
            return;
        }
        if (!this.prepareTestRunContext(instance, false)) {
            return;
        }
        TestRunContext testRunContext = this.getAdapter(instance.getContext().getTC().getID()).getContext();
        String parentSectionId = testRunContext.getAtpCompaund().getSectionId();
        String currentSectionId = testRunContext.getCurrentSectionId();
        if (StringUtils.isBlank((CharSequence)currentSectionId)) {
            currentSectionId = UUID.randomUUID().toString();
        }
        testRunContext = this.getAdapter(instance.getContext().getTC().getID()).openSection(title, "", instance instanceof CallChainInstance && this.isInitiator(instance) ? parentSectionId : currentSectionId, null, "PASSED");
        if (instance.getStartTime() != null) {
            testRunContext.getCurrentSection().setStartDate(new Timestamp(instance.getStartTime().getTime()));
        }
        InstanceRam2Extension ramExtension = (InstanceRam2Extension)ExtensionManager.getInstance().getExtension((Object)instance, InstanceRam2Extension.class);
        ramExtension.setSectionId(parentSectionId);
        LOGGER.debug("After open section: logRecordUuid {}, CurrentSectionId {}", (Object)testRunContext.getLogRecordUuid(), (Object)currentSectionId);
        if (instance instanceof CallChainInstance) {
            this.setCustomLinkToCallChain(testRunContext.getCurrentSection(), instance.getContext().getTC().getProjectUuid().toString(), ((CallChainInstance)instance).getTestCaseId());
        }
        this.getAdapter(instance.getContext().getTC().getID()).setContext(testRunContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSection(AbstractInstance containerInstance) {
        AbstractInstance abstractInstance = containerInstance;
        synchronized (abstractInstance) {
            if (!this.prepareTestRunContext(containerInstance, true)) {
                return;
            }
            AtpRamAdapter adapter = this.getAdapter(containerInstance.getContext().getTC().getID());
            if (containerInstance instanceof SituationInstance) {
                this.reportEndOfSituationAndSteps(adapter, (SituationInstance)containerInstance);
            } else {
                if (!(containerInstance instanceof StepInstance) && containerInstance.getError() != null) {
                    adapter.getContext().getCurrentSection().setMessage(containerInstance.getError().toString());
                    adapter.getContext().getCurrentSection().setTestingStatus(TestingStatuses.FAILED);
                }
                this.updateSectionName(adapter, containerInstance);
                TestRunContext testRunContext = adapter.closeSection();
                if (containerInstance.getEndTime() != null) {
                    testRunContext.getCurrentSection().setEndDate(new Timestamp(containerInstance.getEndTime().getTime()));
                }
                adapter.setContext(testRunContext);
                LOGGER.debug("After close section CurrentSectionId {}", (Object)testRunContext.getCurrentSectionId());
            }
        }
    }

    private void reportEndOfSituationAndSteps(AtpRamAdapter adapter, SituationInstance situationInstance) {
        TestRunContext testRunContext = adapter.getContext();
        List stepInstances = situationInstance.getStepInstances();
        String errorMessage = this.getErrorMessage(situationInstance.getErrorName(), situationInstance.getErrorMessage(), situationInstance.getError());
        MapDifference diff = (MapDifference)TCContextDiffCache.TC_CONTEXT_DIFF_CACHE.getIfPresent((Object)situationInstance.getID().toString());
        if (stepInstances.isEmpty()) {
            Message logRecord = new Message(UUID.randomUUID().toString(), testRunContext.getCurrentSectionId(), situationInstance.getName(), errorMessage, situationInstance.getStatus().toString().toUpperCase(), "TECHNICAL", false);
            logRecord.setStartDate(new Timestamp(situationInstance.getStartTime().getTime()));
            if (situationInstance.getEndTime() != null) {
                logRecord.setEndDate(new Timestamp(situationInstance.getEndTime().getTime()));
            }
            if (!situationInstance.getLabels().isEmpty()) {
                logRecord.setValidationLabels(new HashSet(situationInstance.getLabels()));
            }
            this.setCustomLinkToSituation(logRecord, situationInstance.getContext().tc().getProjectUuid().toString(), situationInstance);
            adapter.message(logRecord);
            adapter.updateContextVariables(logRecord.getUuid(), this.fillContextVariables((MapDifference<String, Object>)diff));
        } else {
            Message lastStepMessage = null;
            int stepInstancesSize = stepInstances.size();
            for (int i = 0; i < stepInstancesSize; ++i) {
                StepInstance stepInstance = (StepInstance)stepInstances.get(i);
                if (i < stepInstancesSize - 1 && IntegrationStepHelper.notLastValidationAttempt((StepInstance)stepInstance, (StepInstance)((StepInstance)stepInstances.get(i + 1)))) continue;
                Message msg = this.createMessage(situationInstance.getName(), (AbstractInstance)stepInstance, situationInstance.getStatus().toString().toUpperCase(), "", UUID.randomUUID().toString(), testRunContext.getCurrentSectionId(), RAM2ReportAdapter.getShortTransportName((AbstractInstance)stepInstance));
                msg.setStartDate(new Timestamp(stepInstance.getStartTime().getTime()));
                if (stepInstance.getEndTime() != null) {
                    msg.setEndDate(new Timestamp(stepInstance.getEndTime().getTime()));
                }
                if (!Status.PASSED.equals((Object)situationInstance.getStatus())) {
                    msg.setMessage(errorMessage);
                }
                if (!situationInstance.getLabels().isEmpty()) {
                    msg.setValidationLabels(new HashSet(situationInstance.getLabels()));
                }
                this.setCustomLinkToSituation(msg, situationInstance.getContext().tc().getProjectUuid().toString(), situationInstance);
                JSONObject bvResult = JSONObject.fromObject((Object)this.getBvResult((AbstractInstance)situationInstance, "bvResultForRam2"));
                if (!bvResult.isEmpty()) {
                    adapter.restMessage(msg, bvResult);
                } else {
                    adapter.restMessage(msg);
                }
                lastStepMessage = msg;
            }
            if (lastStepMessage != null) {
                adapter.updateContextVariables(lastStepMessage.getUuid(), this.fillContextVariables((MapDifference<String, Object>)diff));
            }
        }
        TCContextDiffCache.TC_CONTEXT_DIFF_CACHE.invalidate((Object)situationInstance.getID().toString());
    }

    private Object getBvResult(AbstractInstance situationInstance, String key) {
        if (situationInstance.getContext() == null || situationInstance.getContext().getSP() == null) {
            return null;
        }
        return situationInstance.getContext().getSP().get((Object)key);
    }

    private void setCustomLinkToCallChain(LogRecord logRecord, String projectUuid, BigInteger callChainId) {
        String prefixLink = String.format("/project/%s/itf#", projectUuid);
        ArrayList<CustomLink> customLinks = logRecord.getCustomLinks();
        if (Objects.isNull(customLinks)) {
            customLinks = new ArrayList<CustomLink>();
            logRecord.setCustomLinks(customLinks);
        }
        customLinks.add(new CustomLink("Open Step in ITF", String.format("%s/callchain/%s", prefixLink, callChainId), OpenMode.NEW_TAB));
    }

    private void setCustomLinkToSituation(Message logRecord, String projectUuid, SituationInstance situationInstance) {
        String prefixLink = String.format("/project/%s/itf#", projectUuid);
        ArrayList<CustomLink> customLinks = logRecord.getCustomLinks();
        if (Objects.isNull(customLinks)) {
            customLinks = new ArrayList<CustomLink>();
            logRecord.setCustomLinks(customLinks);
        }
        customLinks.add(new CustomLink("Open Step in ITF", this.getLinkToSituation(prefixLink, situationInstance), OpenMode.NEW_TAB));
    }

    private String getLinkToSituation(String prefix, SituationInstance situationInstance) {
        if (Objects.isNull(situationInstance.getSituationById()) || Objects.isNull(situationInstance.getOperationId()) || Objects.isNull(situationInstance.getSystemId())) {
            LOGGER.error("An error occurred while creating custom link.");
            return "";
        }
        return String.format("%s/system/%s/operation/%s/situation/%s", prefix, situationInstance.getSystemId(), situationInstance.getOperationId(), situationInstance.getSituationId());
    }

    private List<MessageParameter> fillMessageParameters(List<org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter> params) {
        ArrayList<MessageParameter> lst = new ArrayList<MessageParameter>();
        if (params != null && !params.isEmpty()) {
            for (org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter param : params) {
                MessageParameter msgParam = new MessageParameter();
                msgParam.setName(param.getParamName());
                msgParam.setValue(param.getMultipleValue().isEmpty() ? "" : (param.getMultipleValue().size() == 1 ? param.getSingleValue() : param.getMultipleValue().toString()));
                lst.add(msgParam);
            }
        }
        return lst;
    }

    private ContextVariable fillContextVariable(String key, Object beforeValue, Object afterValue) {
        ContextVariable contextVariable = new ContextVariable();
        contextVariable.setName(key);
        contextVariable.setBeforeValue(beforeValue == null ? null : beforeValue.toString());
        contextVariable.setAfterValue(afterValue == null ? null : afterValue.toString());
        return contextVariable;
    }

    private List<ContextVariable> fillContextVariables(SpContext spContext) {
        ArrayList<ContextVariable> lst = new ArrayList<ContextVariable>();
        if (spContext != null && !spContext.isEmpty()) {
            Map flatMap = FlatMapUtil.flatten((Map)spContext);
            for (Map.Entry entry : flatMap.entrySet()) {
                lst.add(this.fillContextVariable((String)entry.getKey(), null, entry.getValue()));
            }
        }
        return lst;
    }

    private List<ContextVariable> fillContextVariables(MapDifference<String, Object> diff) {
        ArrayList<ContextVariable> lst = new ArrayList<ContextVariable>();
        if (diff != null) {
            for (Map.Entry entry : diff.entriesOnlyOnLeft().entrySet()) {
                lst.add(this.fillContextVariable((String)entry.getKey(), entry.getValue(), null));
            }
            for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
                lst.add(this.fillContextVariable((String)entry.getKey(), null, entry.getValue()));
            }
            for (Map.Entry entry : diff.entriesDiffering().entrySet()) {
                lst.add(this.fillContextVariable((String)entry.getKey(), ((MapDifference.ValueDifference)entry.getValue()).leftValue(), ((MapDifference.ValueDifference)entry.getValue()).rightValue()));
            }
            for (Map.Entry entry : diff.entriesInCommon().entrySet()) {
                lst.add(this.fillContextVariable((String)entry.getKey(), entry.getValue(), entry.getValue()));
            }
        }
        return lst;
    }

    private void updateSectionName(AtpRamAdapter adapter, AbstractInstance containerInstance) {
        String newName;
        if (containerInstance instanceof SituationInstance) {
            newName = "Situation [" + containerInstance.getName() + "]";
        } else if (containerInstance instanceof StepInstance) {
            newName = containerInstance.getName();
        } else if (containerInstance instanceof CallChainInstance) {
            newName = "Call chain [" + containerInstance.getName() + "]";
        } else {
            return;
        }
        LogRecord logRecord = adapter.getContext().getCurrentSection();
        if ((logRecord.getName().startsWith("Call chain [") && containerInstance instanceof CallChainInstance || logRecord.getName().startsWith("Situation [") && containerInstance instanceof SituationInstance) && !newName.equals(logRecord.getName())) {
            logRecord.setName(newName);
        }
    }

    public HashMap<String, Object> createMapWithSnapshot(String simpleSnapShot) {
        File snapshot = null;
        try {
            snapshot = File.createTempFile("snapshot", null);
            FileUtils.writeStringToFile((File)snapshot, (String)simpleSnapShot, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error("Can not create temp file", (Throwable)e);
        }
        HashMap<String, Object> mapWithSnapshot = new HashMap<String, Object>();
        mapWithSnapshot.put("screenshot_name", "ram2Screenshot");
        mapWithSnapshot.put("screenshot_file", snapshot);
        mapWithSnapshot.put("screenshot_type", "text/html");
        LOGGER.debug("Map with snapshot: {}", mapWithSnapshot);
        return mapWithSnapshot;
    }

    private String getMessageByMepType(AbstractInstance containerInstance, SpContext spContext) {
        ATPReportMessage reportRecord = new ATPReportMessage(containerInstance){

            @Override
            public boolean logRecord() {
                return false;
            }
        };
        TcContext tc = containerInstance.getContext().getTC();
        reportRecord.setTcContext(tc);
        String snapShotAsString = null;
        if (containerInstance instanceof StepInstance) {
            Mep mep = ((StepInstance)containerInstance).getMep();
            switch (mep) {
                case OUTBOUND_REQUEST_ASYNCHRONOUS: 
                case INBOUND_RESPONSE_ASYNCHRONOUS: {
                    String contextMessage = this.GSON.toJson((Object)spContext);
                    org.qubership.automation.itf.core.model.jpa.message.Message message = spContext.getOutgoingMessage();
                    List messageParameters = spContext.getMessageParameters();
                    snapShotAsString = reportRecord.buildSimpleSnapShotRam2(message, messageParameters, contextMessage);
                    break;
                }
                case OUTBOUND_RESPONSE_ASYNCHRONOUS: 
                case INBOUND_REQUEST_ASYNCHRONOUS: {
                    String contextMessage = this.GSON.toJson((Object)spContext);
                    org.qubership.automation.itf.core.model.jpa.message.Message message = spContext.getIncomingMessage();
                    List messageParameters = spContext.getMessageParameters();
                    snapShotAsString = reportRecord.buildSimpleSnapShotRam2(message, messageParameters, contextMessage);
                    break;
                }
                case OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS: 
                case INBOUND_REQUEST_RESPONSE_SYNCHRONOUS: 
                case INBOUND_REQUEST_SYNCHRONOUS: 
                case INBOUND_RESPONSE_SYNCHRONOUS: {
                    org.qubership.automation.itf.core.model.jpa.message.Message message;
                    String contextMessage = this.GSON.toJson((Object)spContext);
                    List messageParameters = spContext.getMessageParameters();
                    org.qubership.automation.itf.core.model.jpa.message.Message message2 = message = mep.isOutbound() ? spContext.getOutgoingMessage() : spContext.getIncomingMessage();
                    if (mep.isBothDirection()) {
                        org.qubership.automation.itf.core.model.jpa.message.Message responseMessage = mep.isOutbound() ? spContext.getIncomingMessage() : spContext.getOutgoingMessage();
                        snapShotAsString = reportRecord.buildSimpleSnapShotRam2(message, messageParameters, contextMessage, responseMessage);
                        break;
                    }
                    snapShotAsString = reportRecord.buildSimpleSnapShotRam2(message, messageParameters, contextMessage);
                    break;
                }
                default: {
                    LOGGER.warn("Logged MEP value doesn't exist");
                }
            }
        }
        return snapShotAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callMessageWithMap(AbstractInstance containerInstance, String title, String message, String simpleSnapShotAsString, String status) {
        HashMap<String, Object> attributesHashMap = null;
        try {
            attributesHashMap = this.createMapWithSnapshot(simpleSnapShotAsString);
            this.message(containerInstance, title, message, status, attributesHashMap);
        }
        finally {
            if (attributesHashMap != null) {
                attributesHashMap.computeIfPresent("screenshot_file", (key, value) -> FileUtils.deleteQuietly((File)((File)value)));
            }
        }
    }

    public void info(AbstractInstance containerInstance, String title, SpContext spContext) {
        if (containerInstance instanceof StepInstance) {
            return;
        }
        String messageFromSpContext = this.getMessageFromSpContext(spContext);
        String simpleSnapShotAsString = this.getMessageByMepType(containerInstance, spContext);
        this.callMessageWithMap(containerInstance, title, messageFromSpContext, simpleSnapShotAsString, "PASSED");
    }

    public void info(AbstractInstance containerInstance, String title, String message) {
        this.message(containerInstance, title, message, "PASSED", Collections.emptyMap());
    }

    public void warn(AbstractInstance containerInstance, String title, String message) {
        this.message(containerInstance, title, message, "WARNING", Collections.emptyMap());
    }

    public void error(AbstractInstance containerInstance, String title, SpContext spContext, Throwable exception) {
        if (containerInstance instanceof StepInstance) {
            return;
        }
        String messageWithException = this.getMessage(this.getMessageFromSpContext(spContext), exception);
        String simpleSnapShotAsString = this.getMessageByMepType(containerInstance, spContext);
        this.callMessageWithMap(containerInstance, title, messageWithException, simpleSnapShotAsString, "FAILED");
    }

    public void error(AbstractInstance containerInstance, String title, String message, Throwable exception) {
        this.message(containerInstance, title, this.getMessage(message, exception), "FAILED", Collections.emptyMap());
    }

    public void terminated(AbstractInstance containerInstance, String title, String message, Throwable exception) {
        this.message(containerInstance, title, this.getMessage(message, exception), "FAILED", Collections.emptyMap());
    }

    private String getMessageFromSpContext(SpContext spContext) {
        if (spContext == null) {
            return "";
        }
        org.qubership.automation.itf.core.model.jpa.message.Message incomingMessage = spContext.getIncomingMessage();
        if (incomingMessage == null || incomingMessage.getText() == null) {
            return "";
        }
        return incomingMessage.getText();
    }

    private void message(AbstractInstance containerInstance, String title, String message, String status, Map<String, Object> params) {
        if (!this.prepareTestRunContext(containerInstance, true)) {
            return;
        }
        Object sessionId = containerInstance.getContext().getTC().getID();
        InstanceRam2Extension extension = (InstanceRam2Extension)ExtensionManager.getInstance().getExtension((Object)containerInstance, InstanceRam2Extension.class);
        TestRunContext testRunContext = this.getAdapter(sessionId).getContext();
        String parentId = extension.getSectionId();
        if (parentId == null && containerInstance.getParent() != null) {
            parentId = ((InstanceRam2Extension)ExtensionManager.getInstance().getExtension((Object)containerInstance.getParent(), InstanceRam2Extension.class)).getSectionId();
        }
        if (parentId == null) {
            parentId = testRunContext.getAtpCompaund().getSectionId();
        }
        if (containerInstance instanceof CallChainInstance && "FAILED".equals(status) && !testRunContext.getSections().empty()) {
            parentId = ((LogRecord)testRunContext.getSections().peek()).getUuid().toString();
        } else if (containerInstance instanceof StepInstance && "FAILED".equals(status)) {
            parentId = testRunContext.getLastSectionInStep();
        }
        testRunContext.addSection((LogRecord)this.createRecord(title, parentId, containerInstance));
        LOGGER.debug("In message: after add section CurrentSectionId {}", (Object)testRunContext.getCurrentSectionId());
        Message logRecord = new Message(testRunContext.getCurrentSectionId(), testRunContext.getLastSectionInStep(), title, message, status, "TECHNICAL", false);
        if ("FAILED".equals(status) && !(containerInstance instanceof CallChainInstance)) {
            if (containerInstance instanceof SituationInstance) {
                this.getAdapter(sessionId).message(logRecord);
            } else {
                this.getAdapter(sessionId).restMessage(this.createMessage(title, containerInstance, status, "", testRunContext.getCurrentSectionId(), testRunContext.getLastSectionInStep(), RAM2ReportAdapter.getShortTransportName(containerInstance)));
            }
        } else if (containerInstance instanceof CallChainInstance || title.startsWith("Timeout for")) {
            if (title.equals("Report links after execution")) {
                logRecord.setParentRecordId(testRunContext.getAtpCompaund().getSectionId());
            }
            this.getAdapter(sessionId).message(logRecord);
        } else {
            JSONObject bvResult = JSONObject.fromObject((Object)this.getBvResult(containerInstance, "bvResultForRam2"));
            if (!bvResult.isEmpty()) {
                this.getAdapter(sessionId).restMessage(this.updateBVStatus(containerInstance, this.createMessage(title, containerInstance, status, "", testRunContext.getCurrentSectionId(), testRunContext.getLastSectionInStep(), RAM2ReportAdapter.getShortTransportName(containerInstance)), bvResult), bvResult);
            } else {
                this.getAdapter(sessionId).restMessage(this.createMessage(title, containerInstance, status, "", testRunContext.getCurrentSectionId(), testRunContext.getLastSectionInStep(), RAM2ReportAdapter.getShortTransportName(containerInstance)));
            }
        }
        LOGGER.debug("RAM2: TR_ID: '{}', SectionId: '{}', LR_NAME: '{}', LR_UUID: '{}', Message: {}, Params: {}", new Object[]{testRunContext.getTestRunId(), testRunContext.getCurrentSectionId(), title, testRunContext.getLogRecordUuid(), message, params});
        testRunContext.removeSection();
        if ("FAILED".equals(status)) {
            testRunContext.getCurrentSection().setTestingStatusHard(TestingStatuses.FAILED);
        }
        this.getAdapter(sessionId).setContext(testRunContext);
        LOGGER.debug("In message: After close section CurrentSectionId {}", (Object)testRunContext.getCurrentSectionId());
    }

    private ItfLogRecord createRecord(String name, String parentId, AbstractInstance containerInstance) {
        ItfLogRecord record = new ItfLogRecord();
        record.setUuid(UUID.randomUUID());
        record.setParentRecordId(UUID.fromString(parentId));
        record.setName(name);
        record.setMessage("");
        record.setTestingStatus(null);
        record.setType(TypeAction.ITF);
        record.setStartDate(new Timestamp(System.currentTimeMillis()));
        record.setRequest(this.createRequest(containerInstance));
        record.setResponse(this.createResponse(containerInstance));
        if (containerInstance instanceof SituationInstance && !((SituationInstance)containerInstance).getLabels().isEmpty()) {
            record.setValidationLabels(new HashSet(((SituationInstance)containerInstance).getLabels()));
        }
        return record;
    }

    private Message createMessage(String title, AbstractInstance instance, String status, String linkToTool, String id, String parentId, String type) {
        Message message = new Message();
        message.setUuid(id);
        message.setName(title);
        message.setType("TRANSPORT");
        message.setParentRecordId(parentId);
        message.setTestingStatus(status);
        message.setProtocolType(type);
        if (StringUtils.isNotEmpty((CharSequence)linkToTool)) {
            message.setLinkToTool(linkToTool);
        }
        message.setRequest(this.createRequest(instance));
        message.setResponse(this.createResponse(instance));
        if (instance instanceof SituationInstance && !((SituationInstance)instance).getLabels().isEmpty()) {
            message.setValidationLabels(new HashSet(((SituationInstance)instance).getLabels()));
        }
        message.setMessageParameters(this.fillMessageParameters(instance.getContext().getSP().getMessageParameters()));
        message.setStepContextVariables(this.fillContextVariables(instance.getContext().getSP()));
        return message;
    }

    private boolean prepareTestRunContext(AbstractInstance instance, boolean checkCurrentSection) {
        LOGGER.debug("Start prepare TestRunContext; current context is null");
        TCContextRamExtension ramExtension = (TCContextRamExtension)ExtensionManager.getInstance().getExtension((Object)instance.getContext().getTC(), TCContextRamExtension.class);
        if (ramExtension == null) {
            LOGGER.error("ramExtension should not be null");
            return false;
        }
        TestRunContext testRunContext = ramExtension.getRunContext();
        if (null != testRunContext) {
            if (checkCurrentSection && testRunContext.getCurrentSection() == null) {
                LOGGER.warn("Current section should not be null; reporting action is skipped for instance {}", (Object)instance);
                return false;
            }
            LOGGER.info("Ram2TestRunId: {}, Ram2SectionId: {}", (Object)testRunContext.getTestRunId(), (Object)testRunContext.getCurrentSectionId());
            this.getAdapter(instance.getContext().getTC().getID()).setContext(testRunContext);
        } else {
            LOGGER.error("TestRun Context should not be null! Reporting to RAM2 is skipped.");
        }
        return testRunContext != null;
    }

    public void startRun(TcContext context) {
        TCContextRamExtension ramExtension = (TCContextRamExtension)ExtensionManager.getInstance().getExtension((Object)context, TCContextRamExtension.class);
        if (ramExtension == null) {
            return;
        }
        Preconditions.checkNotNull((Object)ramExtension.getRunContext(), (Object)"runContext should not be null");
        LOGGER.debug("startRun: ramExtension run external {} ", (Object)ramExtension.getExternalRun());
        TestRunContext ram2Context = ramExtension.getRunContext();
        if (ramExtension.getExternalRun() == null || Strings.isNullOrEmpty((String)ramExtension.getRunContext().getTestRunId())) {
            Preconditions.checkNotNull((Object)ramExtension.getRunId(), (Object)"TestRunId should not be empty");
            String suiteName = ramExtension.getSuiteName();
            if (suiteName == null) {
                suiteName = context.getInitiator().getStepContainer().getName();
            }
            suiteName = this.trimIfNameIsLong(suiteName);
            String storyName = context.getInitiator().getStepContainer().getName();
            if (context.getInitiator() instanceof CallChainInstance && ((CallChainInstance)context.getInitiator()).getDatasetName() != null) {
                storyName = storyName + ':' + ((CallChainInstance)context.getInitiator()).getDatasetName();
            }
            storyName = this.trimIfNameIsLong(storyName);
            String erName = ramExtension.getErName();
            if (erName == null) {
                erName = suiteName + '_' + DateTimeFormatter.ofPattern("dd/MM/yy_hh:mm:ss").format(LocalDateTime.now());
            }
            erName = this.trimIfNameIsLong(erName);
            if (Strings.isNullOrEmpty((String)ram2Context.getExecutionRequestName())) {
                ram2Context.setExecutionRequestName(erName);
            }
            if (Strings.isNullOrEmpty((String)ram2Context.getTestRunName())) {
                ram2Context.setTestRunName(storyName);
            }
            if (Strings.isNullOrEmpty((String)ram2Context.getTestSuiteName())) {
                ram2Context.setTestSuiteName(suiteName);
            }
            this.logName = storyName;
            StartRunRequest startRunRequest = this.createStartRunRequest(ram2Context);
            LOGGER.debug("RAM2_info: run id {}, ER id {}", (Object)ramExtension.getRunId(), (Object)ram2Context.getAtpExecutionRequestId());
            TestRunContext testRunContext = this.getAdapter(context.getID()).startAtpRun(startRunRequest, ram2Context);
            this.getAdapter(context.getID()).setContext(testRunContext);
        }
    }

    public void startAtpRun(String testRunId) {
        TestRunContext ram2Context = TestRunContextHolder.getContext((String)testRunId);
        LOGGER.debug("Creating StartRunRequest for TR {}", (Object)testRunId);
        StartRunRequest startRunRequest = this.createStartRunRequest(ram2Context);
        this.getAdapter(ram2Context.getTestRunId()).startAtpRun(startRunRequest, ram2Context);
    }

    private StartRunRequest createStartRunRequest(TestRunContext ram2Context) {
        StartRunRequest.RequestBuilder startRunRequest = StartRunRequest.getRequestBuilder().setProjectName(ram2Context.getProjectName()).setTestPlanName(ram2Context.getTestPlanName()).setTestCaseName(ram2Context.getTestCaseName()).setTestSuiteName(ram2Context.getTestSuiteName()).setExecutionRequestName(ram2Context.getExecutionRequestName()).setTestRunName(ram2Context.getTestRunName()).setAtpExecutionRequestId(UUID.fromString(ram2Context.getAtpExecutionRequestId())).setTestRunId(ram2Context.getTestRunId());
        if (StringUtils.isNotEmpty((CharSequence)ram2Context.getProjectId())) {
            startRunRequest.setProjectId(UUID.fromString(ram2Context.getProjectId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)ram2Context.getTestPlanId())) {
            startRunRequest.setTestPlanId(UUID.fromString(ram2Context.getTestPlanId()));
        }
        return startRunRequest.build();
    }

    @Nullable
    private String trimIfNameIsLong(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (name.length() > 200) {
            return name.substring(0, ATP_NAME_TRIM_SIZE) + DOTS;
        }
        return name;
    }

    public void stopRun(InstanceContext context, Status status) {
        AtpRamAdapter adapter = this.getAdapter(context.getTC().getID());
        TestRunContext testRunContext = adapter.getContext();
        while (!StringUtils.isBlank((CharSequence)testRunContext.getCurrentSectionId())) {
            testRunContext.getCurrentSection().setName(TemplateEngineFactory.process(null, (String)testRunContext.getCurrentSection().getName(), (JsonContext)context));
            adapter.setContext(adapter.closeSection());
        }
        this.adapters.remove(context.getTC().getID());
    }

    public void stopAllRuns() {
    }

    public Message updateBVStatus(AbstractInstance instance, Message message, JSONObject bvResult) {
        if (instance instanceof SituationInstance) {
            SituationInstance situationInstance = (SituationInstance)instance;
            if (situationInstance.getSituationById().getValidateIncoming().equals((Object)SituationLevelValidation.FAIL) && bvResult.containsKey((Object)"compareResult") && !bvResult.get("compareResult").equals("IDENTICAL")) {
                message.setTestingStatus("FAILED");
            } else {
                message.setTestingStatus("WARNING");
            }
        }
        return message;
    }

    public void reportCallChainInfo(CallChainInstance instance) {
        if (this.isInitiator((AbstractInstance)instance)) {
            this.info((AbstractInstance)instance, "Report links", ReportLinkCreator.getInstance().buildReportLinks(instance.getContext().tc()));
            this.info((AbstractInstance)instance, "Info", ATPReportUtil.buildRunParamsInfo(instance));
        }
    }

    private boolean isInitiator(AbstractInstance instance) {
        return instance.getContext().tc().getInitiator().getID().equals(instance.getID());
    }

    private Request createRequest(AbstractInstance instance) {
        Mep mep;
        if (instance.getContext().getSP() == null) {
            return null;
        }
        Request request = new Request();
        request.setHeadersList(new ArrayList());
        org.qubership.automation.itf.core.model.jpa.message.Message message = null;
        if (instance instanceof StepInstance) {
            message = this.defineMessage(instance, instance.getContext().getSP(), true);
        }
        if (message != null) {
            if (message.getText() != null) {
                request.setBody(message.getText());
            }
            request.getHeadersList().addAll(this.convertMapToRequestHeaders(message.getHeaders()));
            RequestHeader camelHttpMethodHeader = this.extractHeaderByName(request.getHeadersList(), "CamelHttpMethod");
            if (camelHttpMethodHeader != null) {
                request.setMethod(camelHttpMethodHeader.getValue());
            }
        }
        request.setTimestamp(new Timestamp(new Date().getTime()));
        if (instance.getContext().getSP().containsKey((Object)"endpointForRam")) {
            request.setEndpoint(instance.getContext().getSP().get((Object)"endpointForRam").toString());
        }
        if (instance instanceof StepInstance && (mep = ((StepInstance)instance).getMep()) != null && mep.isOutbound() && instance.getTransportConfiguration() != null) {
            request.getHeadersList().addAll(this.convertMapToRequestHeaders(instance.getTransportConfiguration()));
        }
        return request;
    }

    private Response createResponse(AbstractInstance instance) {
        Mep mep;
        if (instance.getContext().getSP() == null) {
            return null;
        }
        Response response = new Response();
        response.setHeadersList(new ArrayList());
        org.qubership.automation.itf.core.model.jpa.message.Message message = null;
        if (instance instanceof StepInstance) {
            message = this.defineMessage(instance, instance.getContext().getSP(), false);
        }
        if (message != null) {
            if (message.getText() != null) {
                response.setBody(message.getText());
            }
            response.getHeadersList().addAll(this.convertMapToRequestHeaders(message.getHeaders()));
            RequestHeader camelHttpResponseCode = this.extractHeaderByName(response.getHeadersList(), "CamelHttpResponseCode");
            if (camelHttpResponseCode != null) {
                response.setCode(camelHttpResponseCode.getValue());
            }
        }
        response.setTimestamp(new Timestamp(new Date().getTime()));
        if (instance.getContext().getSP().containsKey((Object)"endpointForRam")) {
            response.setEndpoint(instance.getContext().getSP().get((Object)"endpointForRam").toString());
        }
        if (instance instanceof StepInstance && (mep = ((StepInstance)instance).getMep()) != null && mep.isInbound() && instance.getTransportConfiguration() != null) {
            response.getHeadersList().addAll(this.convertMapToRequestHeaders(instance.getTransportConfiguration()));
        }
        return response;
    }

    private org.qubership.automation.itf.core.model.jpa.message.Message defineMessage(AbstractInstance instance, SpContext spContext, boolean isRequest) {
        org.qubership.automation.itf.core.model.jpa.message.Message message = null;
        Mep mep = ((StepInstance)instance).getMep();
        switch (mep) {
            case OUTBOUND_REQUEST_ASYNCHRONOUS: 
            case INBOUND_RESPONSE_ASYNCHRONOUS: {
                message = isRequest ? spContext.getOutgoingMessage() : spContext.getIncomingMessage();
                break;
            }
            case OUTBOUND_RESPONSE_ASYNCHRONOUS: 
            case INBOUND_REQUEST_ASYNCHRONOUS: {
                message = isRequest ? spContext.getIncomingMessage() : spContext.getOutgoingMessage();
                break;
            }
            case OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS: 
            case INBOUND_REQUEST_RESPONSE_SYNCHRONOUS: 
            case INBOUND_REQUEST_SYNCHRONOUS: 
            case INBOUND_RESPONSE_SYNCHRONOUS: {
                if (isRequest) {
                    message = mep.isOutbound() ? spContext.getOutgoingMessage() : spContext.getIncomingMessage();
                    break;
                }
                message = mep.isOutbound() ? spContext.getIncomingMessage() : spContext.getOutgoingMessage();
                break;
            }
            default: {
                LOGGER.warn("Unknown MEP '{}' of StepInstance {}!", (Object)mep, (Object)instance);
            }
        }
        return message;
    }

    private List<RequestHeader> convertMapToRequestHeaders(Map<String, ?> headers) {
        ArrayList<RequestHeader> list = new ArrayList<RequestHeader>();
        String description = "";
        for (Map.Entry<String, ?> header : headers.entrySet()) {
            if (header.getValue() instanceof List) {
                for (Object elem : (List)header.getValue()) {
                    list.add(new RequestHeader(header.getKey(), elem.toString(), description));
                }
                continue;
            }
            list.add(new RequestHeader(header.getKey(), header.getValue().toString(), description));
        }
        return list;
    }

    private RequestHeader extractHeaderByName(List<RequestHeader> headers, String headerName) {
        return headers.stream().filter(requestHeader -> headerName.equals(requestHeader.getName())).findFirst().orElse(null);
    }

    public void terminate() {
    }

    public boolean needToReport(TcContext context) {
        switch (context.getStartedFrom()) {
            case ITF_STUB: 
            case EXECUTOR: 
            case ITF_UI: {
                return false;
            }
            case RAM2: {
                return true;
            }
        }
        return false;
    }

    private String getMessage(String message, Throwable exception) {
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message);
        }
        if (exception != null) {
            sb.append("<pre>").append(ExceptionUtils.getStackTrace((Throwable)exception)).append("</pre>");
        }
        return sb.toString();
    }

    private String getErrorMessage(String errorName, String errorMessage, Throwable exception) {
        StringBuilder sb = new StringBuilder();
        if (errorName != null) {
            sb.append(errorName);
        }
        if (errorMessage != null) {
            sb.append("<pre>").append(errorMessage).append("</pre>");
        } else if (exception != null) {
            sb.append("<pre>").append(ExceptionUtils.getStackTrace((Throwable)exception)).append("</pre>");
        }
        return sb.toString();
    }
}

